/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.codegenerator.controller;

import io.ballerina.asyncapi.codegenerator.configuration.BallerinaAsyncApiException;
import io.ballerina.asyncapi.codegenerator.controller.BalController;
import io.ballerina.asyncapi.codegenerator.entity.ServiceType;
import io.ballerina.asyncapi.codegenerator.usecase.GenerateMatchStatementNode;
import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.BindingPatternNode;
import io.ballerina.compiler.syntax.tree.BuiltinSimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.CaptureBindingPatternNode;
import io.ballerina.compiler.syntax.tree.CheckExpressionNode;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyBlockNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.MatchStatementNode;
import io.ballerina.compiler.syntax.tree.MethodCallExpressionNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.PositionalArgumentNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypedBindingPatternNode;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;
import java.util.List;
import org.ballerinalang.formatter.core.Formatter;
import org.ballerinalang.formatter.core.FormatterException;

public class DispatcherController
implements BalController {
    private final List<ServiceType> serviceTypes;
    private final String eventIdentifierType;
    private final String eventIdentifierPath;

    public DispatcherController(List<ServiceType> serviceTypes, String eventIdentifierType, String eventIdentifierPath) {
        this.serviceTypes = serviceTypes;
        this.eventIdentifierType = eventIdentifierType;
        this.eventIdentifierPath = eventIdentifierPath;
    }

    @Override
    public String generateBalCode(String balTemplate) throws BallerinaAsyncApiException {
        FunctionDefinitionNode functionDefinitionNode;
        TextDocument textDocument = TextDocuments.from((String)balTemplate);
        SyntaxTree syntaxTree = SyntaxTree.from((TextDocument)textDocument);
        ModulePartNode oldRoot = (ModulePartNode)syntaxTree.rootNode();
        String eventIdentifierPath = "genericDataType".concat(".").concat(this.eventIdentifierPath);
        if (this.eventIdentifierType.equals("header")) {
            eventIdentifierPath = "eventIdentifier";
            FunctionDefinitionNode postFunctionDefinitionNode = this.getPostFuncNode(oldRoot);
            if (postFunctionDefinitionNode == null) {
                throw new BallerinaAsyncApiException("Resource function 'post', is not found in the dispatcher_service.bal");
            }
            FunctionBodyBlockNode postFunctionBodyBlockNode = (FunctionBodyBlockNode)postFunctionDefinitionNode.functionBody();
            NodeList oldStatement = postFunctionBodyBlockNode.statements();
            oldStatement = oldStatement.remove(1);
            NodeList newStatement = oldStatement.add(1, (Node)this.getEventIdentifierNode());
            FunctionBodyBlockNode postFunctionBodyBlockNodeNew = postFunctionBodyBlockNode.modify().withStatements(newStatement).apply();
            ModulePartNode midRoot = (ModulePartNode)oldRoot.replace((Node)postFunctionBodyBlockNode, (Node)postFunctionBodyBlockNodeNew);
            syntaxTree = syntaxTree.replaceNode((Node)oldRoot, (Node)midRoot);
            oldRoot = (ModulePartNode)syntaxTree.rootNode();
        }
        if ((functionDefinitionNode = this.getResourceFuncNode(oldRoot)) == null) {
            throw new BallerinaAsyncApiException("Resource function 'matchRemoteFunc', is not found in the dispatcher_service.bal");
        }
        GenerateMatchStatementNode generateMatchStatement = new GenerateMatchStatementNode(this.serviceTypes, eventIdentifierPath);
        MatchStatementNode matchStatementNode = (MatchStatementNode)generateMatchStatement.generate();
        FunctionBodyBlockNode functionBodyBlockNode = (FunctionBodyBlockNode)functionDefinitionNode.functionBody();
        NodeList oldStatements = functionBodyBlockNode.statements();
        NodeList newStatements = oldStatements.add((Node)matchStatementNode);
        FunctionBodyBlockNode functionBodyBlockNodeNew = functionBodyBlockNode.modify().withStatements(newStatements).apply();
        ModulePartNode newRoot = (ModulePartNode)oldRoot.replace((Node)functionBodyBlockNode, (Node)functionBodyBlockNodeNew);
        SyntaxTree modifiedTree = syntaxTree.replaceNode((Node)oldRoot, (Node)newRoot);
        try {
            return Formatter.format((SyntaxTree)modifiedTree).toSourceCode();
        }
        catch (FormatterException e) {
            throw new BallerinaAsyncApiException("Could not format the generated code, may be a syntax issue in the generated code", e);
        }
    }

    private FunctionDefinitionNode getResourceFuncNode(ModulePartNode oldRoot) {
        for (ModuleMemberDeclarationNode node : oldRoot.members()) {
            if (node.kind() != SyntaxKind.CLASS_DEFINITION) continue;
            for (Node funcNode : ((ClassDefinitionNode)node).members()) {
                if (funcNode.kind() != SyntaxKind.OBJECT_METHOD_DEFINITION || !((FunctionDefinitionNode)funcNode).functionName().text().equals("matchRemoteFunc")) continue;
                return (FunctionDefinitionNode)funcNode;
            }
        }
        return null;
    }

    private FunctionDefinitionNode getPostFuncNode(ModulePartNode oldRoot) {
        for (ModuleMemberDeclarationNode node : oldRoot.members()) {
            if (node.kind() != SyntaxKind.CLASS_DEFINITION) continue;
            for (Node funcNode : ((ClassDefinitionNode)node).members()) {
                if (funcNode.kind() != SyntaxKind.RESOURCE_ACCESSOR_DEFINITION || !((FunctionDefinitionNode)funcNode).functionName().text().equals("post")) continue;
                return (FunctionDefinitionNode)funcNode;
            }
        }
        return null;
    }

    private VariableDeclarationNode getEventIdentifierNode() {
        BuiltinSimpleNameReferenceNode typeBindingPattern = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.STRING_KEYWORD));
        CaptureBindingPatternNode bindingPattern = NodeFactory.createCaptureBindingPatternNode((Token)NodeFactory.createIdentifierToken((String)"eventIdentifier"));
        TypedBindingPatternNode typedBindingPatternNode = NodeFactory.createTypedBindingPatternNode((TypeDescriptorNode)typeBindingPattern, (BindingPatternNode)bindingPattern);
        SimpleNameReferenceNode variableName = NodeFactory.createSimpleNameReferenceNode((Token)NodeFactory.createIdentifierToken((String)"request"));
        SimpleNameReferenceNode methodName = NodeFactory.createSimpleNameReferenceNode((Token)NodeFactory.createIdentifierToken((String)"getHeader"));
        SimpleNameReferenceNode argumentName = NodeFactory.createSimpleNameReferenceNode((Token)NodeFactory.createIdentifierToken((String)("\"" + this.eventIdentifierPath + "\"")));
        PositionalArgumentNode eventIdentifierArgument = NodeFactory.createPositionalArgumentNode((ExpressionNode)argumentName);
        SeparatedNodeList arguments = NodeFactory.createSeparatedNodeList((Node[])new Node[]{eventIdentifierArgument});
        MethodCallExpressionNode methodCallExpression = NodeFactory.createMethodCallExpressionNode((ExpressionNode)variableName, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.DOT_TOKEN), (NameReferenceNode)methodName, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN), (SeparatedNodeList)arguments, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN));
        CheckExpressionNode initializer = NodeFactory.createCheckExpressionNode(null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CHECK_KEYWORD), (ExpressionNode)methodCallExpression);
        VariableDeclarationNode eventIdentifierNode = NodeFactory.createVariableDeclarationNode((NodeList)AbstractNodeFactory.createEmptyNodeList(), null, (TypedBindingPatternNode)typedBindingPatternNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (ExpressionNode)initializer, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
        return eventIdentifierNode;
    }
}

