/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.codegenerator.usecase;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apicurio.datamodels.models.asyncapi.AsyncApiChannelItem;
import io.apicurio.datamodels.models.asyncapi.AsyncApiChannels;
import io.apicurio.datamodels.models.asyncapi.AsyncApiDocument;
import io.apicurio.datamodels.models.asyncapi.AsyncApiMessage;
import io.apicurio.datamodels.models.asyncapi.AsyncApiSchema;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20Schema;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20SchemaImpl;
import io.apicurio.datamodels.models.asyncapi.v20.io.AsyncApi20ModelReader;
import io.apicurio.datamodels.models.util.JsonUtil;
import io.ballerina.asyncapi.codegenerator.configuration.BallerinaAsyncApiException;
import io.ballerina.asyncapi.codegenerator.entity.MultiChannel;
import io.ballerina.asyncapi.codegenerator.entity.RemoteFunction;
import io.ballerina.asyncapi.codegenerator.entity.ServiceType;
import io.ballerina.asyncapi.codegenerator.usecase.Extractor;
import io.ballerina.asyncapi.codegenerator.usecase.utils.CodegenUtils;
import io.ballerina.asyncapi.codegenerator.usecase.utils.ExtensionExtractor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExtractChannelsFromSpec
implements Extractor {
    private final AsyncApiDocument asyncApiSpec;
    private final CodegenUtils codegenUtils = new CodegenUtils();
    private Map<String, AsyncApiSchema> inlineSchemas;

    public ExtractChannelsFromSpec(AsyncApiDocument asyncApiSpec) {
        this.asyncApiSpec = asyncApiSpec;
        this.inlineSchemas = new HashMap<String, AsyncApiSchema>();
    }

    public MultiChannel extract() throws BallerinaAsyncApiException {
        ArrayList<ServiceType> serviceTypes = new ArrayList<ServiceType>();
        AsyncApiChannels channels = this.asyncApiSpec.getChannels();
        List<String> channelNames = channels.getItemNames();
        List channelItems = channels.getItems();
        for (int i = 0; i < channelNames.size(); ++i) {
            ArrayList<RemoteFunction> remoteFunctions = new ArrayList<RemoteFunction>();
            String serviceTypeName = !ExtensionExtractor.getExtensions(channelItems.get(i)).containsKey("x-ballerina-service-type") ? this.codegenUtils.getValidName(channelNames.get(i), true) : ExtensionExtractor.getExtensions(channelItems.get(i)).get("x-ballerina-service-type").asText();
            AsyncApiMessage mainMessage = ((AsyncApiChannelItem)channelItems.get(i)).getSubscribe().getMessage();
            if (mainMessage.getOneOf() != null) {
                for (AsyncApiMessage message : mainMessage.getOneOf()) {
                    this.validateMessage(channelNames.get(i), (AsyncApiChannelItem)channelItems.get(i), message);
                    String xBallerinaEventType = ExtensionExtractor.getExtensions(message).get("x-ballerina-event-type").asText();
                    RemoteFunction remoteFunction = new RemoteFunction(xBallerinaEventType, this.getEventType(message, channelNames.get(i), xBallerinaEventType));
                    remoteFunctions.add(remoteFunction);
                }
            } else {
                this.validateMessage(channelNames.get(i), (AsyncApiChannelItem)channelItems.get(i), mainMessage);
                String xBallerinaEventType = ExtensionExtractor.getExtensions(((AsyncApiChannelItem)channelItems.get(i)).getSubscribe().getMessage()).get("x-ballerina-event-type").asText();
                RemoteFunction remoteFunction = new RemoteFunction(xBallerinaEventType, this.getEventType(mainMessage, channelNames.get(i), xBallerinaEventType));
                remoteFunctions.add(remoteFunction);
            }
            ServiceType serviceType = new ServiceType(serviceTypeName, remoteFunctions);
            serviceTypes.add(serviceType);
        }
        return new MultiChannel(serviceTypes, this.inlineSchemas);
    }

    private String getEventType(AsyncApiMessage message, String channelName, String xBallerinaEventType) throws BallerinaAsyncApiException {
        if (!JsonUtil.isPropertyDefined(message.getPayload(), "$ref")) {
            AsyncApi20Schema schemaModel = new AsyncApi20SchemaImpl().createSchema();
            AsyncApi20ModelReader reader = new AsyncApi20ModelReader();
            if (message.getPayload() instanceof ObjectNode) {
                reader.readSchema((ObjectNode)message.getPayload(), schemaModel);
            } else {
                ObjectMapper mapper = new ObjectMapper();
                ObjectNode messagePayLoadObject = mapper.createObjectNode();
                message.getPayload().fields().forEachRemaining(entry -> messagePayLoadObject.set((String)entry.getKey(), (JsonNode)entry.getValue()));
                reader.readSchema(messagePayLoadObject, schemaModel);
            }
            this.inlineSchemas.put(xBallerinaEventType, schemaModel);
            return xBallerinaEventType;
        }
        String ref = JsonUtil.getStringProperty((ObjectNode)message.getPayload(), "$ref");
        String[] refParts = ref.split("/");
        String schemaName = refParts[refParts.length - 1];
        if (this.asyncApiSpec.getComponents() == null || this.asyncApiSpec.getComponents().getSchemas() == null || !this.asyncApiSpec.getComponents().getSchemas().containsKey(schemaName)) {
            throw new BallerinaAsyncApiException("Could not find the schema '" + schemaName + "' in the the path #/components/schemas");
        }
        return schemaName;
    }

    private void validateMessage(String channelName, AsyncApiChannelItem channelItem, AsyncApiMessage message) throws BallerinaAsyncApiException {
        if (!ExtensionExtractor.getExtensions(message).containsKey("x-ballerina-event-type")) {
            throw new BallerinaAsyncApiException("Could not find the ".concat("x-ballerina-event-type").concat(" attribute in the message of the channel ").concat(channelName));
        }
        if (message.getPayload() == null) {
            throw new BallerinaAsyncApiException("Could not find the payload reference in the message of the channel ".concat(channelName));
        }
    }
}

