/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.websocketscore;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.models.Schema;
import io.apicurio.datamodels.models.ServerVariable;
import io.apicurio.datamodels.models.asyncapi.AsyncApiSchema;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25DocumentImpl;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25SchemaImpl;
import io.apicurio.datamodels.validation.ValidationProblem;
import io.ballerina.asyncapi.websocketscore.ErrorMessages;
import io.ballerina.asyncapi.websocketscore.GeneratorConstants;
import io.ballerina.asyncapi.websocketscore.exception.BallerinaAsyncApiExceptionWs;
import io.ballerina.asyncapi.websocketscore.model.GenSrcFile;
import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionStatementNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ImportOrgNameNode;
import io.ballerina.compiler.syntax.tree.Minutiae;
import io.ballerina.compiler.syntax.tree.MinutiaeList;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.SyntaxInfo;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;

public class GeneratorUtils {
    public static final MinutiaeList SINGLE_WS_MINUTIAE = GeneratorUtils.getSingleWSMinutiae();
    public static final List<String> BAL_KEYWORDS = SyntaxInfo.keywords();
    public static final MinutiaeList SINGLE_END_OF_LINE_MINUTIAE = GeneratorUtils.getEndOfLineMinutiae();

    public static ImportDeclarationNode getImportDeclarationNode(String orgName, String moduleName) {
        IdentifierToken importKeyword = AbstractNodeFactory.createIdentifierToken((String)"import", (MinutiaeList)SINGLE_WS_MINUTIAE, (MinutiaeList)SINGLE_WS_MINUTIAE);
        IdentifierToken orgNameToken = AbstractNodeFactory.createIdentifierToken((String)orgName);
        IdentifierToken slashToken = AbstractNodeFactory.createIdentifierToken((String)"/");
        ImportOrgNameNode importOrgNameNode = NodeFactory.createImportOrgNameNode((Token)orgNameToken, (Token)slashToken);
        IdentifierToken moduleNameToken = AbstractNodeFactory.createIdentifierToken((String)moduleName);
        SeparatedNodeList moduleNodeList = AbstractNodeFactory.createSeparatedNodeList((Node[])new Node[]{moduleNameToken});
        IdentifierToken semicolon = AbstractNodeFactory.createIdentifierToken((String)";");
        return NodeFactory.createImportDeclarationNode((Token)importKeyword, (ImportOrgNameNode)importOrgNameNode, (SeparatedNodeList)moduleNodeList, null, (Token)semicolon);
    }

    public static String convertAsyncAPITypeToBallerina(String type) throws BallerinaAsyncApiExceptionWs {
        if (GeneratorConstants.TYPE_MAP.containsKey(type)) {
            return GeneratorConstants.TYPE_MAP.get(type);
        }
        throw new BallerinaAsyncApiExceptionWs("Unsupported AsyncAPI data type `" + type + "`");
    }

    public static String escapeIdentifier(String identifier) {
        if (identifier.matches("\\b[0-9]*\\b")) {
            return "'" + identifier;
        }
        if (!identifier.matches("\\b[_a-zA-Z][_a-zA-Z0-9]*\\b") || BAL_KEYWORDS.contains(identifier)) {
            identifier = identifier.replaceAll("([\\[\\]\\\\?!<>@#&~`*\\-=^+();:\\/{}\\s|.$])", "\\\\$1");
            return "'" + identifier;
        }
        return identifier;
    }

    /*
     * WARNING - void declaration
     */
    public static String getValidName(String identifier, boolean isSchema) {
        if (!identifier.matches("\\b[0-9]*\\b")) {
            String[] split = identifier.split("([\\[\\]\\\\?!<>@#&~`*\\-=^+();:\\/{}\\s|.$])");
            StringBuilder validName = new StringBuilder();
            for (String string : split) {
                void var7_7;
                if (string.isBlank()) continue;
                if (split.length > 1) {
                    String string2 = string.substring(0, 1).toUpperCase(Locale.ENGLISH) + string.substring(1).toLowerCase(Locale.ENGLISH);
                }
                validName.append((String)var7_7);
            }
            identifier = validName.toString();
        }
        if (isSchema) {
            return identifier.substring(0, 1).toUpperCase(Locale.ENGLISH) + identifier.substring(1);
        }
        return GeneratorUtils.escapeIdentifier(identifier.substring(0, 1).toLowerCase(Locale.ENGLISH) + identifier.substring(1));
    }

    public static void updateTypeDefNodeList(String typeName, TypeDefinitionNode typeDefNode, List<TypeDefinitionNode> typeDefinitionNodeList) {
        boolean anyMatch = typeDefinitionNodeList.stream().anyMatch(node -> node.typeName().text().trim().equals(typeName));
        if (!anyMatch) {
            typeDefinitionNodeList.add(typeDefNode);
        }
    }

    public static boolean isValidSchemaName(String recordName) {
        return !recordName.matches("\\b[0-9]*\\b");
    }

    public static String extractReferenceType(String referenceVariable) throws BallerinaAsyncApiExceptionWs {
        if (referenceVariable.startsWith("#") && referenceVariable.contains("/")) {
            String[] refArray = referenceVariable.split("/");
            return refArray[refArray.length - 1];
        }
        throw new BallerinaAsyncApiExceptionWs("Invalid reference value : " + referenceVariable + "\nBallerina only supports local reference values.");
    }

    public static boolean hasTags(List<String> tags, List<String> filterTags) {
        return !Collections.disjoint(filterTags, tags);
    }

    public static AsyncApi25DocumentImpl getAsyncAPIFromAsyncAPIParser(Path definitionPath) throws IOException, BallerinaAsyncApiExceptionWs {
        AsyncApi25DocumentImpl document;
        Path contractPath = Paths.get(definitionPath.toString(), new String[0]);
        if (!Files.exists(contractPath, new LinkOption[0])) {
            throw new BallerinaAsyncApiExceptionWs(ErrorMessages.invalidFilePath(definitionPath.toString()));
        }
        if (!(definitionPath.toString().endsWith(".yaml") || definitionPath.toString().endsWith(".json") || definitionPath.toString().endsWith(".yml"))) {
            throw new BallerinaAsyncApiExceptionWs(ErrorMessages.invalidFileType());
        }
        String asyncAPIFileContent = Files.readString(definitionPath);
        ObjectMapper yamlReader = new ObjectMapper((JsonFactory)new YAMLFactory());
        Object obj = yamlReader.readValue(asyncAPIFileContent, Object.class);
        ObjectMapper jsonWriter = new ObjectMapper();
        try {
            document = (AsyncApi25DocumentImpl)Library.readDocumentFromJSONString(jsonWriter.writeValueAsString(obj));
        }
        catch (ClassCastException e) {
            throw new BallerinaAsyncApiExceptionWs("AsyncAPI definition has errors. Ballerina client code can only be generate for 2.5.0 version");
        }
        List<ValidationProblem> validationProblems = Library.validate(document, null);
        if (!validationProblems.isEmpty()) {
            StringBuilder errorMessage = new StringBuilder("AsyncAPI definition has errors: \n");
            for (ValidationProblem validationProblem : validationProblems) {
                errorMessage.append(validationProblem.message).append(GeneratorConstants.LINE_SEPARATOR);
            }
            throw new BallerinaAsyncApiExceptionWs(errorMessage.toString());
        }
        return document;
    }

    public static String getStreamGeneratorName(String returnType) {
        if (returnType.contains("|")) {
            returnType = returnType.replaceAll("\\|", "");
        }
        return returnType.substring(0, 1).toUpperCase(Locale.ENGLISH) + returnType.substring(1);
    }

    public static ExpressionStatementNode getSimpleExpressionStatementNode(String expression) {
        SimpleNameReferenceNode expressionNode = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)expression));
        return NodeFactory.createExpressionStatementNode(null, (ExpressionNode)expressionNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }

    public static String buildUrl(String absUrl, Map<String, ServerVariable> variables) {
        String url = absUrl;
        if (variables != null) {
            for (Map.Entry<String, ServerVariable> entry : variables.entrySet()) {
                String replaceKey = "\\{" + entry.getKey() + "}";
                url = url.replaceAll(replaceKey, entry.getValue().getDefault());
            }
        }
        return url;
    }

    private static MinutiaeList getSingleWSMinutiae() {
        Minutiae whitespace = AbstractNodeFactory.createWhitespaceMinutiae((String)" ");
        MinutiaeList leading = AbstractNodeFactory.createMinutiaeList((Minutiae[])new Minutiae[]{whitespace});
        return leading;
    }

    private static MinutiaeList getEndOfLineMinutiae() {
        Minutiae endOfLineMinutiae = AbstractNodeFactory.createEndOfLineMinutiae((String)GeneratorConstants.LINE_SEPARATOR);
        MinutiaeList leading = AbstractNodeFactory.createMinutiaeList((Minutiae[])new Minutiae[]{endOfLineMinutiae});
        return leading;
    }

    public static void setGeneratedFileName(List<File> listFiles, GenSrcFile gFile, int duplicateCount) {
        for (File listFile : listFiles) {
            String listFileName = listFile.getName();
            if (!listFileName.contains(".") || listFileName.split("\\.").length < 2 || !listFileName.split("\\.")[0].equals(gFile.getFileName().split("\\.")[0])) continue;
            duplicateCount = 1 + duplicateCount;
        }
        gFile.setFileName(gFile.getFileName().split("\\.")[0] + "." + duplicateCount + "." + gFile.getFileName().split("\\.")[1]);
    }

    public static boolean checkImportDuplicate(List<ImportDeclarationNode> imports, String module) {
        for (ImportDeclarationNode importModule : imports) {
            StringBuilder moduleBuilder = new StringBuilder();
            for (IdentifierToken identifierToken : importModule.moduleName()) {
                moduleBuilder.append(identifierToken.toString().trim());
            }
            if (!"ballerina".equals(((ImportOrgNameNode)importModule.orgName().get()).orgName().toString().trim()) || !module.equals(moduleBuilder.toString())) continue;
            return true;
        }
        return false;
    }

    public static void addImport(List<ImportDeclarationNode> imports, String module) {
        if (!GeneratorUtils.checkImportDuplicate(imports, module)) {
            ImportDeclarationNode importModule = GeneratorUtils.getImportDeclarationNode("ballerina", module);
            imports.add(importModule);
        }
    }

    public static boolean isComplexURL(String path) {
        String[] subPathSegment = path.split("/");
        Pattern pattern = Pattern.compile("[^a-zA-Z0-9]");
        for (String subPath : subPathSegment) {
            if (!subPath.contains("{") || !pattern.matcher(subPath.split("}", 2)[1]).find()) continue;
            return true;
        }
        return false;
    }

    public static List<StatementNode> generateBodyStatementForComplexUrl(String path) {
        String[] subPathSegment = path.split("/");
        Pattern pattern = Pattern.compile("[^a-zA-Z0-9]");
        ArrayList<StatementNode> bodyStatements = new ArrayList<StatementNode>();
        for (String subPath : subPathSegment) {
            if (!subPath.contains("{") || !pattern.matcher(subPath.split("}", 2)[1]).find()) continue;
            String pathParam = subPath;
            pathParam = pathParam.substring(pathParam.indexOf("{") + 1);
            pathParam = pathParam.substring(0, pathParam.indexOf("}"));
            pathParam = GeneratorUtils.getValidName(pathParam, false);
            String[] subPathSplit = subPath.split("}", 2);
            String pathParameter = GeneratorUtils.getValidName(subPath, false);
            String restSubPath = subPathSplit[1];
            String resSubPathLength = String.valueOf(restSubPath.length() - 1);
            String ifBlock = "if !" + pathParameter + ".endsWith(\"" + restSubPath + "\") { return error(\"bad URL\"); }";
            StatementNode ifBlockStatement = NodeParser.parseStatement((String)ifBlock);
            String pathParameterState = "string " + pathParam + " = " + pathParameter + ".substring(0, " + pathParameter + ".length() - " + resSubPathLength + ");";
            StatementNode pathParamStatement = NodeParser.parseStatement((String)pathParameterState);
            bodyStatements.add(ifBlockStatement);
            bodyStatements.add(pathParamStatement);
        }
        return bodyStatements;
    }

    public static boolean hasConstraints(Schema schema) {
        AsyncApi25SchemaImpl value = (AsyncApi25SchemaImpl)schema;
        if (value.getProperties() != null) {
            boolean constraintExists = value.getProperties().values().stream().anyMatch(GeneratorUtils::hasConstraints);
            if (constraintExists) {
                return true;
            }
        } else if (value.getProperties() != null && (value.getOneOf() != null || value.getAllOf() != null || value.getAnyOf() != null)) {
            List<Schema> allOf = value.getAllOf();
            List<AsyncApiSchema> oneOf = value.getOneOf();
            List<AsyncApiSchema> anyOf = value.getAnyOf();
            boolean constraintExists = false;
            if (allOf != null) {
                constraintExists = allOf.stream().anyMatch(GeneratorUtils::hasConstraints);
            } else if (oneOf != null) {
                constraintExists = oneOf.stream().anyMatch(GeneratorUtils::hasConstraints);
            } else if (anyOf != null) {
                constraintExists = anyOf.stream().anyMatch(GeneratorUtils::hasConstraints);
            }
            if (constraintExists) {
                return true;
            }
        } else if (value.getType() != null && value.getType().equals("array") && !GeneratorUtils.isConstraintExists(value)) {
            return GeneratorUtils.isConstraintExists((AsyncApi25SchemaImpl)value.getItems());
        }
        return GeneratorUtils.isConstraintExists(value);
    }

    private static boolean isConstraintExists(AsyncApi25SchemaImpl propertyValue) {
        return propertyValue.getMaximum() != null || propertyValue.getMinimum() != null || propertyValue.getMaxLength() != null || propertyValue.getMinLength() != null || propertyValue.getMaxItems() != null || propertyValue.getMinItems() != null || propertyValue.getExclusiveMinimum() != null || propertyValue.getExclusiveMaximum() != null;
    }

    public static AsyncApi25DocumentImpl normalizeAsyncAPI(Path asyncAPIPath) throws IOException, BallerinaAsyncApiExceptionWs {
        AsyncApi25DocumentImpl asyncAPI = GeneratorUtils.getAsyncAPIFromAsyncAPIParser(asyncAPIPath);
        return asyncAPI;
    }

    public static String removeNonAlphanumeric(String input) {
        return input.replaceAll("[^a-zA-Z0-9]", "");
    }
}

