/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.websocketscore.generators.asyncspec.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.apicurio.datamodels.models.asyncapi.AsyncApiMessage;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25ComponentsImpl;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.Constants;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.diagnostic.AsyncApiConverterDiagnostic;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.diagnostic.DiagnosticMessages;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.diagnostic.IncompatibleRemoteDiagnostic;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.model.BalAsyncApi25MessageImpl;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.model.BalAsyncApi25SchemaImpl;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.model.BalBooleanSchema;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.service.AsyncApiComponentMapper;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.utils.ConverterCommonUtils;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.IntersectionTypeSymbol;
import io.ballerina.compiler.api.symbols.ReadonlyTypeSymbol;
import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.ArrayTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.MapTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.OptionalTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.RecordFieldNode;
import io.ballerina.compiler.syntax.tree.RecordTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.StreamTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.StreamTypeParamsNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.UnionTypeDescriptorNode;
import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;

public class AsyncApiResponseMapper {
    private static final Set<String> closeFrameTypes = Set.of("PredefinedCloseFrameType", "CustomCloseFrameType");
    private final Location location;
    private final SemanticModel semanticModel;
    private final AsyncApi25ComponentsImpl components;
    private final AsyncApiComponentMapper componentMapper;
    private final List<AsyncApiConverterDiagnostic> errors = new ArrayList<AsyncApiConverterDiagnostic>();

    public AsyncApiResponseMapper(Location location, AsyncApiComponentMapper componentMapper, SemanticModel semanticModel, AsyncApi25ComponentsImpl components) {
        this.location = location;
        this.semanticModel = semanticModel;
        this.componentMapper = componentMapper;
        this.components = components;
    }

    public static boolean isCloseFrameRecordType(TypeSymbol typeSymbol) {
        String moduleName = typeSymbol.getModule().flatMap(Symbol::getName).orElse("");
        String symbolName = typeSymbol.getName().orElse("");
        if ("websocket".equals(moduleName) && closeFrameTypes.contains(symbolName)) {
            return true;
        }
        TypeDescKind typeDescKind = typeSymbol.typeKind();
        if (TypeDescKind.TYPE_REFERENCE.equals((Object)typeDescKind)) {
            return AsyncApiResponseMapper.isCloseFrameRecordType(((TypeReferenceTypeSymbol)typeSymbol).typeDescriptor());
        }
        if (TypeDescKind.RECORD.equals((Object)typeDescKind)) {
            RecordTypeSymbol bRecordTypeSymbol = (RecordTypeSymbol)typeSymbol;
            if (bRecordTypeSymbol.fieldDescriptors().containsKey("type")) {
                return AsyncApiResponseMapper.isCloseFrameRecordType(((RecordFieldSymbol)bRecordTypeSymbol.fieldDescriptors().get("type")).typeDescriptor());
            }
        } else if (TypeDescKind.INTERSECTION.equals((Object)typeDescKind)) {
            return AsyncApiResponseMapper.isCloseFrameRecordType(((IntersectionTypeSymbol)typeSymbol).effectiveTypeDescriptor());
        }
        return false;
    }

    public void createResponse(BalAsyncApi25MessageImpl subscribeMessage, BalAsyncApi25MessageImpl componentMessage, Node remoteReturnType, String returnDescription, String isOptional, String responseType) {
        responseType = Objects.isNull(responseType) ? "simple-rpc" : responseType;
        String remoteReturnTypeString = ConverterCommonUtils.unescapeIdentifier(remoteReturnType.toString().trim());
        ObjectMapper objectMapper = ConverterCommonUtils.callObjectMapper();
        switch (remoteReturnType.kind()) {
            case FLOAT_TYPE_DESC: 
            case DECIMAL_TYPE_DESC: 
            case INT_TYPE_DESC: 
            case STRING_TYPE_DESC: 
            case BOOLEAN_TYPE_DESC: {
                BalAsyncApi25SchemaImpl remoteReturnSchema = ConverterCommonUtils.getAsyncApiSchema(remoteReturnTypeString);
                this.setResponseOfRequest(subscribeMessage, componentMessage, responseType, returnDescription, objectMapper, remoteReturnSchema, isOptional);
                break;
            }
            case JSON_TYPE_DESC: 
            case XML_TYPE_DESC: {
                BalAsyncApi25SchemaImpl jsonSchema = ConverterCommonUtils.getAsyncApiSchema(Constants.AsyncAPIType.OBJECT.toString());
                BalAsyncApi25SchemaImpl additionalPropertyObject = new BalAsyncApi25SchemaImpl();
                jsonSchema.setAdditionalProperties(additionalPropertyObject);
                this.setResponseOfRequest(subscribeMessage, componentMessage, responseType, returnDescription, objectMapper, jsonSchema, isOptional);
                break;
            }
            case SIMPLE_NAME_REFERENCE: {
                if (!(remoteReturnType instanceof SimpleNameReferenceNode)) break;
                SimpleNameReferenceNode recordNode = (SimpleNameReferenceNode)remoteReturnType;
                this.handleReferenceResponse(subscribeMessage, componentMessage, recordNode, returnDescription, isOptional);
                break;
            }
            case UNION_TYPE_DESC: {
                if (!(remoteReturnType instanceof UnionTypeDescriptorNode)) break;
                this.mapUnionReturns(subscribeMessage, componentMessage, (UnionTypeDescriptorNode)remoteReturnType, returnDescription, isOptional, responseType);
                break;
            }
            case RECORD_TYPE_DESC: {
                if (!(remoteReturnType instanceof RecordTypeDescriptorNode)) break;
                this.mapInlineRecordInReturn(subscribeMessage, componentMessage, (RecordTypeDescriptorNode)remoteReturnType, returnDescription, isOptional);
                break;
            }
            case ARRAY_TYPE_DESC: {
                if (!(remoteReturnType instanceof ArrayTypeDescriptorNode)) break;
                this.getApiResponsesForArrayTypes(subscribeMessage, componentMessage, (ArrayTypeDescriptorNode)remoteReturnType, returnDescription, isOptional);
                break;
            }
            case OPTIONAL_TYPE_DESC: {
                if (!(remoteReturnType instanceof OptionalTypeDescriptorNode)) break;
                this.createResponse(subscribeMessage, componentMessage, ((OptionalTypeDescriptorNode)remoteReturnType).typeDescriptor(), returnDescription, "true", responseType);
                break;
            }
            case MAP_TYPE_DESC: {
                if (!(remoteReturnType instanceof MapTypeDescriptorNode)) break;
                MapTypeDescriptorNode mapNode = (MapTypeDescriptorNode)remoteReturnType;
                BalAsyncApi25SchemaImpl objectSchema = ConverterCommonUtils.getAsyncApiSchema(Constants.AsyncAPIType.OBJECT.toString());
                BalAsyncApi25SchemaImpl apiSchema = ConverterCommonUtils.getAsyncApiSchema(mapNode.mapTypeParamsNode().typeNode().kind());
                objectSchema.setAdditionalProperties(apiSchema.getType() == null ? new BalBooleanSchema(Boolean.TRUE) : apiSchema);
                this.setResponseOfRequest(subscribeMessage, componentMessage, responseType, returnDescription, objectMapper, objectSchema, isOptional);
                break;
            }
            case STREAM_TYPE_DESC: {
                if (!(remoteReturnType instanceof StreamTypeDescriptorNode)) break;
                if (((StreamTypeDescriptorNode)remoteReturnType).streamTypeParamsNode().isPresent()) {
                    Node remoteReturnStream = ((StreamTypeParamsNode)((StreamTypeDescriptorNode)remoteReturnType).streamTypeParamsNode().get()).leftTypeDescNode();
                    if (remoteReturnStream instanceof UnionTypeDescriptorNode) {
                        this.mapUnionReturns(subscribeMessage, componentMessage, (UnionTypeDescriptorNode)remoteReturnStream, returnDescription, isOptional, "server-streaming");
                    } else {
                        this.createResponse(subscribeMessage, componentMessage, remoteReturnStream, returnDescription, isOptional, "server-streaming");
                    }
                    componentMessage.addExtension("x-response-type", Constants.SERVER_STREAMING_TYPE_NODE);
                    break;
                }
                throw new NoSuchElementException("ERROR: No type present in stream");
            }
            case QUALIFIED_NAME_REFERENCE: {
                this.handleQualifiedNameTypeReference(subscribeMessage, componentMessage, returnDescription, remoteReturnType, isOptional);
                break;
            }
            default: {
                DiagnosticMessages errorMessage = DiagnosticMessages.AAS_CONVERTOR_108;
                IncompatibleRemoteDiagnostic error = new IncompatibleRemoteDiagnostic(errorMessage, this.location, remoteReturnType.kind().toString());
                this.errors.add(error);
            }
        }
    }

    private void handleQualifiedNameTypeReference(BalAsyncApi25MessageImpl subscribeMessage, BalAsyncApi25MessageImpl componentMessage, String returnDescription, Node remoteReturnType, String isOptional) {
        TypeSymbol qualifiedNameReferenceSymbol = (TypeSymbol)this.semanticModel.symbol(remoteReturnType).get();
        String remoteReturnTypeName = ConverterCommonUtils.unescapeIdentifier((String)qualifiedNameReferenceSymbol.getName().get());
        if (qualifiedNameReferenceSymbol instanceof TypeReferenceTypeSymbol) {
            TypeReferenceTypeSymbol typeRef = (TypeReferenceTypeSymbol)qualifiedNameReferenceSymbol;
            TypeSymbol typeSymbol = typeRef.typeDescriptor();
            if (typeSymbol.typeKind() == TypeDescKind.INTERSECTION) {
                List memberTypes = ((IntersectionTypeSymbol)typeSymbol).memberTypeDescriptors();
                for (TypeSymbol memberType : memberTypes) {
                    if (memberType instanceof ReadonlyTypeSymbol) continue;
                    typeSymbol = memberType;
                    break;
                }
            }
            if (remoteReturnType.parent().kind().equals((Object)SyntaxKind.ARRAY_TYPE_DESC)) {
                this.updateArraySchema(subscribeMessage, componentMessage, returnDescription, qualifiedNameReferenceSymbol, remoteReturnTypeName, isOptional);
            } else if (typeSymbol.typeKind() == TypeDescKind.RECORD) {
                this.handleRecordTypeSymbol(subscribeMessage, componentMessage, returnDescription, qualifiedNameReferenceSymbol, (String)qualifiedNameReferenceSymbol.getName().get(), isOptional);
            } else if (typeSymbol.typeKind() == TypeDescKind.UNION) {
                UnionTypeSymbol unionTypeSymbol = (UnionTypeSymbol)typeSymbol;
                for (TypeSymbol memberType : unionTypeSymbol.memberTypeDescriptors()) {
                    TypeReferenceTypeSymbol typeReferenceTypeSymbol;
                    if (!(memberType instanceof TypeReferenceTypeSymbol) || !(typeReferenceTypeSymbol = (TypeReferenceTypeSymbol)memberType).getName().isPresent()) continue;
                    this.handleRecordTypeSymbol(subscribeMessage, componentMessage, returnDescription, (TypeSymbol)typeReferenceTypeSymbol, (String)typeReferenceTypeSymbol.getName().get(), isOptional);
                }
            }
        }
    }

    private void setResponseOfRequest(BalAsyncApi25MessageImpl subscribeMessage, BalAsyncApi25MessageImpl componentMessage, String responseType, String returnDescription, ObjectMapper objMapper, BalAsyncApi25SchemaImpl schema, String isOptional) {
        BalAsyncApi25MessageImpl subscribeOneOf = new BalAsyncApi25MessageImpl();
        subscribeOneOf.setPayload(objMapper.valueToTree((Object)schema));
        this.setSchemasForChannelsAsOneOfSchema(subscribeMessage, subscribeOneOf);
        ObjectNode payloadObject = ConverterCommonUtils.createObjectNode();
        payloadObject.set("payload", objMapper.valueToTree((Object)schema));
        Map<String, JsonNode> xResponses = componentMessage.getExtensions();
        if (xResponses != null && xResponses.get("x-response") != null) {
            if (Constants.SERVER_STREAMING_TYPE_NODE.equals((Object)xResponses.get("x-response-type")) && responseType.equals("simple-rpc") || xResponses.get("x-response-type").equals((Object)new TextNode("simple-rpc")) && responseType.equals("server-streaming")) {
                throw new NoSuchElementException("ERROR: Response server streaming types cannot be union with simple rpc types");
            }
            BalAsyncApi25MessageImpl oneOfSchema = new BalAsyncApi25MessageImpl();
            if (xResponses.get("x-response").get("payload") != null || xResponses.get("x-response").get("$ref") != null) {
                this.setRefPayloadAsOneOfSchemaForPreviousOneResponse(componentMessage, oneOfSchema);
                this.setSchemaForOneOfSchema(oneOfSchema, subscribeOneOf);
            } else if (xResponses.get("x-response").get("oneOf") != null) {
                this.setRefPayloadAsOneOfSchemaForPreviousOneOfResponses(componentMessage, oneOfSchema);
                this.setSchemaForOneOfSchema(oneOfSchema, subscribeOneOf);
            }
            this.setDescriptionAndXResponsesForOneOf(componentMessage, returnDescription, objMapper, oneOfSchema, responseType, isOptional);
        } else {
            this.setDescriptionForOneResponse(returnDescription, payloadObject, componentMessage, responseType, isOptional);
        }
    }

    public BalAsyncApi25MessageImpl extractMessageSchemaReference(BalAsyncApi25MessageImpl message, String typeName, TypeSymbol typeSymbol, String dispatcherValue, String paramDescription) {
        BalAsyncApi25MessageImpl messageType = new BalAsyncApi25MessageImpl();
        this.componentMapper.createComponentSchema(typeSymbol, dispatcherValue);
        ObjectNode objNode1 = ConverterCommonUtils.createObjectNode();
        objNode1.put("$ref", "#/components/schemas/" + ConverterCommonUtils.unescapeIdentifier(typeName));
        if (paramDescription != null) {
            objNode1.put("description", paramDescription);
        }
        BalAsyncApi25MessageImpl componentMessage = new BalAsyncApi25MessageImpl();
        componentMessage.setPayload((JsonNode)objNode1);
        messageType.set$ref("#/components/messages/" + ConverterCommonUtils.unescapeIdentifier(typeName));
        this.setSchemasForChannelsAsOneOfSchema(message, messageType);
        return componentMessage;
    }

    private void setSchemasForChannelsAsOneOfSchema(BalAsyncApi25MessageImpl oneOfSchema, BalAsyncApi25MessageImpl schema) {
        if (oneOfSchema.getOneOf() == null) {
            oneOfSchema.addOneOf(schema);
        } else if (schema.get$ref() != null) {
            boolean check = false;
            for (AsyncApiMessage s : oneOfSchema.getOneOf()) {
                if (((BalAsyncApi25MessageImpl)s).get$ref() == null || !((BalAsyncApi25MessageImpl)s).get$ref().equals(schema.get$ref())) continue;
                check = true;
            }
            if (!check) {
                oneOfSchema.addOneOf(schema);
            }
        } else if (schema.getPayload() != null) {
            boolean check = false;
            for (AsyncApiMessage s : oneOfSchema.getOneOf()) {
                if (s.getPayload() == null || !s.getPayload().equals((Object)schema.getPayload())) continue;
                check = true;
            }
            if (!check) {
                oneOfSchema.addOneOf(schema);
            }
        }
    }

    private void handleReferenceResponse(BalAsyncApi25MessageImpl subscribeMessage, BalAsyncApi25MessageImpl componentMessage, SimpleNameReferenceNode referenceNode, String returnDescription, String isOptional) {
        TypeSymbol returnTypeSymbol = (TypeSymbol)this.semanticModel.symbol((Node)referenceNode).orElseThrow();
        String remoteReturnTypeName = ConverterCommonUtils.unescapeIdentifier(referenceNode.name().toString().trim());
        if (referenceNode.parent().kind().equals((Object)SyntaxKind.ARRAY_TYPE_DESC)) {
            this.updateArraySchema(subscribeMessage, componentMessage, returnDescription, returnTypeSymbol, remoteReturnTypeName, isOptional);
        } else if (returnTypeSymbol.typeKind() == TypeDescKind.TYPE_REFERENCE) {
            this.handleRecordTypeSymbol(subscribeMessage, componentMessage, returnDescription, returnTypeSymbol, remoteReturnTypeName, isOptional);
        }
    }

    private void updateArraySchema(BalAsyncApi25MessageImpl subscribeMessage, BalAsyncApi25MessageImpl componentMessage, String returnDescription, TypeSymbol returnTypeSymbol, String remoteReturnTypeName, String isOptional) {
        this.componentMapper.createComponentSchema(returnTypeSymbol, null);
        this.errors.addAll(this.componentMapper.getDiagnostics());
        ObjectMapper objMapper = ConverterCommonUtils.callObjectMapper();
        BalAsyncApi25SchemaImpl itemSchema = new BalAsyncApi25SchemaImpl();
        itemSchema.set$ref("#/components/schemas/" + ConverterCommonUtils.unescapeIdentifier(remoteReturnTypeName));
        BalAsyncApi25SchemaImpl arraySchema = ConverterCommonUtils.getAsyncApiSchema(Constants.AsyncAPIType.ARRAY.toString());
        arraySchema.setItems(itemSchema);
        this.setResponseOfRequest(subscribeMessage, componentMessage, "simple-rpc", returnDescription, objMapper, arraySchema, isOptional);
    }

    private void handleRecordTypeSymbol(BalAsyncApi25MessageImpl subscribeMessage, BalAsyncApi25MessageImpl componentMessage, String returnDescription, TypeSymbol returnTypeSymbol, String remoteReturnTypeName, String isOptional) {
        BalAsyncApi25MessageImpl componentReturnMessage = this.extractMessageSchemaReference(subscribeMessage, remoteReturnTypeName, returnTypeSymbol, null, null);
        if (this.components.getMessages() == null || this.components.getMessages().get(remoteReturnTypeName) == null) {
            this.components.addMessage(remoteReturnTypeName, componentReturnMessage);
        }
        ObjectNode messageRefObject = ConverterCommonUtils.createObjectNode();
        messageRefObject.put("$ref", "#/components/messages/" + ConverterCommonUtils.unescapeIdentifier(remoteReturnTypeName));
        Map<String, JsonNode> xResponses = componentMessage.getExtensions();
        if (xResponses != null && xResponses.get("x-response") != null) {
            if (Constants.SERVER_STREAMING_TYPE_NODE.equals((Object)xResponses.get("x-response-type")) && !AsyncApiResponseMapper.isCloseFrameRecordType(returnTypeSymbol)) {
                throw new NoSuchElementException("ERROR: Response server streaming types cannot be union with simple rpc types");
            }
            ObjectMapper objMapper = ConverterCommonUtils.callObjectMapper();
            BalAsyncApi25MessageImpl oneOfSchema = new BalAsyncApi25MessageImpl();
            if (xResponses.get("x-response").get("payload") != null || xResponses.get("x-response").get("$ref") != null) {
                BalAsyncApi25MessageImpl schemaObject;
                this.setRefPayloadAsOneOfSchemaForPreviousOneResponse(componentMessage, oneOfSchema);
                try {
                    schemaObject = (BalAsyncApi25MessageImpl)objMapper.treeToValue((TreeNode)messageRefObject, BalAsyncApi25MessageImpl.class);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
                this.setSchemaForOneOfSchema(oneOfSchema, schemaObject);
            } else if (xResponses.get("x-response").get("oneOf") != null) {
                this.setRefPayloadAsOneOfSchemaForPreviousOneOfResponses(componentMessage, oneOfSchema);
                BalAsyncApi25MessageImpl schema = new BalAsyncApi25MessageImpl();
                schema.set$ref("#/components/messages/" + ConverterCommonUtils.unescapeIdentifier(remoteReturnTypeName));
                this.setSchemaForOneOfSchema(oneOfSchema, schema);
            }
            String responseType = AsyncApiResponseMapper.isCloseFrameRecordType(returnTypeSymbol) ? xResponses.get("x-response-type").asText() : "simple-rpc";
            this.setDescriptionAndXResponsesForOneOf(componentMessage, returnDescription, objMapper, oneOfSchema, responseType, isOptional);
        } else {
            this.setDescriptionForOneResponse(returnDescription, messageRefObject, componentMessage, "simple-rpc", isOptional);
        }
    }

    private void setDescriptionForOneResponse(String returnDescription, ObjectNode messageRefObject, BalAsyncApi25MessageImpl componentMessage, String responseType, String isOptional) {
        if (returnDescription != null) {
            messageRefObject.put("description", returnDescription);
        }
        if (isOptional.equals("true")) {
            messageRefObject.put("x-required", (JsonNode)BooleanNode.FALSE);
        }
        componentMessage.addExtension("x-response", (JsonNode)messageRefObject);
        componentMessage.addExtension("x-response-type", (JsonNode)new TextNode(responseType));
    }

    private void setDescriptionAndXResponsesForOneOf(BalAsyncApi25MessageImpl componentMessage, String returnDescription, ObjectMapper objMapper, BalAsyncApi25MessageImpl oneOfSchema, String responseType, String isOptional) {
        if (returnDescription != null) {
            oneOfSchema.setDescription(returnDescription);
        }
        if (isOptional.equals("true")) {
            oneOfSchema.addExtension("x-required", (JsonNode)BooleanNode.FALSE);
        }
        componentMessage.addExtension("x-response", objMapper.valueToTree((Object)oneOfSchema));
        componentMessage.addExtension("x-response-type", (JsonNode)new TextNode(responseType));
    }

    private void setSchemaForOneOfSchema(BalAsyncApi25MessageImpl oneOfSchema, BalAsyncApi25MessageImpl schema) {
        if (Objects.isNull(oneOfSchema.getOneOf()) || Objects.isNull(schema.get$ref()) || oneOfSchema.getOneOf().stream().map(message -> (BalAsyncApi25MessageImpl)message).noneMatch(message -> schema.get$ref().equals(message.get$ref()))) {
            oneOfSchema.addOneOf(schema);
        }
    }

    private void setRefPayloadAsOneOfSchemaForPreviousOneOfResponses(BalAsyncApi25MessageImpl componentMessage, BalAsyncApi25MessageImpl oneOfSchema) {
        ArrayNode oneOfNode = (ArrayNode)componentMessage.getExtensions().get("x-response").get("oneOf");
        for (int i = 0; i < oneOfNode.size(); ++i) {
            BalAsyncApi25MessageImpl refSchema = new BalAsyncApi25MessageImpl();
            if (oneOfNode.get(i).get("payload") != null) {
                refSchema.setPayload(oneOfNode.get(i).get("payload"));
            } else if (oneOfNode.get(i).get("$ref") != null) {
                refSchema.set$ref(oneOfNode.get(i).get("$ref").asText());
            }
            this.setSchemaForOneOfSchema(oneOfSchema, refSchema);
        }
    }

    private void setRefPayloadAsOneOfSchemaForPreviousOneResponse(BalAsyncApi25MessageImpl componentMessage, BalAsyncApi25MessageImpl oneOfSchema) {
        if (componentMessage.getExtensions().get("x-response").get("$ref") != null) {
            TextNode reference = (TextNode)componentMessage.getExtensions().get("x-response").get("$ref");
            BalAsyncApi25MessageImpl testObject = new BalAsyncApi25MessageImpl();
            testObject.set$ref(reference.textValue());
            this.setSchemaForOneOfSchema(oneOfSchema, testObject);
        } else if (componentMessage.getExtensions().get("x-response").get("payload") != null) {
            ObjectNode reference = (ObjectNode)componentMessage.getExtensions().get("x-response").get("payload");
            BalAsyncApi25MessageImpl testObject = new BalAsyncApi25MessageImpl();
            testObject.setPayload((JsonNode)reference);
            this.setSchemaForOneOfSchema(oneOfSchema, testObject);
        }
    }

    private void mapUnionReturns(BalAsyncApi25MessageImpl subscribeMessage, BalAsyncApi25MessageImpl componentMessage, UnionTypeDescriptorNode typeNode, String returnDescription, String isOptional, String responseType) {
        TypeDescriptorNode rightNode = typeNode.rightTypeDesc();
        TypeDescriptorNode leftNode = typeNode.leftTypeDesc();
        this.createResponse(subscribeMessage, componentMessage, (Node)leftNode, returnDescription, isOptional, responseType);
        if (rightNode instanceof UnionTypeDescriptorNode) {
            UnionTypeDescriptorNode traversRightNode = (UnionTypeDescriptorNode)rightNode;
            while (traversRightNode.rightTypeDesc() != null) {
                if (leftNode.kind() != SyntaxKind.QUALIFIED_NAME_REFERENCE) continue;
                leftNode = ((UnionTypeDescriptorNode)rightNode).leftTypeDesc();
                this.createResponse(subscribeMessage, componentMessage, (Node)leftNode, returnDescription, isOptional, responseType);
            }
        } else {
            this.createResponse(subscribeMessage, componentMessage, (Node)rightNode, returnDescription, isOptional, responseType);
        }
    }

    private void mapInlineRecordInReturn(BalAsyncApi25MessageImpl subscribeMessage, BalAsyncApi25MessageImpl componentMessage, RecordTypeDescriptorNode typeNode, String returnDescription, String isOptional) {
        NodeList fields = typeNode.fields();
        BalAsyncApi25SchemaImpl inlineSchema = new BalAsyncApi25SchemaImpl();
        inlineSchema.setType(Constants.AsyncAPIType.OBJECT.toString());
        for (Node field : fields) {
            if (field.kind() != SyntaxKind.RECORD_FIELD) continue;
            RecordFieldNode recordField = (RecordFieldNode)field;
            Node type01 = recordField.typeName();
            if (recordField.typeName().kind() == SyntaxKind.SIMPLE_NAME_REFERENCE) {
                SimpleNameReferenceNode nameRefNode = (SimpleNameReferenceNode)type01;
                TypeSymbol typeSymbol = (TypeSymbol)this.semanticModel.symbol((Node)nameRefNode).orElseThrow();
                this.componentMapper.createComponentSchema(typeSymbol, null);
                BalAsyncApi25SchemaImpl referenceSchema = new BalAsyncApi25SchemaImpl();
                referenceSchema.set$ref("#/components/schemas/" + ConverterCommonUtils.unescapeIdentifier(recordField.typeName().toString().trim()));
                inlineSchema.addProperty(recordField.fieldName().text(), referenceSchema);
                continue;
            }
            BalAsyncApi25SchemaImpl propertySchema = ConverterCommonUtils.getAsyncApiSchema(recordField.typeName().toString().trim());
            inlineSchema.addProperty(recordField.fieldName().text(), propertySchema);
        }
        this.setResponseOfRequest(subscribeMessage, componentMessage, "simple-rpc", returnDescription, ConverterCommonUtils.callObjectMapper(), inlineSchema, isOptional);
    }

    private void getApiResponsesForArrayTypes(BalAsyncApi25MessageImpl subscribeMessage, BalAsyncApi25MessageImpl componentMessage, ArrayTypeDescriptorNode array, String returnDescription, String isOptional) {
        if (array.memberTypeDesc().kind() == SyntaxKind.SIMPLE_NAME_REFERENCE) {
            this.handleReferenceResponse(subscribeMessage, componentMessage, (SimpleNameReferenceNode)array.memberTypeDesc(), returnDescription, isOptional);
        } else if (array.memberTypeDesc().kind() == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
            this.handleQualifiedNameTypeReference(subscribeMessage, componentMessage, returnDescription, (Node)array.memberTypeDesc(), isOptional);
        } else {
            BalAsyncApi25SchemaImpl arraySchema = ConverterCommonUtils.getAsyncApiSchema(Constants.AsyncAPIType.ARRAY.toString());
            String type02 = array.memberTypeDesc().kind().toString().trim().split("_")[0].toLowerCase(Locale.ENGLISH);
            BalAsyncApi25SchemaImpl asyncApiSchema = ConverterCommonUtils.getAsyncApiSchema(type02);
            ObjectMapper objectMapper = ConverterCommonUtils.callObjectMapper();
            arraySchema.setItems(asyncApiSchema);
            this.setResponseOfRequest(subscribeMessage, componentMessage, "simple-rpc", returnDescription, objectMapper, arraySchema, isOptional);
        }
    }
}

