/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.websocketscore.generators.client;

import com.fasterxml.jackson.databind.node.TextNode;
import io.apicurio.datamodels.models.Schema;
import io.apicurio.datamodels.models.asyncapi.AsyncApiSchema;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25DocumentImpl;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25SchemaImpl;
import io.ballerina.asyncapi.websocketscore.GeneratorUtils;
import io.ballerina.asyncapi.websocketscore.exception.BallerinaAsyncApiExceptionWs;
import java.util.List;

public class CommonFunctionUtils {
    private final AsyncApi25DocumentImpl asyncAPI;

    public CommonFunctionUtils(AsyncApi25DocumentImpl asyncAPI) {
        this.asyncAPI = asyncAPI;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isDispatcherPresent(String schemaName, AsyncApi25SchemaImpl schema, String dispatcherVal, boolean isParent) throws BallerinaAsyncApiExceptionWs {
        if (schema == null) throw new BallerinaAsyncApiExceptionWs("Response type must be a record, invalid response schema");
        if (schema.getProperties() != null) {
            if (!schema.getProperties().containsKey(dispatcherVal)) return false;
            if (!((AsyncApi25SchemaImpl)schema.getProperties().get(dispatcherVal)).getType().equals("string")) {
                throw new BallerinaAsyncApiExceptionWs("Both dispatcherKey and dispatcherStreamId type must be string");
            }
            if (schema.getRequired() != null && schema.getRequired().contains(dispatcherVal)) return true;
            throw new BallerinaAsyncApiExceptionWs("Both dispatcherKey and dispatcherStreamId type must be inside required property");
        }
        if (schema.getOneOf() != null) {
            List<AsyncApiSchema> oneOfSchemas = schema.getOneOf();
            for (AsyncApiSchema oneOfSchema : oneOfSchemas) {
                TextNode textNode;
                String dispatcherKey;
                boolean oneOfContainProperties;
                AsyncApi25SchemaImpl oneOf25Schema = (AsyncApi25SchemaImpl)oneOfSchema;
                if (oneOf25Schema.get$ref() != null) {
                    String refSchemaName = GeneratorUtils.extractReferenceType(oneOf25Schema.get$ref());
                    AsyncApi25SchemaImpl refSchema = (AsyncApi25SchemaImpl)this.asyncAPI.getComponents().getSchemas().get(refSchemaName);
                    oneOfContainProperties = this.isDispatcherPresent(refSchemaName, refSchema, dispatcherVal, false);
                } else {
                    oneOfContainProperties = this.isDispatcherPresent("", oneOf25Schema, dispatcherVal, false);
                }
                if (oneOfContainProperties || !isParent || !dispatcherVal.equals(dispatcherKey = (textNode = (TextNode)this.asyncAPI.getExtensions().get("x-dispatcherKey")).asText())) continue;
                throw new BallerinaAsyncApiExceptionWs(String.format("%s schema must be a record, and it must have properties to contain dispatcherKey as a field", schemaName));
            }
            return true;
        }
        if (schema.getAllOf() != null) {
            List<Schema> allOfSchemas = schema.getAllOf();
            for (Schema allOfSchema : allOfSchemas) {
                boolean allOfContainProperties;
                AsyncApi25SchemaImpl allOf25Schema = (AsyncApi25SchemaImpl)allOfSchema;
                if (allOf25Schema.get$ref() != null) {
                    String refSchemaName = GeneratorUtils.extractReferenceType(allOf25Schema.get$ref());
                    AsyncApi25SchemaImpl refSchema = (AsyncApi25SchemaImpl)this.asyncAPI.getComponents().getSchemas().get(schemaName);
                    allOfContainProperties = this.isDispatcherPresent(refSchemaName, refSchema, dispatcherVal, false);
                } else {
                    allOfContainProperties = this.isDispatcherPresent("", allOf25Schema, dispatcherVal, false);
                }
                if (!allOfContainProperties) continue;
                return true;
            }
            TextNode textNode = (TextNode)this.asyncAPI.getExtensions().get("x-dispatcherKey");
            String dispatcherKey = textNode.asText();
            if (!dispatcherVal.equals(dispatcherKey)) return false;
            throw new BallerinaAsyncApiExceptionWs(String.format("%s schema must be a record, and it must have properties to contain dispatcherKey as a field", schemaName));
        }
        if (schema.getType().equals("object")) return false;
        throw new BallerinaAsyncApiExceptionWs(String.format("Response type must be a record, invalid response type %s in %s schema, schema must contain properties field to contain dispatcherKey", schema.getType(), schemaName));
    }
}

