/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.websocketscore.generators.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.apicurio.datamodels.models.Schema;
import io.apicurio.datamodels.models.ServerVariable;
import io.apicurio.datamodels.models.asyncapi.AsyncApiChannelItem;
import io.apicurio.datamodels.models.asyncapi.AsyncApiMessage;
import io.apicurio.datamodels.models.asyncapi.AsyncApiOperation;
import io.apicurio.datamodels.models.asyncapi.AsyncApiSchema;
import io.apicurio.datamodels.models.asyncapi.AsyncApiServer;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25DocumentImpl;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25InfoImpl;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25MessageImpl;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25Schema;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25SchemaImpl;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25ServerImpl;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25ServersImpl;
import io.ballerina.asyncapi.websocketscore.GeneratorConstants;
import io.ballerina.asyncapi.websocketscore.GeneratorUtils;
import io.ballerina.asyncapi.websocketscore.exception.BallerinaAsyncApiExceptionWs;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.service.AsyncApiRemoteMapper;
import io.ballerina.asyncapi.websocketscore.generators.client.BallerinaAuthConfigGenerator;
import io.ballerina.asyncapi.websocketscore.generators.client.CommonFunctionUtils;
import io.ballerina.asyncapi.websocketscore.generators.client.RemoteFunctionBodyGenerator;
import io.ballerina.asyncapi.websocketscore.generators.client.RemoteFunctionReturnTypeGenerator;
import io.ballerina.asyncapi.websocketscore.generators.client.RemoteFunctionSignatureGenerator;
import io.ballerina.asyncapi.websocketscore.generators.client.UtilGenerator;
import io.ballerina.asyncapi.websocketscore.generators.client.model.AasClientConfig;
import io.ballerina.asyncapi.websocketscore.generators.document.DocCommentsGenerator;
import io.ballerina.asyncapi.websocketscore.generators.schema.BallerinaTypesGenerator;
import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.AssignmentStatementNode;
import io.ballerina.compiler.syntax.tree.BinaryExpressionNode;
import io.ballerina.compiler.syntax.tree.BindingPatternNode;
import io.ballerina.compiler.syntax.tree.BlockStatementNode;
import io.ballerina.compiler.syntax.tree.BuiltinSimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.CaptureBindingPatternNode;
import io.ballerina.compiler.syntax.tree.CheckExpressionNode;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.ContinueStatementNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionStatementNode;
import io.ballerina.compiler.syntax.tree.FieldAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyBlockNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.IfElseStatementNode;
import io.ballerina.compiler.syntax.tree.ImplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.LockStatementNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MarkdownDocumentationLineNode;
import io.ballerina.compiler.syntax.tree.MarkdownDocumentationNode;
import io.ballerina.compiler.syntax.tree.MarkdownParameterDocumentationLineNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.MethodCallExpressionNode;
import io.ballerina.compiler.syntax.tree.MinutiaeList;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.NamedWorkerDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.compiler.syntax.tree.ObjectFieldNode;
import io.ballerina.compiler.syntax.tree.OptionalTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.ParenthesizedArgList;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.ReturnStatementNode;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.TemplateExpressionNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypedBindingPatternNode;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class IntermediateClientGenerator {
    private final AsyncApi25DocumentImpl asyncApi;
    private final List<String> remoteFunctionNameList;
    private final BallerinaAuthConfigGenerator ballerinaAuthConfigGenerator;
    private final List<ImportDeclarationNode> imports;
    private final BallerinaTypesGenerator ballerinaSchemaGenerator;
    private final RemoteFunctionReturnTypeGenerator functionReturnType;
    private final Map<String, String> responseMap = new HashMap<String, String>();
    private UtilGenerator utilGenerator;
    private List<TypeDefinitionNode> typeDefinitionNodeList;
    private List<String> apiKeyNameList = new ArrayList<String>();
    private String serverURL;
    private String clientName = null;
    private String dispatcherKey;
    private String dispatcherStreamId;
    private static final Token openParenToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN);
    private static final Token closeParenToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN);
    private static final Token openBraceToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN);
    private static final Token closeBraceToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN);
    private static final Token semicolonToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN);
    private static final Token equalToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN);
    private static final Token dotToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.DOT_TOKEN);
    private static final Token rightArrowToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RIGHT_ARROW_TOKEN);
    private static final Token colonToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN);
    private static final Token eofToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EOF_TOKEN);

    public IntermediateClientGenerator(AasClientConfig asyncAPIClientConfig) {
        this.imports = new ArrayList<ImportDeclarationNode>();
        this.typeDefinitionNodeList = new ArrayList<TypeDefinitionNode>();
        this.asyncApi = asyncAPIClientConfig.getAsyncAPI();
        this.utilGenerator = null;
        this.remoteFunctionNameList = new ArrayList<String>();
        this.ballerinaSchemaGenerator = new BallerinaTypesGenerator(this.asyncApi, new LinkedList<TypeDefinitionNode>());
        this.serverURL = "/";
        this.ballerinaAuthConfigGenerator = new BallerinaAuthConfigGenerator(false, false, this.ballerinaSchemaGenerator);
        this.functionReturnType = new RemoteFunctionReturnTypeGenerator(this.asyncApi);
    }

    private static ObjectFieldNode getObjectFieldNode(NodeList<Token> qualifiers, Node typeNode, String fieldIdentifier) {
        IdentifierToken fieldName = AbstractNodeFactory.createIdentifierToken((String)fieldIdentifier);
        MetadataNode metadataNode = NodeFactory.createMetadataNode(null, (NodeList)AbstractNodeFactory.createEmptyNodeList());
        return NodeFactory.createObjectFieldNode((MetadataNode)metadataNode, null, qualifiers, (Node)typeNode, (Token)fieldName, null, null, (Token)semicolonToken);
    }

    public void setUtilGenerator(UtilGenerator utilGenerator) {
        this.utilGenerator = utilGenerator;
    }

    public List<TypeDefinitionNode> getTypeDefinitionNodeList() {
        return this.typeDefinitionNodeList;
    }

    public BallerinaAuthConfigGenerator getBallerinaAuthConfigGenerator() {
        return this.ballerinaAuthConfigGenerator;
    }

    public List<String> getRemoteFunctionNameList() {
        return this.remoteFunctionNameList;
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public String getServerUrl() {
        return this.serverURL;
    }

    public SyntaxTree generateSyntaxTree() throws BallerinaAsyncApiExceptionWs {
        ImportDeclarationNode importForWebsocket = GeneratorUtils.getImportDeclarationNode("ballerina", "websocket");
        ImportDeclarationNode importForXlibbPipe = GeneratorUtils.getImportDeclarationNode("xlibb", "pipe");
        ImportDeclarationNode importForLog = GeneratorUtils.getImportDeclarationNode("ballerina", "log");
        ImportDeclarationNode importForRegex = GeneratorUtils.getImportDeclarationNode("ballerina", "lang.regexp");
        this.imports.add(importForRegex);
        this.imports.add(importForLog);
        this.imports.add(importForWebsocket);
        this.imports.add(importForXlibbPipe);
        this.ballerinaAuthConfigGenerator.addAuthRelatedRecords(this.asyncApi);
        ArrayList<ClassDefinitionNode> nodes = new ArrayList<ClassDefinitionNode>();
        nodes.add(this.getClassDefinitionNode());
        NodeList importsList = AbstractNodeFactory.createNodeList(this.imports);
        ModulePartNode modulePartNode = NodeFactory.createModulePartNode((NodeList)importsList, (NodeList)AbstractNodeFactory.createNodeList(nodes), (Token)eofToken);
        TextDocument textDocument = TextDocuments.from((String)"");
        SyntaxTree syntaxTree = SyntaxTree.from((TextDocument)textDocument);
        return syntaxTree.modifyWith((Node)modulePartNode);
    }

    public UtilGenerator getBallerinaUtilGenerator() {
        return this.utilGenerator;
    }

    private ClassDefinitionNode getClassDefinitionNode() throws BallerinaAsyncApiExceptionWs {
        TextNode dispatcherStreamIdNode;
        Map<String, JsonNode> extensions = this.asyncApi.getExtensions();
        if (extensions == null || extensions.get("x-dispatcherKey") == null) {
            throw new BallerinaAsyncApiExceptionWs("x-dispatcherKey must include in the specification");
        }
        TextNode dispatcherKeyNode = (TextNode)extensions.get("x-dispatcherKey");
        this.dispatcherKey = dispatcherKeyNode.asText();
        if (this.dispatcherKey.isEmpty()) {
            throw new BallerinaAsyncApiExceptionWs("x-dispatcherKey cannot be empty");
        }
        if (extensions.get("x-dispatcherStreamId") != null && (dispatcherStreamIdNode = (TextNode)extensions.get("x-dispatcherStreamId")) != null) {
            this.dispatcherStreamId = extensions.get("x-dispatcherStreamId").asText();
            if (this.dispatcherStreamId.isEmpty()) {
                throw new BallerinaAsyncApiExceptionWs("x-dispatcherStreamId cannot be empty");
            }
        }
        AsyncApi25SchemaImpl responseMessageSchema = this.createResponseMessage(this.dispatcherKey);
        TypeDefinitionNode responseMessageTypeDefinitionNode = this.ballerinaSchemaGenerator.getTypeDefinitionNode(responseMessageSchema, "Message", new ArrayList<Node>());
        GeneratorUtils.updateTypeDefNodeList("Message", responseMessageTypeDefinitionNode, this.typeDefinitionNodeList);
        if (!Objects.isNull(this.dispatcherStreamId)) {
            AsyncApi25SchemaImpl responseMessageWithIdSchema = this.createResponseMessageWithIDRecord(this.dispatcherKey, this.dispatcherStreamId);
            TypeDefinitionNode typeDefinitionNode = this.ballerinaSchemaGenerator.getTypeDefinitionNode(responseMessageWithIdSchema, "MessageWithId", new ArrayList<Node>());
            GeneratorUtils.updateTypeDefNodeList("MessageWithId", typeDefinitionNode, this.typeDefinitionNodeList);
        }
        ArrayList<String> pipeIdMethods = new ArrayList<String>();
        ArrayList<String> streamReturns = new ArrayList<String>();
        List<FunctionDefinitionNode> remoteFunctionNodes = this.createRemoteFunctions(streamReturns, pipeIdMethods);
        boolean isStreamPresent = !streamReturns.isEmpty();
        ArrayList<ObjectFieldNode> memberNodeList = new ArrayList<ObjectFieldNode>(this.createClassInstanceVariables(isStreamPresent));
        memberNodeList.add((ObjectFieldNode)this.createInitFunction(isStreamPresent));
        memberNodeList.add((ObjectFieldNode)this.createGetRecordNameFunction());
        memberNodeList.add((ObjectFieldNode)this.createGetPipeNameFunction());
        memberNodeList.add((ObjectFieldNode)this.createStartMessageWriting());
        memberNodeList.add((ObjectFieldNode)this.createStartMessageReading());
        memberNodeList.addAll(remoteFunctionNodes);
        MetadataNode metadataNode = this.getClassMetadataNode();
        String titleName = this.asyncApi.getInfo().getTitle().trim().replaceAll("\\s", "");
        String channelName = GeneratorUtils.removeNonAlphanumeric(this.asyncApi.getChannels().getItemNames().get(0).trim());
        String stringClassName = titleName + channelName + "Client";
        this.setClientName(stringClassName);
        IdentifierToken className = AbstractNodeFactory.createIdentifierToken((String)stringClassName);
        NodeList classTypeQualifiers = AbstractNodeFactory.createNodeList((Node[])new Token[]{AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLIENT_KEYWORD), AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ISOLATED_KEYWORD)});
        return NodeFactory.createClassDefinitionNode((MetadataNode)metadataNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PUBLIC_KEYWORD), (NodeList)classTypeQualifiers, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLASS_KEYWORD), (Token)className, (Token)openBraceToken, (NodeList)AbstractNodeFactory.createNodeList(memberNodeList), (Token)closeBraceToken, null);
    }

    private Node createStartMessageReading() {
        FunctionSignatureNode functionSignatureNode = this.getStartMessageReadingFunctionSignatureNode();
        FunctionBodyNode functionBodyNode = this.getStartMessageReadingFunctionBodyNode();
        NodeList qualifierList = AbstractNodeFactory.createNodeList((Node[])new Token[]{AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PRIVATE_KEYWORD), AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ISOLATED_KEYWORD)});
        IdentifierToken functionName = AbstractNodeFactory.createIdentifierToken((String)"startMessageReading");
        return NodeFactory.createFunctionDefinitionNode((SyntaxKind)SyntaxKind.OBJECT_METHOD_DEFINITION, (MetadataNode)this.getDocCommentsForWorker("x-ballerina-read-message-description", "Used to read messages from the websocket."), (NodeList)qualifierList, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.FUNCTION_KEYWORD), (IdentifierToken)functionName, (NodeList)AbstractNodeFactory.createEmptyNodeList(), (FunctionSignatureNode)functionSignatureNode, (FunctionBodyNode)functionBodyNode);
    }

    private FunctionBodyNode getStartMessageReadingFunctionBodyNode() {
        ArrayList<Object> whileStatements = new ArrayList<Object>();
        whileStatements.add(IntermediateClientGenerator.getIsActiveCheck());
        FieldAccessExpressionNode clientEp = NodeFactory.createFieldAccessExpressionNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"self")), (Token)dotToken, (NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"clientEp")));
        MethodCallExpressionNode responseMessageExpressionNode = NodeFactory.createMethodCallExpressionNode((ExpressionNode)clientEp, (Token)rightArrowToken, (NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"readMessage")), (Token)openParenToken, (SeparatedNodeList)AbstractNodeFactory.createSeparatedNodeList((Node[])new Node[]{AbstractNodeFactory.createIdentifierToken((String)"Message")}), (Token)closeParenToken);
        VariableDeclarationNode responseMessage = NodeFactory.createVariableDeclarationNode((NodeList)AbstractNodeFactory.createEmptyNodeList(), null, (TypedBindingPatternNode)NodeFactory.createTypedBindingPatternNode((TypeDescriptorNode)NodeFactory.createUnionTypeDescriptorNode((TypeDescriptorNode)NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)AbstractNodeFactory.createIdentifierToken((String)"Message")), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PIPE_TOKEN), (TypeDescriptorNode)GeneratorConstants.WS_ERROR), (BindingPatternNode)NodeFactory.createFieldBindingPatternVarnameNode((SimpleNameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"message")))), (Token)equalToken, (ExpressionNode)responseMessageExpressionNode, (Token)semicolonToken);
        whileStatements.add(responseMessage);
        whileStatements.add(IntermediateClientGenerator.getIsWsError("\"WsError: Failed to read message from the client\", %s", "message"));
        StatementNode getPipeNameStatement = NodeParser.parseStatement((String)String.format("string pipeName = self.getPipeName(message.%s);", GeneratorUtils.escapeIdentifier(this.dispatcherKey)));
        String messageEventAccessor = String.format("self.pipes.getPipe(%s)", "pipeName");
        if (Objects.isNull(this.dispatcherStreamId)) {
            VariableDeclarationNode pipesVar = NodeFactory.createVariableDeclarationNode((NodeList)AbstractNodeFactory.createEmptyNodeList(), null, (TypedBindingPatternNode)NodeFactory.createTypedBindingPatternNode((TypeDescriptorNode)NodeParser.parseTypeDescriptor((String)"pipe:Pipe"), (BindingPatternNode)NodeFactory.createFieldBindingPatternVarnameNode((SimpleNameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"pipe")))), (Token)equalToken, (ExpressionNode)NodeParser.parseExpression((String)messageEventAccessor), (Token)semicolonToken);
            whileStatements.add(getPipeNameStatement);
            whileStatements.add(pipesVar);
        } else {
            whileStatements.add(NodeParser.parseStatement((String)"pipe:Pipe pipe;"));
            whileStatements.add(NodeParser.parseStatement((String)"MessageWithId|error messageWithId = message.cloneWithType(MessageWithId);"));
            IfElseStatementNode pipeConditional = NodeFactory.createIfElseStatementNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.IF_KEYWORD), (ExpressionNode)NodeParser.parseExpression((String)"messageWithId is MessageWithId"), (BlockStatementNode)NodeFactory.createBlockStatementNode((Token)openBraceToken, (NodeList)AbstractNodeFactory.createNodeList((Node[])new StatementNode[]{NodeParser.parseStatement((String)("pipe = " + String.format("self.pipes.getPipe(%s)", "messageWithId." + GeneratorUtils.escapeIdentifier(this.dispatcherStreamId)) + ";"))}), (Token)closeBraceToken), (Node)NodeFactory.createElseBlockNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ELSE_KEYWORD), (StatementNode)NodeFactory.createBlockStatementNode((Token)openBraceToken, (NodeList)AbstractNodeFactory.createNodeList((Node[])new StatementNode[]{getPipeNameStatement, NodeParser.parseStatement((String)("pipe = " + messageEventAccessor + ";"))}), (Token)closeBraceToken)));
            whileStatements.add(pipeConditional);
        }
        MethodCallExpressionNode produceExpression = NodeFactory.createMethodCallExpressionNode((ExpressionNode)NodeFactory.createBasicLiteralNode((SyntaxKind)SyntaxKind.VAR_KEYWORD, (Token)AbstractNodeFactory.createIdentifierToken((String)"pipe")), (Token)dotToken, (NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"produce")), (Token)openParenToken, (SeparatedNodeList)AbstractNodeFactory.createSeparatedNodeList((Node[])new Node[]{NodeFactory.createPositionalArgumentNode((ExpressionNode)NodeFactory.createRequiredExpressionNode((Token)AbstractNodeFactory.createIdentifierToken((String)"message"))), AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN), NodeFactory.createPositionalArgumentNode((ExpressionNode)NodeFactory.createRequiredExpressionNode((Token)AbstractNodeFactory.createIdentifierToken((String)"5")))}), (Token)closeParenToken);
        VariableDeclarationNode pipeErrVar = NodeFactory.createVariableDeclarationNode((NodeList)AbstractNodeFactory.createEmptyNodeList(), null, (TypedBindingPatternNode)NodeFactory.createTypedBindingPatternNode((TypeDescriptorNode)NodeFactory.createOptionalTypeDescriptorNode((Node)GeneratorConstants.PIPE_ERROR_NODE, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.QUESTION_MARK_TOKEN)), (BindingPatternNode)NodeFactory.createFieldBindingPatternVarnameNode((SimpleNameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"pipeErr")))), (Token)equalToken, (ExpressionNode)produceExpression, (Token)semicolonToken);
        whileStatements.add(pipeErrVar);
        whileStatements.add(IntermediateClientGenerator.getIsPipeError("pipeErr", "\"PipeError: Failed to produce message to the pipe\", %s", false));
        BlockStatementNode whileBody = NodeFactory.createBlockStatementNode((Token)openBraceToken, (NodeList)AbstractNodeFactory.createNodeList(whileStatements), (Token)closeBraceToken);
        NodeList workerStatements = AbstractNodeFactory.createNodeList((Node[])new StatementNode[]{NodeFactory.createWhileStatementNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.WHILE_KEYWORD), (ExpressionNode)NodeFactory.createBasicLiteralNode((SyntaxKind)SyntaxKind.BOOLEAN_LITERAL, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.TRUE_KEYWORD)), (BlockStatementNode)whileBody, null)});
        NodeList workerDeclarationNodes = AbstractNodeFactory.createNodeList((Node[])new NamedWorkerDeclarationNode[]{NodeFactory.createNamedWorkerDeclarationNode((NodeList)AbstractNodeFactory.createEmptyNodeList(), null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.WORKER_KEYWORD), (IdentifierToken)AbstractNodeFactory.createIdentifierToken((String)"readMessage"), null, (BlockStatementNode)NodeFactory.createBlockStatementNode((Token)openBraceToken, (NodeList)workerStatements, (Token)closeBraceToken), null)});
        return NodeFactory.createFunctionBodyBlockNode((Token)openBraceToken, null, (NodeList)workerDeclarationNodes, (Token)closeBraceToken, null);
    }

    private FunctionSignatureNode getStartMessageReadingFunctionSignatureNode() {
        SeparatedNodeList parameterList = AbstractNodeFactory.createSeparatedNodeList(new ArrayList());
        return NodeFactory.createFunctionSignatureNode((Token)openParenToken, (SeparatedNodeList)parameterList, (Token)closeParenToken, null);
    }

    private AsyncApi25SchemaImpl createResponseMessageWithIDRecord(String dispatcherKey, String dispatcherStreamId) {
        AsyncApi25SchemaImpl responseMessageWithId = new AsyncApi25SchemaImpl();
        responseMessageWithId.setType("object");
        AsyncApi25SchemaImpl stringEventSchema = new AsyncApi25SchemaImpl();
        AsyncApi25SchemaImpl stringIdSchema = new AsyncApi25SchemaImpl();
        stringEventSchema.setType("string");
        stringIdSchema.setType("string");
        ArrayList<String> requiredFields = new ArrayList<String>();
        requiredFields.add(dispatcherKey);
        requiredFields.add(dispatcherStreamId);
        responseMessageWithId.setRequired(requiredFields);
        responseMessageWithId.addProperty(dispatcherKey, stringEventSchema);
        responseMessageWithId.addProperty(dispatcherStreamId, stringIdSchema);
        responseMessageWithId.addExtension("readOnly", (JsonNode)BooleanNode.TRUE);
        return responseMessageWithId;
    }

    private AsyncApi25SchemaImpl createResponseMessage(String dispatcherKey) {
        AsyncApi25SchemaImpl message = new AsyncApi25SchemaImpl();
        message.setType("object");
        AsyncApi25SchemaImpl stringEventSchema = new AsyncApi25SchemaImpl();
        AsyncApi25SchemaImpl stringIdSchema = new AsyncApi25SchemaImpl();
        stringEventSchema.setType("string");
        stringIdSchema.setType("string");
        ArrayList<String> requiredFields = new ArrayList<String>();
        requiredFields.add(dispatcherKey);
        message.setRequired(requiredFields);
        message.addProperty(dispatcherKey, stringEventSchema);
        message.addExtension("readOnly", (JsonNode)BooleanNode.TRUE);
        return message;
    }

    private Node createGetPipeNameFunction() {
        return NodeParser.parseObjectMember((String)"private isolated function getPipeName(string responseType) returns string {\n    string responseRecordType = self.getRecordName(responseType);\n    if self.responseMap.hasKey(responseRecordType) {\n        return self.responseMap.get(responseRecordType);\n    }\n    return responseType;\n}");
    }

    private Node createGetRecordNameFunction() {
        return NodeParser.parseObjectMember((String)"private isolated function getRecordName(string dispatchingValue) returns string {\n     string[] words = regexp:split(re `[\\W_]+`, dispatchingValue);\n     string result = \"\";\n     foreach string word in words {\n         result += word.substring(0, 1).toUpperAscii() + word.substring(1).toLowerAscii();\n     }\n     return result;\n}");
    }

    private Node createStartMessageWriting() {
        FunctionSignatureNode functionSignatureNode = this.getStartMessageWritingFunctionSignatureNode();
        FunctionBodyNode functionBodyNode = this.getStartMessageWritingFunctionBodyNode();
        NodeList qualifierList = AbstractNodeFactory.createNodeList((Node[])new Token[]{AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PRIVATE_KEYWORD), AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ISOLATED_KEYWORD)});
        IdentifierToken functionName = AbstractNodeFactory.createIdentifierToken((String)"startMessageWriting");
        return NodeFactory.createFunctionDefinitionNode((SyntaxKind)SyntaxKind.OBJECT_METHOD_DEFINITION, (MetadataNode)this.getDocCommentsForWorker("x-ballerina-write-message-description", "Used to write messages to the websocket."), (NodeList)qualifierList, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.FUNCTION_KEYWORD), (IdentifierToken)functionName, (NodeList)AbstractNodeFactory.createEmptyNodeList(), (FunctionSignatureNode)functionSignatureNode, (FunctionBodyNode)functionBodyNode);
    }

    private FunctionBodyNode getStartMessageWritingFunctionBodyNode() {
        NodeList annotations = AbstractNodeFactory.createEmptyNodeList();
        FieldAccessExpressionNode globalQueue = NodeFactory.createFieldAccessExpressionNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"self")), (Token)dotToken, (NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"writeMessageQueue")));
        MethodCallExpressionNode consumeExpression = NodeFactory.createMethodCallExpressionNode((ExpressionNode)globalQueue, (Token)dotToken, (NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"consume")), (Token)openParenToken, (SeparatedNodeList)AbstractNodeFactory.createSeparatedNodeList((Node[])new Node[]{NodeFactory.createPositionalArgumentNode((ExpressionNode)NodeFactory.createRequiredExpressionNode((Token)AbstractNodeFactory.createIdentifierToken((String)"5")))}), (Token)closeParenToken);
        VariableDeclarationNode queueData = NodeFactory.createVariableDeclarationNode((NodeList)AbstractNodeFactory.createEmptyNodeList(), null, (TypedBindingPatternNode)NodeFactory.createTypedBindingPatternNode((TypeDescriptorNode)NodeFactory.createUnionTypeDescriptorNode((TypeDescriptorNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"Message")), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PIPE_TOKEN), (TypeDescriptorNode)GeneratorConstants.PIPE_ERROR_NODE), (BindingPatternNode)NodeFactory.createFieldBindingPatternVarnameNode((SimpleNameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"message")))), (Token)equalToken, (ExpressionNode)consumeExpression, (Token)semicolonToken);
        FieldAccessExpressionNode clientEp = NodeFactory.createFieldAccessExpressionNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"self")), (Token)dotToken, (NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"clientEp")));
        MethodCallExpressionNode writeMessageExpression = NodeFactory.createMethodCallExpressionNode((ExpressionNode)clientEp, (Token)rightArrowToken, (NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"writeMessage")), (Token)openParenToken, (SeparatedNodeList)AbstractNodeFactory.createSeparatedNodeList((Node[])new Node[]{NodeFactory.createPositionalArgumentNode((ExpressionNode)NodeFactory.createRequiredExpressionNode((Token)AbstractNodeFactory.createIdentifierToken((String)"message")))}), (Token)closeParenToken);
        VariableDeclarationNode writeMessage = NodeFactory.createVariableDeclarationNode((NodeList)AbstractNodeFactory.createEmptyNodeList(), null, (TypedBindingPatternNode)NodeFactory.createTypedBindingPatternNode((TypeDescriptorNode)GeneratorConstants.WS_ERROR_OPTIONAL, (BindingPatternNode)NodeFactory.createFieldBindingPatternVarnameNode((SimpleNameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"wsErr")))), (Token)equalToken, (ExpressionNode)writeMessageExpression, (Token)semicolonToken);
        ArrayList<Object> whileStatements = new ArrayList<Object>();
        whileStatements.add(IntermediateClientGenerator.getIsActiveCheck());
        whileStatements.add(queueData);
        whileStatements.add(IntermediateClientGenerator.getIsPipeError("message", "\"PipeError: Failed to consume message from the pipe\", %s", true));
        whileStatements.add(writeMessage);
        whileStatements.add(IntermediateClientGenerator.getIsWsError("\"WsError: Failed to write message to the client\", %s", "wsErr"));
        BlockStatementNode whileBody = NodeFactory.createBlockStatementNode((Token)openBraceToken, (NodeList)AbstractNodeFactory.createNodeList(whileStatements), (Token)closeBraceToken);
        NodeList workerStatements = AbstractNodeFactory.createNodeList((Node[])new StatementNode[]{NodeFactory.createWhileStatementNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.WHILE_KEYWORD), (ExpressionNode)NodeFactory.createBasicLiteralNode((SyntaxKind)SyntaxKind.BOOLEAN_LITERAL, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.TRUE_KEYWORD)), (BlockStatementNode)whileBody, null)});
        NodeList workerDeclarationNodes = AbstractNodeFactory.createNodeList((Node[])new NamedWorkerDeclarationNode[]{NodeFactory.createNamedWorkerDeclarationNode((NodeList)annotations, null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.WORKER_KEYWORD), (IdentifierToken)AbstractNodeFactory.createIdentifierToken((String)"writeMessage"), null, (BlockStatementNode)NodeFactory.createBlockStatementNode((Token)openBraceToken, (NodeList)workerStatements, (Token)closeBraceToken), null)});
        return NodeFactory.createFunctionBodyBlockNode((Token)openBraceToken, null, (NodeList)workerDeclarationNodes, (Token)closeBraceToken, null);
    }

    private static StatementNode getIsActiveCheck() {
        NodeList ifIsActiveNode = AbstractNodeFactory.createNodeList((Node[])new StatementNode[]{NodeFactory.createIfElseStatementNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.IF_KEYWORD), (ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"!self.isActive")), (BlockStatementNode)NodeFactory.createBlockStatementNode((Token)openBraceToken, (NodeList)AbstractNodeFactory.createNodeList((Node[])new StatementNode[]{NodeFactory.createBreakStatementNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.BREAK_KEYWORD), (Token)semicolonToken)}), (Token)closeBraceToken), null)});
        return NodeFactory.createLockStatementNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.LOCK_KEYWORD), (BlockStatementNode)NodeFactory.createBlockStatementNode((Token)openBraceToken, (NodeList)ifIsActiveNode, (Token)closeBraceToken), null);
    }

    private static IfElseStatementNode getIsPipeError(String errVar, String errorMessageTemplate, boolean checkTimeout) {
        ArrayList<Object> ifStatements = new ArrayList<Object>();
        if (checkTimeout) {
            ContinueStatementNode continueStatementNode = NodeFactory.createContinueStatementNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CONTINUE_KEYWORD), (Token)semicolonToken);
            IfElseStatementNode ifTimeOutErrorNode = NodeFactory.createIfElseStatementNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.IF_KEYWORD), (ExpressionNode)NodeFactory.createBinaryExpressionNode((SyntaxKind)SyntaxKind.BINARY_EXPRESSION, (Node)NodeFactory.createMethodCallExpressionNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)errVar)), (Token)dotToken, (NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"message")), (Token)openParenToken, (SeparatedNodeList)AbstractNodeFactory.createSeparatedNodeList((Node[])new Node[0]), (Token)closeParenToken), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.DOUBLE_EQUAL_TOKEN), (Node)GeneratorConstants.OP_TIMEOUT_EXPR), (BlockStatementNode)NodeFactory.createBlockStatementNode((Token)openBraceToken, (NodeList)AbstractNodeFactory.createNodeList((Node[])new StatementNode[]{continueStatementNode}), (Token)closeBraceToken), null);
            ifStatements.add(ifTimeOutErrorNode);
        }
        StatementNode logPrintError = NodeParser.parseStatement((String)String.format("log:printError(%s);", String.format(errorMessageTemplate, errVar)));
        ifStatements.add(logPrintError);
        ifStatements.add(GeneratorConstants.ATTEMPT_CON_CLOSE);
        ReturnStatementNode returnStatement = NodeFactory.createReturnStatementNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RETURN_KEYWORD), null, (Token)semicolonToken);
        ifStatements.add(returnStatement);
        return NodeFactory.createIfElseStatementNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.IF_KEYWORD), (ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)(errVar + " is " + String.valueOf(GeneratorConstants.PIPE_ERROR_NODE)))), (BlockStatementNode)NodeFactory.createBlockStatementNode((Token)openBraceToken, (NodeList)AbstractNodeFactory.createNodeList(ifStatements), (Token)closeBraceToken), null);
    }

    private static IfElseStatementNode getIsWsError(String errMessageTemplate, String errVar) {
        ArrayList<Object> ifStatements = new ArrayList<Object>();
        StatementNode logPrintError = NodeParser.parseStatement((String)String.format("log:printError(%s);", String.format(errMessageTemplate, errVar)));
        ifStatements.add(logPrintError);
        ifStatements.add(GeneratorConstants.ATTEMPT_CON_CLOSE);
        ReturnStatementNode returnStatement = NodeFactory.createReturnStatementNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RETURN_KEYWORD), null, (Token)semicolonToken);
        ifStatements.add(returnStatement);
        return NodeFactory.createIfElseStatementNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.IF_KEYWORD), (ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)(errVar + " is " + String.valueOf(GeneratorConstants.WS_ERROR)))), (BlockStatementNode)NodeFactory.createBlockStatementNode((Token)openBraceToken, (NodeList)AbstractNodeFactory.createNodeList(ifStatements), (Token)closeBraceToken), null);
    }

    private FunctionSignatureNode getStartMessageWritingFunctionSignatureNode() {
        SeparatedNodeList parameterList = AbstractNodeFactory.createSeparatedNodeList(new ArrayList());
        return NodeFactory.createFunctionSignatureNode((Token)openParenToken, (SeparatedNodeList)parameterList, (Token)closeParenToken, null);
    }

    private MetadataNode getClassMetadataNode() {
        ArrayList classLevelAnnotationNodes = new ArrayList();
        ArrayList<MarkdownDocumentationLineNode> documentationLines = new ArrayList<MarkdownDocumentationLineNode>();
        if (this.asyncApi.getInfo().getDescription() != null && !this.asyncApi.getInfo().getDescription().isBlank()) {
            documentationLines.addAll(DocCommentsGenerator.createAPIDescriptionDoc(this.asyncApi.getInfo().getDescription(), false));
        }
        MarkdownDocumentationNode apiDoc = NodeFactory.createMarkdownDocumentationNode((NodeList)AbstractNodeFactory.createNodeList(documentationLines));
        return NodeFactory.createMetadataNode((Node)apiDoc, (NodeList)AbstractNodeFactory.createNodeList(classLevelAnnotationNodes));
    }

    private FunctionDefinitionNode createInitFunction(boolean isStreamPresent) throws BallerinaAsyncApiExceptionWs {
        AsyncApi25SchemaImpl headerSchema = new AsyncApi25SchemaImpl();
        AsyncApi25SchemaImpl querySchema = new AsyncApi25SchemaImpl();
        FunctionSignatureNode functionSignatureNode = this.getInitFunctionSignatureNode(querySchema, headerSchema);
        FunctionBodyNode functionBodyNode = this.getInitFunctionBodyNode(querySchema, headerSchema, isStreamPresent);
        NodeList qualifierList = AbstractNodeFactory.createNodeList((Node[])new Token[]{AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PUBLIC_KEYWORD), AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ISOLATED_KEYWORD)});
        IdentifierToken functionName = AbstractNodeFactory.createIdentifierToken((String)"init");
        return NodeFactory.createFunctionDefinitionNode((SyntaxKind)SyntaxKind.OBJECT_METHOD_DEFINITION, (MetadataNode)this.getInitDocComment(), (NodeList)qualifierList, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.FUNCTION_KEYWORD), (IdentifierToken)functionName, (NodeList)AbstractNodeFactory.createEmptyNodeList(), (FunctionSignatureNode)functionSignatureNode, (FunctionBodyNode)functionBodyNode);
    }

    private FunctionBodyNode getInitFunctionBodyNode(AsyncApi25SchemaImpl querySchema, AsyncApi25SchemaImpl headerSchema, boolean isStreamPresent) throws BallerinaAsyncApiExceptionWs {
        ArrayList<StatementNode> assignmentNodes = new ArrayList<StatementNode>();
        if (this.ballerinaAuthConfigGenerator.isHttpApiKey() && this.ballerinaAuthConfigGenerator.isHttpOrOAuth()) {
            assignmentNodes.add((StatementNode)this.ballerinaAuthConfigGenerator.handleInitForMixOfApiKeyAndHTTPOrOAuth());
        }
        ArrayList pipesArgumentsList = new ArrayList();
        SeparatedNodeList pipesArguments = AbstractNodeFactory.createSeparatedNodeList(pipesArgumentsList);
        ParenthesizedArgList pipesParenthesizedArgList = NodeFactory.createParenthesizedArgList((Token)openParenToken, (SeparatedNodeList)pipesArguments, (Token)closeParenToken);
        ImplicitNewExpressionNode pipesExpressionNode = NodeFactory.createImplicitNewExpressionNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.NEW_KEYWORD), (ParenthesizedArgList)pipesParenthesizedArgList);
        FieldAccessExpressionNode selfPipes = NodeFactory.createFieldAccessExpressionNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"self")), (Token)dotToken, (NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"pipes")));
        AssignmentStatementNode selfPipesAssignmentStatementNode = NodeFactory.createAssignmentStatementNode((Node)selfPipes, (Token)equalToken, (ExpressionNode)pipesExpressionNode, (Token)semicolonToken);
        assignmentNodes.add((StatementNode)selfPipesAssignmentStatementNode);
        if (isStreamPresent) {
            ArrayList streamGeneratorsArgumentsList = new ArrayList();
            SeparatedNodeList streamGeneratorsArguments = AbstractNodeFactory.createSeparatedNodeList(streamGeneratorsArgumentsList);
            ParenthesizedArgList streamGeneratorsParenthesizedArgList = NodeFactory.createParenthesizedArgList((Token)openParenToken, (SeparatedNodeList)streamGeneratorsArguments, (Token)closeParenToken);
            ImplicitNewExpressionNode streamGeneratorsExpressionNode = NodeFactory.createImplicitNewExpressionNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.NEW_KEYWORD), (ParenthesizedArgList)streamGeneratorsParenthesizedArgList);
            FieldAccessExpressionNode selfStreamGenerators = NodeFactory.createFieldAccessExpressionNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"self")), (Token)dotToken, (NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"streamGenerators")));
            AssignmentStatementNode selfStreamGeneratorsAssignmentStatementNode = NodeFactory.createAssignmentStatementNode((Node)selfStreamGenerators, (Token)equalToken, (ExpressionNode)streamGeneratorsExpressionNode, (Token)semicolonToken);
            assignmentNodes.add((StatementNode)selfStreamGeneratorsAssignmentStatementNode);
        }
        ArrayList<IdentifierToken> argumentsList = new ArrayList<IdentifierToken>();
        FieldAccessExpressionNode selfWriteMessageQueues = NodeFactory.createFieldAccessExpressionNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"self")), (Token)dotToken, (NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"writeMessageQueue")));
        argumentsList.add(AbstractNodeFactory.createIdentifierToken((String)"1000"));
        SeparatedNodeList arguments = AbstractNodeFactory.createSeparatedNodeList(argumentsList);
        ParenthesizedArgList parenthesizedArgList = NodeFactory.createParenthesizedArgList((Token)openParenToken, (SeparatedNodeList)arguments, (Token)closeParenToken);
        ImplicitNewExpressionNode expressionNode = NodeFactory.createImplicitNewExpressionNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.NEW_KEYWORD), (ParenthesizedArgList)parenthesizedArgList);
        AssignmentStatementNode selfWriteQueueAssignmentStatementNode = NodeFactory.createAssignmentStatementNode((Node)selfWriteMessageQueues, (Token)equalToken, (ExpressionNode)expressionNode, (Token)semicolonToken);
        assignmentNodes.add((StatementNode)selfWriteQueueAssignmentStatementNode);
        List<String> channelList = this.asyncApi.getChannels().getItemNames();
        if (channelList.size() != 1) {
            throw new BallerinaAsyncApiExceptionWs("Ballerina websocket doesn't support for multiple channels");
        }
        String path = channelList.get(0);
        if (!path.equals("/") || querySchema.getProperties() != null) {
            if (!path.equals("/")) {
                VariableDeclarationNode pathInt = this.getPathStatement(path);
                assignmentNodes.add((StatementNode)pathInt);
                this.handleParameterSchemaInOperation(querySchema, headerSchema, assignmentNodes, false);
            } else {
                this.handleParameterSchemaInOperation(querySchema, headerSchema, assignmentNodes, true);
            }
            assignmentNodes.add((StatementNode)this.ballerinaAuthConfigGenerator.getClientInitializationNode("modifiedUrl"));
        } else {
            assignmentNodes.add((StatementNode)this.ballerinaAuthConfigGenerator.getClientInitializationNode("serviceUrl"));
        }
        FieldAccessExpressionNode selfClientEp = NodeFactory.createFieldAccessExpressionNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"self")), (Token)dotToken, (NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"clientEp")));
        SimpleNameReferenceNode selfClientEpValue = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"websocketEp"));
        AssignmentStatementNode selfWebsocketClientAssignmentStatementNode = NodeFactory.createAssignmentStatementNode((Node)selfClientEp, (Token)equalToken, (ExpressionNode)selfClientEpValue, (Token)semicolonToken);
        assignmentNodes.add((StatementNode)selfWebsocketClientAssignmentStatementNode);
        ArrayList<String> whileLoopBreakVariables = new ArrayList<String>();
        whileLoopBreakVariables.add("isActive");
        for (String whileLoopBreakVariable : whileLoopBreakVariables) {
            this.addInitsOfWhileLoopBreaksNodes(whileLoopBreakVariable, assignmentNodes, SyntaxKind.TRUE_KEYWORD.stringValue());
        }
        ArrayList<String> workers = new ArrayList<String>();
        workers.add("startMessageWriting");
        workers.add("startMessageReading");
        ArrayList workersArgumentsList = new ArrayList();
        SeparatedNodeList workersArguments = AbstractNodeFactory.createSeparatedNodeList(workersArgumentsList);
        for (String worker : workers) {
            ExpressionStatementNode workerNode = NodeFactory.createExpressionStatementNode((SyntaxKind)SyntaxKind.FUNCTION_CALL, (ExpressionNode)NodeFactory.createMethodCallExpressionNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"self")), (Token)dotToken, (NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)worker)), (Token)openParenToken, (SeparatedNodeList)workersArguments, (Token)closeParenToken), (Token)semicolonToken);
            assignmentNodes.add((StatementNode)workerNode);
        }
        if (this.ballerinaAuthConfigGenerator.isHttpApiKey() && !this.ballerinaAuthConfigGenerator.isHttpOrOAuth()) {
            assignmentNodes.add((StatementNode)this.ballerinaAuthConfigGenerator.getApiKeyAssignmentNode());
        }
        if (this.ballerinaAuthConfigGenerator.isHttpApiKey()) {
            ArrayList<String> apiKeyNames = new ArrayList<String>();
            apiKeyNames.addAll(this.ballerinaAuthConfigGenerator.getHeaderApiKeyNameList().values());
            apiKeyNames.addAll(this.ballerinaAuthConfigGenerator.getQueryApiKeyNameList().values());
            this.setApiKeyNameList(apiKeyNames);
        }
        ReturnStatementNode returnStatementNode = NodeFactory.createReturnStatementNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RETURN_KEYWORD), null, (Token)semicolonToken);
        assignmentNodes.add((StatementNode)returnStatementNode);
        NodeList statementList = AbstractNodeFactory.createNodeList(assignmentNodes);
        return NodeFactory.createFunctionBodyBlockNode((Token)openBraceToken, null, (NodeList)statementList, (Token)closeBraceToken, null);
    }

    private void addInitsOfWhileLoopBreaksNodes(String initName, List<StatementNode> assignmentNodes, String booleanValue) {
        SimpleNameReferenceNode selfIsMessageWritingValue = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)booleanValue));
        FieldAccessExpressionNode selfIsMessageWriting = NodeFactory.createFieldAccessExpressionNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"self")), (Token)dotToken, (NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)initName)));
        AssignmentStatementNode selfIsMessageWritingAssignmentStatementNode = NodeFactory.createAssignmentStatementNode((Node)selfIsMessageWriting, (Token)equalToken, (ExpressionNode)selfIsMessageWritingValue, (Token)semicolonToken);
        assignmentNodes.add((StatementNode)selfIsMessageWritingAssignmentStatementNode);
    }

    private void handleParameterSchemaInOperation(AsyncApi25SchemaImpl querySchema, AsyncApi25SchemaImpl headerSchema, List<StatementNode> statementsList, boolean initalized) {
        this.handleQueryParamsAndHeaders(querySchema, headerSchema, statementsList, initalized);
    }

    public void handleQueryParamsAndHeaders(AsyncApi25SchemaImpl querySchema, AsyncApi25SchemaImpl headerSchema, List<StatementNode> statementsList, boolean initalized) {
        if (querySchema.getProperties() != null) {
            this.utilGenerator.setQueryParamsFound(true);
            statementsList.add((StatementNode)this.getMapForParameters(querySchema, "map<anydata>", "queryParam"));
            ExpressionStatementNode updatedPath = initalized ? GeneratorUtils.getSimpleExpressionStatementNode("string modifiedUrl = serviceUrl + check getPathForQueryParam(queryParam)") : GeneratorUtils.getSimpleExpressionStatementNode("modifiedUrl = modifiedUrl + check getPathForQueryParam(queryParam)");
            statementsList.add((StatementNode)updatedPath);
        }
        if (headerSchema.getProperties() != null) {
            statementsList.add((StatementNode)this.getMapForParameters(headerSchema, "map<string>", "headerParam"));
            statementsList.add((StatementNode)GeneratorUtils.getSimpleExpressionStatementNode("map<string> customHeaders = getCombineHeaders(clientConfig.customHeaders,headerParam)"));
            statementsList.add((StatementNode)GeneratorUtils.getSimpleExpressionStatementNode("clientConfig.customHeaders = customHeaders"));
            this.utilGenerator.setHeadersFound(true);
        }
    }

    private VariableDeclarationNode getMapForParameters(AsyncApi25SchemaImpl parameters, String mapDataType, String mapName) {
        ArrayList<Object> filedOfMap = new ArrayList<Object>();
        BuiltinSimpleNameReferenceNode mapType = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)AbstractNodeFactory.createIdentifierToken((String)mapDataType));
        CaptureBindingPatternNode bindingPattern = NodeFactory.createCaptureBindingPatternNode((Token)AbstractNodeFactory.createIdentifierToken((String)mapName));
        TypedBindingPatternNode bindingPatternNode = NodeFactory.createTypedBindingPatternNode((TypeDescriptorNode)mapType, (BindingPatternNode)bindingPattern);
        Map<String, Schema> properties = parameters.getProperties();
        for (Map.Entry<String, Schema> entry : properties.entrySet()) {
            IdentifierToken fieldName = AbstractNodeFactory.createIdentifierToken((String)("\"" + entry.getKey().trim() + "\""));
            SimpleNameReferenceNode valueExpr = null;
            if (((AsyncApi25SchemaImpl)entry.getValue()).getType().equals("string") || mapName.equals("queryParam")) {
                valueExpr = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)(mapName + "s." + GeneratorUtils.getValidName(entry.getKey().trim(), false))));
            } else if (!((AsyncApi25SchemaImpl)entry.getValue()).getType().equals("string") && mapName.equals("headerParam")) {
                valueExpr = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)(mapName + "s." + GeneratorUtils.getValidName(entry.getKey().trim(), false) + ".toString()")));
            }
            SpecificFieldNode specificFieldNode = NodeFactory.createSpecificFieldNode(null, (Node)fieldName, (Token)colonToken, (ExpressionNode)valueExpr);
            filedOfMap.add(specificFieldNode);
            filedOfMap.add(AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
        }
        filedOfMap.remove(filedOfMap.size() - 1);
        MappingConstructorExpressionNode initialize = NodeFactory.createMappingConstructorExpressionNode((Token)openBraceToken, (SeparatedNodeList)AbstractNodeFactory.createSeparatedNodeList(filedOfMap), (Token)closeBraceToken);
        return NodeFactory.createVariableDeclarationNode((NodeList)AbstractNodeFactory.createEmptyNodeList(), null, (TypedBindingPatternNode)bindingPatternNode, (Token)equalToken, (ExpressionNode)initialize, (Token)semicolonToken);
    }

    private VariableDeclarationNode getPathStatement(String path) {
        TypedBindingPatternNode typedBindingPatternNode = NodeFactory.createTypedBindingPatternNode((TypeDescriptorNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.STRING_KEYWORD)), (BindingPatternNode)NodeFactory.createCaptureBindingPatternNode((Token)AbstractNodeFactory.createIdentifierToken((String)"modifiedUrl")));
        path = this.generatePathWithPathParameter(path);
        NodeList content = AbstractNodeFactory.createNodeList((Node[])new Node[]{AbstractNodeFactory.createLiteralValueToken(null, (String)path, (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList(), (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList())});
        SimpleNameReferenceNode lhsExpr = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"serviceUrl"));
        TemplateExpressionNode rhsExpr = NodeFactory.createTemplateExpressionNode(null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.STRING_KEYWORD), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.BACKTICK_TOKEN), (NodeList)content, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.BACKTICK_TOKEN));
        BinaryExpressionNode initializer = NodeFactory.createBinaryExpressionNode(null, (Node)lhsExpr, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PLUS_TOKEN), (Node)rhsExpr);
        return NodeFactory.createVariableDeclarationNode((NodeList)AbstractNodeFactory.createEmptyNodeList(), null, (TypedBindingPatternNode)typedBindingPatternNode, (Token)equalToken, (ExpressionNode)initializer, (Token)semicolonToken);
    }

    public String generatePathWithPathParameter(String path) {
        if (path.contains("{")) {
            String refinedPath = path;
            Pattern p = Pattern.compile("\\{[^}]*}");
            Matcher m = p.matcher(path);
            while (m.find()) {
                String pathVariable = path.substring(m.start(), m.end());
                if (!pathVariable.startsWith("{") || !pathVariable.endsWith("}")) continue;
                String d = pathVariable.replace("{", "").replace("}", "");
                String replaceVariable = "{getEncodedUri(pathParams." + GeneratorUtils.escapeIdentifier(d.trim()) + ")}";
                refinedPath = refinedPath.replace(pathVariable, replaceVariable);
            }
            path = refinedPath.replaceAll("[{]", "\\${");
            this.utilGenerator.setPathParametersFound(true);
        }
        return path;
    }

    private FunctionSignatureNode getInitFunctionSignatureNode(AsyncApi25SchemaImpl querySchema, AsyncApi25SchemaImpl headerSchema) throws BallerinaAsyncApiExceptionWs {
        this.serverURL = this.getServerURL((AsyncApi25ServersImpl)this.asyncApi.getServers());
        ArrayList<Node> parameters = new ArrayList<Node>();
        AsyncApiChannelItem channelItem = (AsyncApiChannelItem)this.asyncApi.getChannels().getItems().get(0);
        this.ballerinaAuthConfigGenerator.setFunctionParameters(channelItem, parameters, AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN), querySchema, headerSchema);
        this.ballerinaAuthConfigGenerator.getConfigParamForClassInit(this.serverURL, parameters);
        SeparatedNodeList parameterList = AbstractNodeFactory.createSeparatedNodeList(parameters);
        OptionalTypeDescriptorNode returnType = NodeFactory.createOptionalTypeDescriptorNode((Node)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ERROR_KEYWORD), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.QUESTION_MARK_TOKEN));
        ReturnTypeDescriptorNode returnTypeDescriptorNode = NodeFactory.createReturnTypeDescriptorNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RETURNS_KEYWORD), (NodeList)AbstractNodeFactory.createEmptyNodeList(), (Node)returnType);
        return NodeFactory.createFunctionSignatureNode((Token)openParenToken, (SeparatedNodeList)parameterList, (Token)closeParenToken, (ReturnTypeDescriptorNode)returnTypeDescriptorNode);
    }

    private MetadataNode getInitDocComment() {
        ArrayList<Object> docs = new ArrayList<Object>();
        String clientInitDocComment = "Gets invoked to initialize the `connector`.\n";
        Map<String, JsonNode> extensions = ((AsyncApi25InfoImpl)this.asyncApi.getInfo()).getExtensions();
        if (extensions != null && !extensions.isEmpty()) {
            for (Map.Entry<String, JsonNode> extension : extensions.entrySet()) {
                if (!extension.getKey().trim().equals("x-ballerina-init-description")) continue;
                clientInitDocComment = clientInitDocComment.concat(extension.getValue().toString());
                break;
            }
        }
        docs.addAll(DocCommentsGenerator.createAPIDescriptionDoc(clientInitDocComment, true));
        if (this.ballerinaAuthConfigGenerator.isHttpApiKey() && !this.ballerinaAuthConfigGenerator.isHttpOrOAuth()) {
            MarkdownParameterDocumentationLineNode apiKeyConfig = DocCommentsGenerator.createAPIParamDoc("apiKeyConfig", "API keys for authorization");
            docs.add(apiKeyConfig);
        }
        MarkdownParameterDocumentationLineNode clientConfig = DocCommentsGenerator.createAPIParamDoc("config", "The configurations to be used when initializing the `connector`");
        docs.add(clientConfig);
        MarkdownParameterDocumentationLineNode serviceUrlAPI = DocCommentsGenerator.createAPIParamDoc("serviceUrl", "URL of the target service");
        docs.add(serviceUrlAPI);
        MarkdownParameterDocumentationLineNode returnDoc = DocCommentsGenerator.createAPIParamDoc("return", "An error if connector initialization failed");
        docs.add(returnDoc);
        if (this.ballerinaAuthConfigGenerator.isPathParam()) {
            MarkdownParameterDocumentationLineNode pathParamDocNode = DocCommentsGenerator.createAPIParamDoc("pathParams", "path parameters");
            docs.add(pathParamDocNode);
        }
        if (this.ballerinaAuthConfigGenerator.isQueryParam()) {
            MarkdownParameterDocumentationLineNode queryParamDocNode = DocCommentsGenerator.createAPIParamDoc("queryParams", "query parameters");
            docs.add(queryParamDocNode);
        }
        if (this.ballerinaAuthConfigGenerator.isHeaderParam()) {
            MarkdownParameterDocumentationLineNode headerParamDocNode = DocCommentsGenerator.createAPIParamDoc("headerParams", "header parameters");
            docs.add(headerParamDocNode);
        }
        MarkdownDocumentationNode clientInitDoc = NodeFactory.createMarkdownDocumentationNode((NodeList)AbstractNodeFactory.createNodeList(docs));
        return NodeFactory.createMetadataNode((Node)clientInitDoc, (NodeList)AbstractNodeFactory.createEmptyNodeList());
    }

    private MetadataNode getDocCommentsForWorker(String functionType, String comment) {
        ArrayList<MarkdownDocumentationLineNode> docs = new ArrayList<MarkdownDocumentationLineNode>();
        Map<String, JsonNode> extensions = ((AsyncApi25InfoImpl)this.asyncApi.getInfo()).getExtensions();
        if (extensions != null && !extensions.isEmpty()) {
            for (Map.Entry<String, JsonNode> extension : extensions.entrySet()) {
                if (!extension.getKey().trim().equals(functionType)) continue;
                comment = comment.concat(extension.getValue().toString());
                break;
            }
        }
        docs.addAll(DocCommentsGenerator.createAPIDescriptionDoc(comment, true));
        MarkdownDocumentationNode workerDoc = NodeFactory.createMarkdownDocumentationNode((NodeList)AbstractNodeFactory.createNodeList(docs));
        return NodeFactory.createMetadataNode((Node)workerDoc, (NodeList)AbstractNodeFactory.createEmptyNodeList());
    }

    private List<ObjectFieldNode> createClassInstanceVariables(boolean isStreamPresent) {
        ArrayList<ObjectFieldNode> fieldNodeList = new ArrayList<ObjectFieldNode>();
        Token privateKeywordToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PRIVATE_KEYWORD);
        Token finalKeywordToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.FINAL_KEYWORD);
        ArrayList<Token> prefixTokensForPrivateAndFinal = new ArrayList<Token>();
        ArrayList<Token> prefixTokensForOnlyPrivate = new ArrayList<Token>();
        prefixTokensForPrivateAndFinal.add(privateKeywordToken);
        prefixTokensForPrivateAndFinal.add(finalKeywordToken);
        prefixTokensForOnlyPrivate.add(privateKeywordToken);
        NodeList qualifiersWithPrivateAndFinal = AbstractNodeFactory.createNodeList(prefixTokensForPrivateAndFinal);
        NodeList qualifiersWithOnlyPrivate = AbstractNodeFactory.createNodeList(prefixTokensForOnlyPrivate);
        QualifiedNameReferenceNode websocketType = NodeFactory.createQualifiedNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"websocket"), (Node)colonToken, (IdentifierToken)AbstractNodeFactory.createIdentifierToken((String)"Client"));
        ObjectFieldNode websocketClientField = IntermediateClientGenerator.getObjectFieldNode((NodeList<Token>)qualifiersWithPrivateAndFinal, (Node)websocketType, "clientEp");
        fieldNodeList.add(websocketClientField);
        QualifiedNameReferenceNode pipeType = NodeFactory.createQualifiedNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"pipe"), (Node)colonToken, (IdentifierToken)AbstractNodeFactory.createIdentifierToken((String)"Pipe"));
        ObjectFieldNode writeMessageQueueClientField = IntermediateClientGenerator.getObjectFieldNode((NodeList<Token>)qualifiersWithPrivateAndFinal, (Node)pipeType, "writeMessageQueue");
        fieldNodeList.add(writeMessageQueueClientField);
        SimpleNameReferenceNode pipesType = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"PipesMap"));
        ObjectFieldNode pipesField = IntermediateClientGenerator.getObjectFieldNode((NodeList<Token>)qualifiersWithPrivateAndFinal, (Node)pipesType, "pipes");
        fieldNodeList.add(pipesField);
        if (isStreamPresent) {
            SimpleNameReferenceNode streamGeneratorsType = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"StreamGeneratorsMap"));
            ObjectFieldNode streamGeneratorsField = IntermediateClientGenerator.getObjectFieldNode((NodeList<Token>)qualifiersWithPrivateAndFinal, (Node)streamGeneratorsType, "streamGenerators");
            fieldNodeList.add(streamGeneratorsField);
        }
        SimpleNameReferenceNode booleanType = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"boolean"));
        ObjectFieldNode isActiveField = IntermediateClientGenerator.getObjectFieldNode((NodeList<Token>)qualifiersWithOnlyPrivate, (Node)booleanType, "isActive");
        fieldNodeList.add(isActiveField);
        ObjectFieldNode apiKeyFieldNode = this.ballerinaAuthConfigGenerator.getApiKeyMapClassVariable();
        if (apiKeyFieldNode != null) {
            fieldNodeList.add(apiKeyFieldNode);
        }
        String jsonString = this.responseMap.entrySet().stream().map(entry -> String.format("\"%s\": \"%s\"", entry.getKey(), entry.getValue())).collect(Collectors.joining(",\n\t\t", "{\n\t\t", "\n\t}"));
        TypeDescriptorNode typeDescriptor = NodeParser.parseTypeDescriptor((String)"readonly & map<string>");
        ExpressionNode expression = NodeParser.parseExpression((String)jsonString);
        ObjectFieldNode responseMapField = NodeFactory.createObjectFieldNode(null, null, (NodeList)qualifiersWithPrivateAndFinal, (Node)typeDescriptor, (Token)AbstractNodeFactory.createIdentifierToken((String)"responseMap"), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (ExpressionNode)expression, (Token)semicolonToken);
        fieldNodeList.add(responseMapField);
        return fieldNodeList;
    }

    private List<FunctionDefinitionNode> createRemoteFunctions(ArrayList<String> streamReturns, List<String> pipeIdMethods) throws BallerinaAsyncApiExceptionWs {
        Map<String, JsonNode> extensions;
        String messageName;
        String reference;
        AsyncApi25MessageImpl message;
        ListIterator<AsyncApiMessage> it;
        List<AsyncApiMessage> publishMessages;
        Map<String, AsyncApiMessage> messages = this.asyncApi.getComponents().getMessages();
        ArrayList<FunctionDefinitionNode> functionDefinitionNodeList = new ArrayList<FunctionDefinitionNode>();
        ArrayList<String> remainingResponseMessages = new ArrayList<String>();
        AsyncApiOperation publishOperation = ((AsyncApiChannelItem)this.asyncApi.getChannels().getItems().get(0)).getPublish();
        if (!Objects.isNull(publishOperation) && !(publishMessages = this.getAsyncApiMessages()).isEmpty()) {
            ListIterator<AsyncApiMessage> requestMessages;
            it = requestMessages = publishMessages.listIterator();
            while (it.hasNext()) {
                message = (AsyncApi25MessageImpl)it.next();
                reference = message.get$ref();
                messageName = GeneratorUtils.extractReferenceType(reference);
                AsyncApi25MessageImpl componentMessage = (AsyncApi25MessageImpl)messages.get(messageName);
                extensions = componentMessage.getExtensions();
                FunctionDefinitionNode functionDefinitionNode = (extensions = this.removeCloseFrameFromResponse(extensions)) != null && extensions.get("x-response") != null ? this.getRemoteFunctionDefinitionNode(messageName, componentMessage, extensions, pipeIdMethods, remainingResponseMessages, false, streamReturns) : this.getRemoteFunctionDefinitionNode(messageName, componentMessage, null, pipeIdMethods, null, false, null);
                functionDefinitionNodeList.add(functionDefinitionNode);
            }
        }
        this.setUtilGenerator(new UtilGenerator(streamReturns));
        if (((AsyncApiChannelItem)this.asyncApi.getChannels().getItems().get(0)).getSubscribe() != null) {
            List<AsyncApiMessage> subscribeMessages = null;
            if (((AsyncApiChannelItem)this.asyncApi.getChannels().getItems().get(0)).getSubscribe().getMessage().getOneOf() != null) {
                subscribeMessages = ((AsyncApiChannelItem)this.asyncApi.getChannels().getItems().get(0)).getSubscribe().getMessage().getOneOf();
            } else if (((AsyncApiChannelItem)this.asyncApi.getChannels().getItems().get(0)).getSubscribe().getMessage() != null) {
                AsyncApiMessage asyncApiMessage = ((AsyncApiChannelItem)this.asyncApi.getChannels().getItems().get(0)).getSubscribe().getMessage();
                ArrayList<AsyncApiMessage> oneSubscribeMessage = new ArrayList<AsyncApiMessage>();
                oneSubscribeMessage.add(asyncApiMessage);
                subscribeMessages = oneSubscribeMessage;
            }
            if (subscribeMessages != null) {
                ListIterator<AsyncApiMessage> responseMessages = subscribeMessages.listIterator();
                it = responseMessages;
                while (it.hasNext()) {
                    AsyncApi25Schema refSchema;
                    message = (AsyncApi25MessageImpl)it.next();
                    reference = message.get$ref();
                    messageName = GeneratorUtils.extractReferenceType(reference);
                    if (remainingResponseMessages.contains(messageName) || AsyncApiRemoteMapper.isCloseFrameSchema(refSchema = (AsyncApi25Schema)this.asyncApi.getComponents().getSchemas().get(messageName))) continue;
                    extensions = new LinkedHashMap<String, JsonNode>();
                    AsyncApi25MessageImpl newMessage = new AsyncApi25MessageImpl();
                    ObjectNode objectNode = new ObjectNode(JsonNodeFactory.instance);
                    objectNode.put("$ref", reference);
                    extensions.put("x-response", (JsonNode)objectNode);
                    newMessage.addExtension("x-response", (JsonNode)objectNode);
                    extensions.put("x-response-type", (JsonNode)new TextNode("simple-rpc"));
                    newMessage.addExtension("x-response-type", (JsonNode)new TextNode("simple-rpc"));
                    FunctionDefinitionNode functionDefinitionNode = this.getRemoteFunctionDefinitionNode(messageName, newMessage, extensions, pipeIdMethods, null, true, streamReturns);
                    functionDefinitionNodeList.add(functionDefinitionNode);
                }
            }
        }
        functionDefinitionNodeList.add(this.createAttemptToCloseConnectionFunction());
        functionDefinitionNodeList.add(this.createConnectionCloseFunction(!streamReturns.isEmpty()));
        return functionDefinitionNodeList;
    }

    private Map<String, JsonNode> removeCloseFrameFromResponse(Map<String, JsonNode> extensions) throws BallerinaAsyncApiExceptionWs {
        JsonNode jsonNode;
        if (Objects.isNull(extensions) || Objects.isNull(extensions.get("x-response"))) {
            return extensions;
        }
        JsonNode xResponse = extensions.get("x-response");
        if (Objects.nonNull(xResponse.get("oneOf")) && (jsonNode = xResponse.get("oneOf")) instanceof ArrayNode) {
            ArrayNode nodes = (ArrayNode)jsonNode;
            ObjectNode newNode = (ObjectNode)extensions.get("x-response");
            Iterator it = nodes.iterator();
            while (it.hasNext()) {
                JsonNode jsonNode2 = (JsonNode)it.next();
                if (!Objects.nonNull(jsonNode2.get("$ref")) || !this.isCloseFrameRef(jsonNode2.get("$ref"))) continue;
                it.remove();
            }
            if (nodes.isEmpty()) {
                return Collections.emptyMap();
            }
            if (nodes.size() == 1) {
                newNode.remove("oneOf");
                newNode.set("$ref", nodes.get(0).get("$ref"));
            } else {
                newNode.set("oneOf", (JsonNode)nodes);
            }
            extensions.put("x-response", (JsonNode)newNode);
        } else if (Objects.nonNull(xResponse.get("$ref")) && this.isCloseFrameRef(xResponse.get("$ref"))) {
            return Collections.emptyMap();
        }
        return extensions;
    }

    private boolean isCloseFrameRef(JsonNode refNode) throws BallerinaAsyncApiExceptionWs {
        if (Objects.isNull(refNode)) {
            return false;
        }
        String reference = refNode.asText();
        String messageName = GeneratorUtils.extractReferenceType(reference);
        AsyncApiMessage message = this.asyncApi.getComponents().getMessages().get(messageName);
        TextNode schemaReference = (TextNode)message.getPayload().get("$ref");
        String schemaName = GeneratorUtils.extractReferenceType(schemaReference.asText());
        AsyncApiSchema refSchema = (AsyncApiSchema)this.asyncApi.getComponents().getSchemas().get(schemaName);
        return AsyncApiRemoteMapper.isCloseFrameSchema(refSchema);
    }

    private List<AsyncApiMessage> getAsyncApiMessages() {
        List<Object> publishMessages = new ArrayList();
        if (((AsyncApiChannelItem)this.asyncApi.getChannels().getItems().get(0)).getPublish().getMessage().getOneOf() != null) {
            publishMessages = ((AsyncApiChannelItem)this.asyncApi.getChannels().getItems().get(0)).getPublish().getMessage().getOneOf();
        } else if (((AsyncApiChannelItem)this.asyncApi.getChannels().getItems().get(0)).getPublish().getMessage() != null) {
            AsyncApiMessage asyncApiMessage = ((AsyncApiChannelItem)this.asyncApi.getChannels().getItems().get(0)).getPublish().getMessage();
            ArrayList<AsyncApiMessage> onePublishMessage = new ArrayList<AsyncApiMessage>();
            onePublishMessage.add(asyncApiMessage);
            publishMessages = onePublishMessage;
        }
        return publishMessages;
    }

    private FunctionDefinitionNode createAttemptToCloseConnectionFunction() {
        ArrayList<Object> statements = new ArrayList<Object>();
        statements.add(NodeParser.parseStatement((String)"error? connectionClose = self->connectionClose();"));
        statements.add(NodeFactory.createIfElseStatementNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.IF_KEYWORD), (ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"connectionClose is error")), (BlockStatementNode)NodeFactory.createBlockStatementNode((Token)openBraceToken, (NodeList)AbstractNodeFactory.createNodeList((Node[])new StatementNode[]{NodeParser.parseStatement((String)String.format("log:printError(%s);", "\"ConnectionError\", connectionClose"))}), (Token)closeBraceToken), null));
        return NodeFactory.createFunctionDefinitionNode((SyntaxKind)SyntaxKind.FUNCTION_DEFINITION, null, (NodeList)AbstractNodeFactory.createNodeList((Node[])new Token[]{AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ISOLATED_KEYWORD)}), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.FUNCTION_KEYWORD), (IdentifierToken)AbstractNodeFactory.createIdentifierToken((String)"attemptToCloseConnection"), (NodeList)AbstractNodeFactory.createEmptyNodeList(), (FunctionSignatureNode)NodeFactory.createFunctionSignatureNode((Token)openParenToken, (SeparatedNodeList)AbstractNodeFactory.createSeparatedNodeList((Node[])new Node[0]), (Token)closeParenToken, null), (FunctionBodyNode)NodeFactory.createFunctionBodyBlockNode((Token)openBraceToken, null, (NodeList)AbstractNodeFactory.createNodeList(statements), (Token)closeBraceToken, null));
    }

    private FunctionDefinitionNode createConnectionCloseFunction(boolean streamsPresent) {
        ArrayList<StatementNode> lockStatements = new ArrayList<StatementNode>();
        this.addInitsOfWhileLoopBreaksNodes("isActive", lockStatements, SyntaxKind.FALSE_KEYWORD.stringValue());
        ExpressionStatementNode writeMessageStatementNode = this.getCloseLockStatementNode("writeMessageQueue", "immediateClose", dotToken);
        lockStatements.add((StatementNode)writeMessageStatementNode);
        ExpressionStatementNode removePipesNode = this.getCloseLockStatementNode("pipes", "removePipes", dotToken);
        lockStatements.add((StatementNode)removePipesNode);
        if (streamsPresent) {
            ExpressionStatementNode removeStreamGeneratorsNode = this.getCloseLockStatementNode("streamGenerators", "removeStreamGenerators", dotToken);
            lockStatements.add((StatementNode)removeStreamGeneratorsNode);
        }
        ExpressionStatementNode clientCloseNode = this.getCloseLockStatementNode("clientEp", "close", rightArrowToken);
        lockStatements.add((StatementNode)clientCloseNode);
        LockStatementNode lockStatementNode = NodeFactory.createLockStatementNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.LOCK_KEYWORD), (BlockStatementNode)NodeFactory.createBlockStatementNode((Token)openBraceToken, (NodeList)AbstractNodeFactory.createNodeList(lockStatements), (Token)closeBraceToken), null);
        IdentifierToken functionName = AbstractNodeFactory.createIdentifierToken((String)"connectionClose");
        return this.getAdditionalFunctionDefinitionNode(functionName, lockStatementNode);
    }

    private FunctionDefinitionNode getAdditionalFunctionDefinitionNode(IdentifierToken functionName, LockStatementNode lockStatementNode) {
        ReturnTypeDescriptorNode returnTypeDescriptorNode = NodeFactory.createReturnTypeDescriptorNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RETURNS_KEYWORD), (NodeList)AbstractNodeFactory.createNodeList((Node[])new AnnotationNode[0]), (Node)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"error?")));
        FunctionSignatureNode functionSignatureNode = NodeFactory.createFunctionSignatureNode((Token)openParenToken, (SeparatedNodeList)AbstractNodeFactory.createSeparatedNodeList((Node[])new Node[0]), (Token)closeParenToken, (ReturnTypeDescriptorNode)returnTypeDescriptorNode);
        FunctionBodyBlockNode functionBodyNode = NodeFactory.createFunctionBodyBlockNode((Token)openBraceToken, null, (NodeList)AbstractNodeFactory.createNodeList((Node[])new StatementNode[]{lockStatementNode}), (Token)closeBraceToken, (Token)semicolonToken);
        MetadataNode metadataNode = NodeFactory.createMetadataNode(null, (NodeList)AbstractNodeFactory.createNodeList((Node[])new AnnotationNode[0]));
        NodeList qualifierList = AbstractNodeFactory.createNodeList((Node[])new Token[]{AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.REMOTE_KEYWORD), AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ISOLATED_KEYWORD)});
        Token functionKeyWord = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.FUNCTION_KEYWORD);
        return NodeFactory.createFunctionDefinitionNode((SyntaxKind)SyntaxKind.OBJECT_METHOD_DEFINITION, (MetadataNode)metadataNode, (NodeList)qualifierList, (Token)functionKeyWord, (IdentifierToken)functionName, (NodeList)AbstractNodeFactory.createEmptyNodeList(), (FunctionSignatureNode)functionSignatureNode, (FunctionBodyNode)functionBodyNode);
    }

    private ExpressionStatementNode getCloseLockStatementNode(String messageQueue, String closeType, Token divideToken) {
        FieldAccessExpressionNode writeMessageQueue = NodeFactory.createFieldAccessExpressionNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"self")), (Token)dotToken, (NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)messageQueue)));
        CheckExpressionNode checkExpressionNode = NodeFactory.createCheckExpressionNode(null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CHECK_KEYWORD), (ExpressionNode)NodeFactory.createMethodCallExpressionNode((ExpressionNode)writeMessageQueue, (Token)divideToken, (NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)closeType)), (Token)openParenToken, (SeparatedNodeList)AbstractNodeFactory.createSeparatedNodeList((Node[])new Node[0]), (Token)closeParenToken));
        return NodeFactory.createExpressionStatementNode(null, (ExpressionNode)checkExpressionNode, (Token)semicolonToken);
    }

    private FunctionDefinitionNode getRemoteFunctionDefinitionNode(String messageName, AsyncApi25MessageImpl messageValue, Map<String, JsonNode> extensions, List<String> pipeIdMethods, ArrayList<String> responseMessages, boolean isSubscribe, List<String> streamReturns) throws BallerinaAsyncApiExceptionWs {
        String specDispatcherStreamId = this.dispatcherStreamId;
        Map<String, Schema> schemas = this.asyncApi.getComponents().getSchemas();
        ArrayList<Object> remoteFunctionDocs = new ArrayList<Object>();
        if (messageValue.getSummary() != null) {
            remoteFunctionDocs.addAll(DocCommentsGenerator.createAPIDescriptionDoc(messageValue.getSummary(), true));
        } else if (messageValue.getDescription() != null && !messageValue.getDescription().isBlank()) {
            remoteFunctionDocs.addAll(DocCommentsGenerator.createAPIDescriptionDoc(messageValue.getDescription(), true));
        }
        this.remoteFunctionNameList.add(messageName);
        String responseType = null;
        if (extensions != null) {
            JsonNode xResponse = extensions.get("x-response");
            JsonNode xResponseType = extensions.get("x-response-type");
            responseType = this.functionReturnType.getReturnType(xResponse, xResponseType, responseMessages);
        }
        RemoteFunctionSignatureGenerator remoteFunctionSignatureGenerator = new RemoteFunctionSignatureGenerator(this.asyncApi, this.ballerinaSchemaGenerator, this.typeDefinitionNodeList);
        ArrayList<Node> remoteFunctionDocParameters = new ArrayList<Node>();
        FunctionSignatureNode functionSignatureNode = remoteFunctionSignatureGenerator.getFunctionSignatureNode(messageValue.getPayload(), remoteFunctionDocParameters, extensions, responseType, streamReturns);
        if (!remoteFunctionDocParameters.isEmpty()) {
            if (remoteFunctionDocs.isEmpty()) {
                MarkdownDocumentationLineNode newLine = NodeFactory.createMarkdownDocumentationLineNode(null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.HASH_TOKEN), (NodeList)AbstractNodeFactory.createEmptyNodeList());
                remoteFunctionDocs.add(newLine);
            }
            remoteFunctionDocs.addAll(remoteFunctionDocParameters);
        }
        this.typeDefinitionNodeList = remoteFunctionSignatureGenerator.getTypeDefinitionNodeList();
        MetadataNode metadataNode = NodeFactory.createMetadataNode((Node)NodeFactory.createMarkdownDocumentationNode((NodeList)AbstractNodeFactory.createNodeList(remoteFunctionDocs)), (NodeList)AbstractNodeFactory.createNodeList((Node[])new AnnotationNode[0]));
        String functionNameString = "do" + GeneratorUtils.getValidName(messageName, true);
        RemoteFunctionBodyGenerator remoteFunctionBodyGenerator = new RemoteFunctionBodyGenerator(this.imports, functionNameString);
        boolean schemaDispatcherStreamIdContains = false;
        if (messageValue.getPayload() != null) {
            JsonNode jsonNode = messageValue.getPayload();
            TextNode textNode = (TextNode)jsonNode.get("$ref");
            String schemaName = GeneratorUtils.extractReferenceType(textNode.asText());
            String[] schema = (String[])schemas.get(schemaName);
            CommonFunctionUtils commonFunctionUtils = new CommonFunctionUtils(this.asyncApi);
            schemaDispatcherStreamIdContains = commonFunctionUtils.isDispatcherPresent(schemaName, (AsyncApi25SchemaImpl)schema, specDispatcherStreamId, true);
        }
        if (!Objects.isNull(specDispatcherStreamId) && !schemaDispatcherStreamIdContains) {
            specDispatcherStreamId = null;
        } else if (!Objects.isNull(specDispatcherStreamId)) {
            pipeIdMethods.add(messageName);
            ImportDeclarationNode importForUUID = GeneratorUtils.getImportDeclarationNode("ballerina", "uuid");
            if (pipeIdMethods.size() == 1) {
                // empty if block
            }
        }
        String requestTypeCamelCaseName = Character.toLowerCase(messageName.charAt(0)) + messageName.substring(1);
        FunctionBodyNode functionBodyNode = remoteFunctionBodyGenerator.getFunctionBodyNode(extensions, requestTypeCamelCaseName, specDispatcherStreamId, isSubscribe, responseType);
        if (Objects.nonNull(responseType)) {
            if (responseType.contains("|")) {
                String[] responseTypes;
                for (String type : responseTypes = responseType.split("\\|")) {
                    this.responseMap.put(type, requestTypeCamelCaseName);
                }
            } else {
                this.responseMap.put(responseType, requestTypeCamelCaseName);
            }
        }
        NodeList qualifierList = AbstractNodeFactory.createNodeList((Node[])new Token[]{AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.REMOTE_KEYWORD), AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ISOLATED_KEYWORD)});
        Token functionKeyWord = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.FUNCTION_KEYWORD);
        IdentifierToken functionName = AbstractNodeFactory.createIdentifierToken((String)functionNameString);
        return NodeFactory.createFunctionDefinitionNode((SyntaxKind)SyntaxKind.OBJECT_METHOD_DEFINITION, (MetadataNode)metadataNode, (NodeList)qualifierList, (Token)functionKeyWord, (IdentifierToken)functionName, (NodeList)AbstractNodeFactory.createEmptyNodeList(), (FunctionSignatureNode)functionSignatureNode, (FunctionBodyNode)functionBodyNode);
    }

    private String getServerURL(AsyncApi25ServersImpl servers) throws BallerinaAsyncApiExceptionWs {
        if (!Objects.isNull(servers)) {
            String serverURL;
            List<AsyncApiServer> serversList = servers.getItems();
            AsyncApi25ServerImpl selectedServer = (AsyncApi25ServerImpl)serversList.get(0);
            if (!selectedServer.getUrl().startsWith("wss:") && servers.getItems().size() > 1) {
                for (AsyncApiServer server : serversList) {
                    if (!server.getUrl().startsWith("wss:")) continue;
                    selectedServer = (AsyncApi25ServerImpl)server;
                    break;
                }
            }
            if (selectedServer.getUrl() == null) {
                serverURL = "ws://localhost:9090/v1";
            } else if (selectedServer.getVariables() != null) {
                Map<String, ServerVariable> variables = selectedServer.getVariables();
                String resolvedUrl = GeneratorUtils.buildUrl(selectedServer.getUrl(), variables);
                try {
                    new URI(resolvedUrl);
                }
                catch (URISyntaxException e) {
                    throw new BallerinaAsyncApiExceptionWs("Failed to read endpoint details of the server: " + selectedServer.getUrl(), e);
                }
                serverURL = resolvedUrl;
            } else {
                serverURL = selectedServer.getUrl();
            }
            return serverURL;
        }
        String serverURL = "/";
        return serverURL;
    }

    public List<String> getApiKeyNameList() {
        return this.apiKeyNameList;
    }

    public void setApiKeyNameList(List<String> apiKeyNameList) {
        this.apiKeyNameList = Collections.unmodifiableList(apiKeyNameList);
    }
}

