/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.websocketscore.generators.client;

import com.fasterxml.jackson.databind.JsonNode;
import io.ballerina.asyncapi.websocketscore.GeneratorConstants;
import io.ballerina.asyncapi.websocketscore.GeneratorUtils;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.Constants;
import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.AssignmentStatementNode;
import io.ballerina.compiler.syntax.tree.BindingPatternNode;
import io.ballerina.compiler.syntax.tree.BlockStatementNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionStatementNode;
import io.ballerina.compiler.syntax.tree.FieldAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyNode;
import io.ballerina.compiler.syntax.tree.ImplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.LockStatementNode;
import io.ballerina.compiler.syntax.tree.MethodCallExpressionNode;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.compiler.syntax.tree.ParenthesizedArgList;
import io.ballerina.compiler.syntax.tree.ReturnStatementNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.StreamTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.StreamTypeParamsNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypedBindingPatternNode;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RemoteFunctionBodyGenerator {
    private final List<ImportDeclarationNode> imports;
    private final String functionName;
    private static final Token openParenToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN);
    private static final Token closeParenToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN);
    private static final Token openBraceToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN);
    private static final Token closeBraceToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN);
    private static final Token semicolonToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN);
    private static final Token equalToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN);
    private static final Token dotToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.DOT_TOKEN);

    public RemoteFunctionBodyGenerator(List<ImportDeclarationNode> imports, String functionName) {
        this.imports = Collections.unmodifiableList(imports);
        this.functionName = functionName;
    }

    private void addProduceStatementForWriteMessageQueue(List<StatementNode> statementsList, String requestType, boolean isSubscribe) {
        if (!isSubscribe) {
            SimpleNameReferenceNode requestTypeNameNode = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)requestType));
            VariableDeclarationNode messageVariableDeclarationNode = NodeFactory.createVariableDeclarationNode((NodeList)AbstractNodeFactory.createEmptyNodeList(), null, (TypedBindingPatternNode)NodeFactory.createTypedBindingPatternNode((TypeDescriptorNode)NodeParser.parseTypeDescriptor((String)"Message|error"), (BindingPatternNode)NodeFactory.createCaptureBindingPatternNode((Token)AbstractNodeFactory.createIdentifierToken((String)"message"))), (Token)equalToken, (ExpressionNode)NodeFactory.createMethodCallExpressionNode((ExpressionNode)requestTypeNameNode, (Token)dotToken, (NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"cloneWithType")), (Token)openParenToken, (SeparatedNodeList)AbstractNodeFactory.createSeparatedNodeList((Node[])new Node[0]), (Token)closeParenToken), (Token)semicolonToken);
            statementsList.add((StatementNode)messageVariableDeclarationNode);
            statementsList.add(this.getCloningMessageError("message"));
            statementsList.addAll(this.getProduceToWriteMessageQueueVar());
        }
    }

    private List<StatementNode> getProduceToWriteMessageQueueVar() {
        ArrayList<StatementNode> statements = new ArrayList<StatementNode>();
        ArrayList<Object> arguments = new ArrayList<Object>();
        arguments.add(NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"message")));
        arguments.add(AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
        arguments.add(NodeFactory.createPositionalArgumentNode((ExpressionNode)NodeFactory.createRequiredExpressionNode((Token)AbstractNodeFactory.createIdentifierToken((String)"timeout"))));
        FieldAccessExpressionNode globalQueue = NodeFactory.createFieldAccessExpressionNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"self")), (Token)dotToken, (NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"writeMessageQueue")));
        MethodCallExpressionNode callGlobalQueueProduce = NodeFactory.createMethodCallExpressionNode((ExpressionNode)globalQueue, (Token)dotToken, (NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"produce")), (Token)openParenToken, (SeparatedNodeList)AbstractNodeFactory.createSeparatedNodeList(arguments), (Token)closeParenToken);
        statements.add((StatementNode)NodeFactory.createVariableDeclarationNode((NodeList)AbstractNodeFactory.createEmptyNodeList(), null, (TypedBindingPatternNode)NodeFactory.createTypedBindingPatternNode((TypeDescriptorNode)NodeFactory.createOptionalTypeDescriptorNode((Node)GeneratorConstants.PIPE_ERROR_NODE, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.QUESTION_MARK_TOKEN)), (BindingPatternNode)NodeFactory.createFieldBindingPatternVarnameNode((SimpleNameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"pipeErr")))), (Token)equalToken, (ExpressionNode)callGlobalQueueProduce, (Token)semicolonToken));
        statements.add(this.getPipeError("pipeErr", "producing"));
        return statements;
    }

    private StatementNode getCloningMessageError(String varName) {
        return NodeFactory.createIfElseStatementNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.IF_KEYWORD), (ExpressionNode)NodeParser.parseExpression((String)(varName + " is error")), (BlockStatementNode)NodeFactory.createBlockStatementNode((Token)openBraceToken, (NodeList)AbstractNodeFactory.createNodeList((Node[])new StatementNode[]{GeneratorConstants.ATTEMPT_CON_CLOSE, NodeFactory.createReturnStatementNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RETURN_KEYWORD), (ExpressionNode)NodeFactory.createErrorConstructorExpressionNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ERROR_KEYWORD), null, (Token)openParenToken, (SeparatedNodeList)AbstractNodeFactory.createSeparatedNodeList((Node[])new Node[]{AbstractNodeFactory.createIdentifierToken((String)String.format("\"DataBindingError: Error in cloning message\"", new Object[0])), AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN), AbstractNodeFactory.createIdentifierToken((String)varName)}), (Token)closeParenToken), (Token)semicolonToken)}), (Token)closeBraceToken), null);
    }

    private StatementNode getPipeError(String errVar, String activity) {
        return NodeFactory.createIfElseStatementNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.IF_KEYWORD), (ExpressionNode)NodeParser.parseExpression((String)(errVar + " is " + String.valueOf(GeneratorConstants.PIPE_ERROR_NODE))), (BlockStatementNode)NodeFactory.createBlockStatementNode((Token)openBraceToken, (NodeList)AbstractNodeFactory.createNodeList((Node[])new StatementNode[]{GeneratorConstants.ATTEMPT_CON_CLOSE, NodeFactory.createReturnStatementNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RETURN_KEYWORD), (ExpressionNode)NodeFactory.createErrorConstructorExpressionNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ERROR_KEYWORD), null, (Token)openParenToken, (SeparatedNodeList)AbstractNodeFactory.createSeparatedNodeList((Node[])new Node[]{AbstractNodeFactory.createIdentifierToken((String)String.format("\"PipeError: Error in %s message\"", activity)), AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN), AbstractNodeFactory.createIdentifierToken((String)errVar)}), (Token)closeParenToken), (Token)semicolonToken)}), (Token)closeBraceToken), null);
    }

    public List<ImportDeclarationNode> getImports() {
        return this.imports;
    }

    public FunctionBodyNode getFunctionBodyNode(Map<String, JsonNode> extensions, String requestType, String specDispatcherStreamId, boolean isSubscribe, String responseType) {
        ArrayList<StatementNode> statementsList = new ArrayList<StatementNode>();
        if (extensions != null) {
            JsonNode xResponseType = extensions.get("x-response-type");
            if (Constants.SERVER_STREAMING_TYPE_NODE.equals((Object)xResponseType)) {
                this.createStreamFunctionBodyStatements(statementsList, requestType, responseType, specDispatcherStreamId, isSubscribe);
            } else {
                this.createSimpleRPCFunctionBodyStatements(statementsList, requestType, responseType, specDispatcherStreamId, isSubscribe);
            }
        } else {
            this.createNoResponseFunctionBodyStatement(statementsList, requestType);
        }
        NodeList statements = AbstractNodeFactory.createNodeList(statementsList);
        return NodeFactory.createFunctionBodyBlockNode((Token)openBraceToken, null, (NodeList)statements, (Token)closeBraceToken, null);
    }

    private void createStreamFunctionBodyStatements(List<StatementNode> statementsList, String requestType, String responseType, String dispatcherStreamId, boolean isSubscribe) {
        Object pipeId = String.format("\"%s\"", requestType);
        if (!isSubscribe) {
            statementsList.add((StatementNode)this.getConnectionActiveCheck());
        }
        if (!Objects.isNull(dispatcherStreamId)) {
            pipeId = requestType + "." + GeneratorUtils.escapeIdentifier(dispatcherStreamId);
        }
        this.addProduceStatementForWriteMessageQueue(statementsList, requestType, isSubscribe);
        SimpleNameReferenceNode responseNameNode = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)(responseType + ",error?")));
        SimpleNameReferenceNode streamMessageNode = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"streamMessages"));
        StreamTypeParamsNode streamTypeParamsNode = NodeFactory.createStreamTypeParamsNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.LT_TOKEN), (Node)responseNameNode, null, null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.GT_TOKEN));
        StreamTypeDescriptorNode streamTypeDescriptorNode = NodeFactory.createStreamTypeDescriptorNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.STREAM_KEYWORD), (Node)streamTypeParamsNode);
        VariableDeclarationNode streamMessages = NodeFactory.createVariableDeclarationNode((NodeList)AbstractNodeFactory.createEmptyNodeList(), null, (TypedBindingPatternNode)NodeFactory.createTypedBindingPatternNode((TypeDescriptorNode)streamTypeDescriptorNode, (BindingPatternNode)NodeFactory.createFieldBindingPatternVarnameNode((SimpleNameReferenceNode)streamMessageNode)), null, null, (Token)semicolonToken);
        statementsList.add((StatementNode)streamMessages);
        ArrayList<Object> streamStatementList = new ArrayList<Object>();
        String streamGenName = GeneratorUtils.getStreamGeneratorName(responseType);
        ArrayList<Object> streamGeneratorArguments = new ArrayList<Object>();
        streamGeneratorArguments.add(NodeFactory.createPositionalArgumentNode((ExpressionNode)NodeParser.parseExpression((String)"self.pipes")));
        streamGeneratorArguments.add(AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
        streamGeneratorArguments.add(NodeFactory.createPositionalArgumentNode((ExpressionNode)NodeParser.parseExpression((String)pipeId)));
        streamGeneratorArguments.add(AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
        streamGeneratorArguments.add(NodeFactory.createPositionalArgumentNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"timeout"))));
        ImplicitNewExpressionNode newExpressionNode = NodeFactory.createImplicitNewExpressionNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.NEW_KEYWORD), (ParenthesizedArgList)NodeFactory.createParenthesizedArgList((Token)openParenToken, (SeparatedNodeList)AbstractNodeFactory.createSeparatedNodeList(streamGeneratorArguments), (Token)closeParenToken));
        SimpleNameReferenceNode streamGeneratorNode = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"streamGenerator"));
        VariableDeclarationNode streamGenerator = NodeFactory.createVariableDeclarationNode((NodeList)AbstractNodeFactory.createEmptyNodeList(), null, (TypedBindingPatternNode)NodeFactory.createTypedBindingPatternNode((TypeDescriptorNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)(streamGenName + "StreamGenerator"))), (BindingPatternNode)NodeFactory.createFieldBindingPatternVarnameNode((SimpleNameReferenceNode)streamGeneratorNode)), (Token)equalToken, (ExpressionNode)newExpressionNode, (Token)semicolonToken);
        streamStatementList.add(streamGenerator);
        MethodCallExpressionNode streamGeneratorMethodCallNode = NodeFactory.createMethodCallExpressionNode((ExpressionNode)NodeFactory.createFieldAccessExpressionNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"self")), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.DOT_TOKEN), (NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"streamGenerators"))), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.DOT_TOKEN), (NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"addStreamGenerator")), (Token)openParenToken, (SeparatedNodeList)AbstractNodeFactory.createSeparatedNodeList((Node[])new Node[]{streamGeneratorNode}), (Token)closeParenToken);
        ExpressionStatementNode streamGeneratorExpressionNode = NodeFactory.createExpressionStatementNode(null, (ExpressionNode)streamGeneratorMethodCallNode, (Token)semicolonToken);
        streamStatementList.add(streamGeneratorExpressionNode);
        AssignmentStatementNode streamMessagesAssignmentStatementNode = NodeFactory.createAssignmentStatementNode((Node)streamMessageNode, (Token)equalToken, (ExpressionNode)NodeFactory.createImplicitNewExpressionNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.NEW_KEYWORD), (ParenthesizedArgList)NodeFactory.createParenthesizedArgList((Token)openParenToken, (SeparatedNodeList)AbstractNodeFactory.createSeparatedNodeList((Node[])new Node[]{NodeFactory.createPositionalArgumentNode((ExpressionNode)streamGeneratorNode)}), (Token)closeParenToken)), (Token)semicolonToken);
        streamStatementList.add(streamMessagesAssignmentStatementNode);
        LockStatementNode streamLockStatementNode = NodeFactory.createLockStatementNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.LOCK_KEYWORD), (BlockStatementNode)NodeFactory.createBlockStatementNode((Token)openBraceToken, (NodeList)AbstractNodeFactory.createNodeList(streamStatementList), (Token)closeBraceToken), null);
        statementsList.add((StatementNode)streamLockStatementNode);
        ReturnStatementNode returnStatementNode = NodeFactory.createReturnStatementNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RETURN_KEYWORD), (ExpressionNode)streamMessageNode, (Token)semicolonToken);
        statementsList.add((StatementNode)returnStatementNode);
    }

    private LockStatementNode getConnectionActiveCheck() {
        NodeList ifIsActiveNode = AbstractNodeFactory.createNodeList((Node[])new StatementNode[]{NodeFactory.createIfElseStatementNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.IF_KEYWORD), (ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"!self.isActive")), (BlockStatementNode)NodeFactory.createBlockStatementNode((Token)openBraceToken, (NodeList)AbstractNodeFactory.createNodeList((Node[])new StatementNode[]{NodeFactory.createReturnStatementNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RETURN_KEYWORD), (ExpressionNode)NodeFactory.createErrorConstructorExpressionNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ERROR_KEYWORD), null, (Token)openParenToken, (SeparatedNodeList)AbstractNodeFactory.createSeparatedNodeList((Node[])new Node[]{AbstractNodeFactory.createIdentifierToken((String)"\"ConnectionError: Connection has been closed\"")}), (Token)closeParenToken), (Token)semicolonToken)}), (Token)closeBraceToken), null)});
        return NodeFactory.createLockStatementNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.LOCK_KEYWORD), (BlockStatementNode)NodeFactory.createBlockStatementNode((Token)openBraceToken, (NodeList)ifIsActiveNode, (Token)closeBraceToken), null);
    }

    private void createNoResponseFunctionBodyStatement(List<StatementNode> statementsList, String requestType) {
        TypeDescriptorNode messageTypeNode = NodeParser.parseTypeDescriptor((String)"Message|error");
        SimpleNameReferenceNode messageVarNode = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"message"));
        SimpleNameReferenceNode requestTypePipeNode = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)requestType));
        statementsList.add((StatementNode)this.getConnectionActiveCheck());
        MethodCallExpressionNode cloneWithTypeNode = NodeFactory.createMethodCallExpressionNode((ExpressionNode)requestTypePipeNode, (Token)dotToken, (NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"cloneWithType")), (Token)openParenToken, (SeparatedNodeList)AbstractNodeFactory.createSeparatedNodeList((Node[])new Node[0]), (Token)closeParenToken);
        VariableDeclarationNode responseTypeCloneStatement = NodeFactory.createVariableDeclarationNode((NodeList)AbstractNodeFactory.createEmptyNodeList(), null, (TypedBindingPatternNode)NodeFactory.createTypedBindingPatternNode((TypeDescriptorNode)messageTypeNode, (BindingPatternNode)NodeFactory.createFieldBindingPatternVarnameNode((SimpleNameReferenceNode)messageVarNode)), (Token)equalToken, (ExpressionNode)cloneWithTypeNode, (Token)semicolonToken);
        statementsList.add((StatementNode)responseTypeCloneStatement);
        statementsList.add(this.getCloningMessageError("message"));
        statementsList.addAll(this.getProduceToWriteMessageQueueVar());
    }

    private void createSimpleRPCFunctionBodyStatements(List<StatementNode> statementsList, String requestType, String responseType, String dispatcherStreamId, boolean isSubscribe) {
        Object responseTypeCamelCaseName;
        if (responseType.contains("|")) {
            responseTypeCamelCaseName = "unionResult";
        } else {
            char responseTypeFirstChar = Character.toLowerCase(responseType.charAt(0));
            String responseRemainingString = responseType.substring(1);
            responseTypeCamelCaseName = responseTypeFirstChar + responseRemainingString;
        }
        Object pipeId = String.format("\"%s\"", requestType);
        if (!isSubscribe) {
            statementsList.add((StatementNode)this.getConnectionActiveCheck());
        }
        if (!Objects.isNull(dispatcherStreamId)) {
            pipeId = requestType + "." + GeneratorUtils.escapeIdentifier(dispatcherStreamId);
        }
        this.addProduceStatementForWriteMessageQueue(statementsList, requestType, isSubscribe);
        TypeDescriptorNode responseTypeName = NodeParser.parseTypeDescriptor((String)(responseType + "|error"));
        TypeDescriptorNode consumeResponseType = NodeParser.parseTypeDescriptor((String)("Message|" + String.valueOf(GeneratorConstants.PIPE_ERROR_NODE)));
        SimpleNameReferenceNode responseMessageVarNode = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"responseMessage"));
        SimpleNameReferenceNode responseNameNode = !requestType.equals("error") ? NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)responseTypeCamelCaseName)) : NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)((String)responseTypeCamelCaseName + "Message")));
        VariableDeclarationNode callRelevantPipeConsumeVar = NodeFactory.createVariableDeclarationNode((NodeList)AbstractNodeFactory.createEmptyNodeList(), null, (TypedBindingPatternNode)NodeFactory.createTypedBindingPatternNode((TypeDescriptorNode)consumeResponseType, (BindingPatternNode)NodeFactory.createFieldBindingPatternVarnameNode((SimpleNameReferenceNode)responseMessageVarNode)), (Token)equalToken, (ExpressionNode)NodeParser.parseExpression((String)(String.format("self.pipes.getPipe(%s)", pipeId) + ".consume" + String.format("(%s)", "timeout"))), (Token)semicolonToken);
        statementsList.add((StatementNode)callRelevantPipeConsumeVar);
        statementsList.add(this.getPipeError("responseMessage", "consuming"));
        if (!Objects.isNull(dispatcherStreamId)) {
            String pipeCloseErr = "pipeCloseError";
            statementsList.add(NodeParser.parseStatement((String)String.format("error? %s = self.pipes.removePipe(%s);", pipeCloseErr, pipeId)));
            statementsList.add((StatementNode)NodeFactory.createIfElseStatementNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.IF_KEYWORD), (ExpressionNode)NodeParser.parseExpression((String)(pipeCloseErr + " is error")), (BlockStatementNode)NodeFactory.createBlockStatementNode((Token)openBraceToken, (NodeList)AbstractNodeFactory.createNodeList((Node[])new StatementNode[]{NodeParser.parseStatement((String)String.format("log:printDebug(\"%s: %s\", %s);", "PipeError", "Error in closing pipe.", pipeCloseErr))}), (Token)closeBraceToken), null));
        }
        MethodCallExpressionNode cloneWithTypeMethodCallExpressionNode = NodeFactory.createMethodCallExpressionNode((ExpressionNode)responseMessageVarNode, (Token)dotToken, (NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"cloneWithType")), (Token)openParenToken, (SeparatedNodeList)AbstractNodeFactory.createSeparatedNodeList((Node[])new Node[0]), (Token)closeParenToken);
        VariableDeclarationNode responseTypeCloneStatement = NodeFactory.createVariableDeclarationNode((NodeList)AbstractNodeFactory.createEmptyNodeList(), null, (TypedBindingPatternNode)NodeFactory.createTypedBindingPatternNode((TypeDescriptorNode)responseTypeName, (BindingPatternNode)NodeFactory.createFieldBindingPatternVarnameNode((SimpleNameReferenceNode)responseNameNode)), (Token)equalToken, (ExpressionNode)cloneWithTypeMethodCallExpressionNode, (Token)semicolonToken);
        statementsList.add((StatementNode)responseTypeCloneStatement);
        statementsList.add(this.getCloningMessageError((String)responseTypeCamelCaseName));
        ReturnStatementNode returnStatementNode = NodeFactory.createReturnStatementNode((Token)AbstractNodeFactory.createIdentifierToken((String)"return"), (ExpressionNode)responseNameNode, (Token)semicolonToken);
        statementsList.add((StatementNode)returnStatementNode);
    }

    private static StatementNode getStatementToGenerateUuid(String requestType, String dispatcherStreamId) {
        return NodeParser.parseStatement((String)String.format("%s.%s = uuid:createType1AsString();", requestType, GeneratorUtils.escapeIdentifier(dispatcherStreamId)));
    }
}

