/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.websocketscore.generators.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.apicurio.datamodels.models.asyncapi.AsyncApiMessage;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25DocumentImpl;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25SchemaImpl;
import io.ballerina.asyncapi.websocketscore.GeneratorUtils;
import io.ballerina.asyncapi.websocketscore.exception.BallerinaAsyncApiExceptionWs;
import io.ballerina.asyncapi.websocketscore.generators.client.CommonFunctionUtils;
import java.util.ArrayList;
import java.util.Map;

public class RemoteFunctionReturnTypeGenerator {
    private AsyncApi25DocumentImpl asyncAPI;

    public RemoteFunctionReturnTypeGenerator(AsyncApi25DocumentImpl asyncAPI) {
        this.asyncAPI = asyncAPI;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getReturnType(JsonNode xResponse, JsonNode xResponseType, ArrayList<String> responseMessages) throws BallerinaAsyncApiExceptionWs {
        ArrayList<String> returnTypes = new ArrayList<String>();
        Map<String, AsyncApiMessage> messages = this.asyncAPI.getComponents().getMessages();
        if (xResponse.get("oneOf") != null) {
            if (xResponse.get("oneOf") instanceof ArrayNode) {
                ArrayNode test = (ArrayNode)xResponse.get("oneOf");
                if (xResponseType == null) throw new BallerinaAsyncApiExceptionWs("x-response-type must be included ex:- x-response-type: streaming || x-response-type: simple-rpc");
                for (JsonNode jsonNode : test) {
                    if (jsonNode.get("$ref") != null) {
                        this.handleReferenceReturn(jsonNode, messages, responseMessages, returnTypes);
                        continue;
                    }
                    if (jsonNode.get("payload") == null) continue;
                    throw new BallerinaAsyncApiExceptionWs("Ballerina service file cannot be generate to the given AsyncAPI specification, Response type must be a Record");
                }
            }
        } else {
            if (xResponse.get("payload") != null && xResponse.get("payload").get("type") != new TextNode("object")) {
                throw new BallerinaAsyncApiExceptionWs("Ballerina service file cannot be generate to the given AsyncAPI specification, Response type must be a Record");
            }
            if (xResponse.get("$ref") != null) {
                this.handleReferenceReturn(xResponse, messages, responseMessages, returnTypes);
            }
        }
        if (returnTypes.isEmpty()) return "null";
        return String.join((CharSequence)"|", returnTypes);
    }

    private void handleReferenceReturn(JsonNode jsonNode, Map<String, AsyncApiMessage> messages, ArrayList<String> responseMessages, ArrayList<String> returnTypes) throws BallerinaAsyncApiExceptionWs {
        CommonFunctionUtils commonFunctionUtils;
        TextNode textNode = (TextNode)this.asyncAPI.getExtensions().get("x-dispatcherKey");
        String dispatcherKey = textNode.asText();
        String reference = jsonNode.get("$ref").asText();
        String messageName = GeneratorUtils.extractReferenceType(reference);
        AsyncApiMessage message = messages.get(messageName);
        TextNode schemaReference = (TextNode)message.getPayload().get("$ref");
        String schemaName = GeneratorUtils.extractReferenceType(schemaReference.asText());
        AsyncApi25SchemaImpl refSchema = (AsyncApi25SchemaImpl)this.asyncAPI.getComponents().getSchemas().get(schemaName);
        if (responseMessages != null) {
            responseMessages.add(schemaName);
        }
        if (!(commonFunctionUtils = new CommonFunctionUtils(this.asyncAPI)).isDispatcherPresent(schemaName, refSchema, dispatcherKey, true)) {
            throw new BallerinaAsyncApiExceptionWs(String.format("dispatcherKey must be inside %s schema properties", schemaName));
        }
        String type = GeneratorUtils.getValidName(schemaName, true);
        returnTypes.add(type);
    }
}

