/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.websocketscore.generators.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25DocumentImpl;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25SchemaImpl;
import io.ballerina.asyncapi.websocketscore.GeneratorUtils;
import io.ballerina.asyncapi.websocketscore.exception.BallerinaAsyncApiExceptionWs;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.Constants;
import io.ballerina.asyncapi.websocketscore.generators.client.CommonFunctionUtils;
import io.ballerina.asyncapi.websocketscore.generators.document.DocCommentsGenerator;
import io.ballerina.asyncapi.websocketscore.generators.schema.BallerinaTypesGenerator;
import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.BuiltinSimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.MarkdownParameterDocumentationLineNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RemoteFunctionSignatureGenerator {
    private final AsyncApi25DocumentImpl asyncAPI;
    private final List<TypeDefinitionNode> typeDefinitionNodeList;
    private final BallerinaTypesGenerator ballerinaSchemaGenerator;

    public RemoteFunctionSignatureGenerator(AsyncApi25DocumentImpl asyncAPI, BallerinaTypesGenerator ballerinaSchemaGenerator, List<TypeDefinitionNode> typeDefinitionNodeList) {
        this.asyncAPI = asyncAPI;
        this.ballerinaSchemaGenerator = ballerinaSchemaGenerator;
        this.typeDefinitionNodeList = typeDefinitionNodeList;
    }

    public List<TypeDefinitionNode> getTypeDefinitionNodeList() {
        return this.typeDefinitionNodeList;
    }

    public FunctionSignatureNode getFunctionSignatureNode(JsonNode payload, List<Node> remoteFunctionDoc, Map<String, JsonNode> extensions, String returnType, List<String> streamReturns) throws BallerinaAsyncApiExceptionWs {
        ReturnTypeDescriptorNode returnTypeDescriptorNode;
        ArrayList<Object> parameterList = new ArrayList<Object>();
        if (payload != null) {
            String parameterType = this.getDataType(payload);
            Node requestTypeParamNode = this.getRequestTypeParameterNode(parameterType);
            parameterList.add(requestTypeParamNode);
            parameterList.add(AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
            TextNode descriptionNode = (TextNode)payload.get("description");
            if (descriptionNode != null) {
                MarkdownParameterDocumentationLineNode paramDoc = DocCommentsGenerator.createAPIParamDoc(GeneratorUtils.getValidName(parameterType, false), descriptionNode.asText());
                MarkdownParameterDocumentationLineNode timeoutDoc = DocCommentsGenerator.createAPIParamDoc("timeout", "waiting period to keep the event in the buffer in seconds");
                remoteFunctionDoc.add((Node)paramDoc);
                remoteFunctionDoc.add((Node)timeoutDoc);
            }
        }
        parameterList.add(this.getTimeOutParameterNode());
        SeparatedNodeList parameters = AbstractNodeFactory.createSeparatedNodeList(parameterList);
        if (extensions != null) {
            JsonNode xResponse = extensions.get("x-response");
            JsonNode xResponseType = extensions.get("x-response-type");
            if (Constants.SERVER_STREAMING_TYPE_NODE.equals((Object)xResponseType)) {
                if (!streamReturns.contains(returnType)) {
                    streamReturns.add((String)returnType);
                }
                returnType = "stream<" + (String)returnType + ",error?>";
            }
            String finalReturnType = (String)returnType + SyntaxKind.PIPE_TOKEN.stringValue() + "error";
            TextNode responseDescription = (TextNode)xResponse.get("description");
            if (xResponse.get("description") != null) {
                MarkdownParameterDocumentationLineNode returnDoc = DocCommentsGenerator.createAPIParamDoc("return", responseDescription.asText());
                remoteFunctionDoc.add((Node)returnDoc);
            }
            returnTypeDescriptorNode = NodeFactory.createReturnTypeDescriptorNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RETURNS_KEYWORD), (NodeList)AbstractNodeFactory.createEmptyNodeList(), (Node)NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)AbstractNodeFactory.createIdentifierToken((String)finalReturnType)));
        } else {
            returnTypeDescriptorNode = NodeFactory.createReturnTypeDescriptorNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RETURNS_KEYWORD), (NodeList)AbstractNodeFactory.createEmptyNodeList(), (Node)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"error?")));
        }
        return NodeFactory.createFunctionSignatureNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN), (SeparatedNodeList)parameters, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN), (ReturnTypeDescriptorNode)returnTypeDescriptorNode);
    }

    private Node getTimeOutParameterNode() {
        BuiltinSimpleNameReferenceNode typeName = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)AbstractNodeFactory.createIdentifierToken((String)"decimal"));
        IdentifierToken paramNameNode = AbstractNodeFactory.createIdentifierToken((String)"timeout");
        return NodeFactory.createRequiredParameterNode((NodeList)AbstractNodeFactory.createNodeList((Node[])new AnnotationNode[0]), (Node)typeName, (Token)paramNameNode);
    }

    public String getDataType(JsonNode payload) throws BallerinaAsyncApiExceptionWs {
        String type = "";
        if (payload.get("$ref") != null) {
            TextNode textNode;
            String dispatcherKey;
            AsyncApi25SchemaImpl componentSchema;
            CommonFunctionUtils commonFunctionUtils = new CommonFunctionUtils(this.asyncAPI);
            type = GeneratorUtils.extractReferenceType(payload.get("$ref").textValue());
            if (!commonFunctionUtils.isDispatcherPresent(type, componentSchema = (AsyncApi25SchemaImpl)this.asyncAPI.getComponents().getSchemas().get(type).asSchema(), dispatcherKey = (textNode = (TextNode)this.asyncAPI.getExtensions().get("x-dispatcherKey")).asText(), true)) {
                throw new BallerinaAsyncApiExceptionWs(String.format("dispatcherKey must be inside %s schema properties", type));
            }
            if (!GeneratorUtils.isValidSchemaName(type)) {
                ArrayList<Node> responseDocs = new ArrayList<Node>();
                if (payload.get("description") != null) {
                    responseDocs.addAll(DocCommentsGenerator.createAPIDescriptionDoc(payload.get("description").asText(), false));
                }
                TypeDefinitionNode typeDefinitionNode = this.ballerinaSchemaGenerator.getTypeDefinitionNode(componentSchema, type, responseDocs);
                GeneratorUtils.updateTypeDefNodeList(type, typeDefinitionNode, this.typeDefinitionNodeList);
            }
        }
        return type;
    }

    public Node getRequestTypeParameterNode(String paramType) {
        BuiltinSimpleNameReferenceNode typeName = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)AbstractNodeFactory.createIdentifierToken((String)GeneratorUtils.getValidName(paramType, true)));
        IdentifierToken paramName = AbstractNodeFactory.createIdentifierToken((String)GeneratorUtils.getValidName(paramType, false));
        return NodeFactory.createRequiredParameterNode((NodeList)AbstractNodeFactory.createNodeList(new ArrayList()), (Node)typeName, (Token)paramName);
    }
}

