/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.websocketscore.generators.schema;

import io.apicurio.datamodels.models.Schema;
import io.apicurio.datamodels.models.asyncapi.AsyncApiSchema;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25ComponentsImpl;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25DocumentImpl;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25SchemaImpl;
import io.ballerina.asyncapi.websocketscore.GeneratorUtils;
import io.ballerina.asyncapi.websocketscore.exception.BallerinaAsyncApiExceptionWs;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.service.AsyncApiRemoteMapper;
import io.ballerina.asyncapi.websocketscore.generators.schema.TypeGeneratorUtils;
import io.ballerina.asyncapi.websocketscore.generators.schema.ballerinatypegenerators.AllOfRecordTypeGenerator;
import io.ballerina.asyncapi.websocketscore.generators.schema.ballerinatypegenerators.ArrayTypeGenerator;
import io.ballerina.asyncapi.websocketscore.generators.schema.ballerinatypegenerators.RecordTypeGenerator;
import io.ballerina.asyncapi.websocketscore.generators.schema.ballerinatypegenerators.TypeGenerator;
import io.ballerina.asyncapi.websocketscore.generators.schema.ballerinatypegenerators.UnionTypeGenerator;
import io.ballerina.asyncapi.websocketscore.generators.schema.model.GeneratorMetaData;
import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.compiler.syntax.tree.RecordTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BallerinaTypesGenerator {
    private final List<TypeDefinitionNode> typeDefinitionNodeList;
    private final Set<String> imports = new LinkedHashSet<String>();
    private boolean hasConstraints;

    public BallerinaTypesGenerator(AsyncApi25DocumentImpl asyncAPI, List<TypeDefinitionNode> typeDefinitionNodeList) {
        GeneratorMetaData.createInstance(asyncAPI);
        this.typeDefinitionNodeList = typeDefinitionNodeList;
        this.hasConstraints = false;
    }

    public BallerinaTypesGenerator(AsyncApi25DocumentImpl asyncAPI) {
        this(asyncAPI, new LinkedList<TypeDefinitionNode>());
    }

    public TypeDefinitionNode getTypeDefinitionNode(AsyncApi25SchemaImpl schema, String typeName, List<Node> schemaDocs) throws BallerinaAsyncApiExceptionWs {
        IdentifierToken typeNameToken = AbstractNodeFactory.createIdentifierToken((String)GeneratorUtils.getValidName(typeName.trim(), true));
        TypeGenerator typeGenerator = TypeGeneratorUtils.getTypeGenerator(schema, GeneratorUtils.getValidName(typeName.trim(), true), null);
        ArrayList<AnnotationNode> typeAnnotations = new ArrayList<AnnotationNode>();
        AnnotationNode constraintNode = TypeGeneratorUtils.generateConstraintNode(typeName, schema);
        if (constraintNode != null) {
            typeAnnotations.add(constraintNode);
        }
        TypeGeneratorUtils.getRecordDocs(schemaDocs, schema);
        TypeDefinitionNode typeDefinitionNode = typeGenerator.generateTypeDefinitionNode(typeNameToken, schemaDocs, typeAnnotations);
        if (typeGenerator instanceof ArrayTypeGenerator && !typeGenerator.getTypeDefinitionNodeList().isEmpty()) {
            this.typeDefinitionNodeList.addAll(typeGenerator.getTypeDefinitionNodeList());
        } else if (typeGenerator instanceof RecordTypeGenerator && !typeGenerator.getTypeDefinitionNodeList().isEmpty()) {
            this.removeDuplicateNode(typeGenerator.getTypeDefinitionNodeList());
        } else if (typeGenerator instanceof AllOfRecordTypeGenerator && !typeGenerator.getTypeDefinitionNodeList().isEmpty()) {
            this.removeDuplicateNode(typeGenerator.getTypeDefinitionNodeList());
        } else if (typeGenerator instanceof UnionTypeGenerator && !typeGenerator.getTypeDefinitionNodeList().isEmpty()) {
            this.removeDuplicateNode(typeGenerator.getTypeDefinitionNodeList());
        }
        this.imports.addAll(typeGenerator.getImports());
        return typeDefinitionNode;
    }

    private void removeDuplicateNode(List<TypeDefinitionNode> newConstraintNode) {
        for (TypeDefinitionNode newNode : newConstraintNode) {
            boolean isExist = false;
            for (TypeDefinitionNode oldNode : this.typeDefinitionNodeList) {
                if (!newNode.typeName().text().equals(oldNode.typeName().text())) continue;
                isExist = true;
                break;
            }
            if (isExist) continue;
            this.typeDefinitionNodeList.add(newNode);
        }
    }

    public SyntaxTree generateSyntaxTree() throws BallerinaAsyncApiExceptionWs {
        AsyncApi25ComponentsImpl components;
        Map<String, Schema> schemas;
        AsyncApi25DocumentImpl asyncAPI = GeneratorMetaData.getInstance().getAsyncAPI();
        ArrayList<TypeDefinitionNode> typeDefinitionNodeListForSchema = new ArrayList<TypeDefinitionNode>();
        if (asyncAPI.getComponents() != null && (schemas = (components = (AsyncApi25ComponentsImpl)asyncAPI.getComponents()).getSchemas()) != null) {
            for (Map.Entry<String, Schema> schema : schemas.entrySet()) {
                String schemaKey = schema.getKey().trim();
                if (!this.hasConstraints) {
                    this.hasConstraints = GeneratorUtils.hasConstraints(schema.getValue());
                }
                if (AsyncApiRemoteMapper.isCloseFrameSchema((AsyncApiSchema)schema.getValue()) || !GeneratorUtils.isValidSchemaName(schemaKey)) continue;
                ArrayList<Node> schemaDoc = new ArrayList<Node>();
                typeDefinitionNodeListForSchema.add(this.getTypeDefinitionNode((AsyncApi25SchemaImpl)schema.getValue(), schemaKey, schemaDoc));
            }
        }
        NodeList<ImportDeclarationNode> imports = this.generateImportNodes();
        this.typeDefinitionNodeList.addAll(typeDefinitionNodeListForSchema);
        NodeList moduleMembers = AbstractNodeFactory.createNodeList((Node[])((ModuleMemberDeclarationNode[])this.typeDefinitionNodeList.toArray(new TypeDefinitionNode[this.typeDefinitionNodeList.size()])));
        IdentifierToken eofToken = AbstractNodeFactory.createIdentifierToken((String)"");
        ModulePartNode modulePartNode = NodeFactory.createModulePartNode(imports, (NodeList)moduleMembers, (Token)eofToken);
        TextDocument textDocument = TextDocuments.from((String)"");
        SyntaxTree syntaxTree = SyntaxTree.from((TextDocument)textDocument);
        return syntaxTree.modifyWith((Node)modulePartNode);
    }

    private NodeList<ImportDeclarationNode> generateImportNodes() {
        ArrayList<ImportDeclarationNode> importDeclarationNodes = new ArrayList<ImportDeclarationNode>();
        if (!this.typeDefinitionNodeList.isEmpty()) {
            this.importsForTypeDefinitions(importDeclarationNodes);
        }
        if (!this.imports.isEmpty()) {
            for (String importValue : this.imports) {
                ImportDeclarationNode importDeclarationNode = NodeParser.parseImportDeclaration((String)importValue);
                importDeclarationNodes.add(importDeclarationNode);
            }
        }
        if (this.imports.isEmpty()) {
            return AbstractNodeFactory.createEmptyNodeList();
        }
        return AbstractNodeFactory.createNodeList(importDeclarationNodes);
    }

    private void importsForTypeDefinitions(List<ImportDeclarationNode> imports) {
        for (TypeDefinitionNode node : this.typeDefinitionNodeList) {
            if (!(node.typeDescriptor() instanceof RecordTypeDescriptorNode) || !node.typeName().text().equals("websocket:ClientConfiguration")) continue;
            ImportDeclarationNode importForWebsocket = GeneratorUtils.getImportDeclarationNode("ballerina", "websocket");
            ImportDeclarationNode importForHttp = GeneratorUtils.getImportDeclarationNode("ballerina", "http");
            imports.add(importForWebsocket);
            imports.add(importForHttp);
        }
    }
}

