/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.cmd;

import io.ballerina.cli.BLauncherCmd;
import io.ballerina.cli.TaskExecutor;
import io.ballerina.cli.cmd.CacheArtifactsTask;
import io.ballerina.cli.cmd.CommandUtil;
import io.ballerina.cli.cmd.PackageLockingModeConverter;
import io.ballerina.cli.cmd.RestoreCachedArtifactsTask;
import io.ballerina.cli.task.CleanTargetDirTask;
import io.ballerina.cli.task.CompileTask;
import io.ballerina.cli.task.CreateExecutableTask;
import io.ballerina.cli.task.CreateFingerprintTask;
import io.ballerina.cli.task.DumpBuildTimeTask;
import io.ballerina.cli.task.ResolveMavenDependenciesTask;
import io.ballerina.cli.task.RunBuildToolsTask;
import io.ballerina.cli.utils.BuildTime;
import io.ballerina.projects.BuildOptions;
import io.ballerina.projects.DependencyGraph;
import io.ballerina.projects.DiagnosticResult;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.ProjectLoadResult;
import io.ballerina.projects.directory.BuildProject;
import io.ballerina.projects.directory.ProjectLoader;
import io.ballerina.projects.directory.WorkspaceProject;
import io.ballerina.projects.environment.PackageLockingMode;
import io.ballerina.projects.internal.model.BuildJson;
import io.ballerina.projects.util.ProjectPaths;
import io.ballerina.projects.util.ProjectUtils;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import org.wso2.ballerinalang.util.RepoUtils;
import picocli.CommandLine;

@CommandLine.Command(name="build", description={"Compile the current package"})
public class BuildCommand
implements BLauncherCmd {
    private final PrintStream outStream;
    private final PrintStream errStream;
    private final boolean exitWhenFinish;
    @CommandLine.Option(names={"--output", "-o"}, description={"Write the output to the given file. The provided output file name may or may not contain the '.jar' extension."})
    private String output;
    @CommandLine.Option(names={"--offline"}, description={"Build/Compile offline without downloading dependencies."})
    private Boolean offline;
    @CommandLine.Parameters(arity="0..1")
    private final Path projectPath;
    @CommandLine.Option(names={"--dump-bir"}, hidden=true)
    private boolean dumpBIR;
    @CommandLine.Option(names={"--dump-bir-file"}, hidden=true)
    private Boolean dumpBIRFile;
    @CommandLine.Option(names={"--dump-graph"}, description={"Print the dependency graph."}, hidden=true)
    private boolean dumpGraph;
    @CommandLine.Option(names={"--dump-raw-graphs"}, description={"Print all intermediate graphs created in the dependency resolution process."}, hidden=true)
    private boolean dumpRawGraphs;
    @CommandLine.Option(names={"--help", "-h"}, hidden=true)
    private boolean helpFlag;
    @CommandLine.Option(names={"--experimental"}, description={"Enable experimental language features."})
    private Boolean experimentalFlag;
    @CommandLine.Option(names={"--generate-config-schema"}, hidden=true)
    private Boolean configSchemaGen;
    private static final String buildCmd = "bal build [-o <output>] [--offline] [--taint-check]\n                    [<ballerina-file | package-path>]";
    @CommandLine.Option(names={"--observability-included"}, description={"package observability in the executable JAR file(s)."})
    private Boolean observabilityIncluded;
    @CommandLine.Option(names={"--cloud"}, description={"Enable cloud artifact generation"})
    private String cloud;
    @CommandLine.Option(names={"--show-dependency-diagnostics"}, description={"Show the diagnostics generated by the dependencies"})
    private Boolean showDependencyDiagnostics;
    @CommandLine.Option(names={"--remote-management"}, description={"enable service management tools in the executable JAR file(s)."})
    private Boolean remoteManagement;
    @CommandLine.Option(names={"--list-conflicted-classes"}, description={"list conflicted classes when generating executable"})
    private Boolean listConflictedClasses;
    @CommandLine.Option(names={"--dump-build-time"}, description={"calculate and dump build time"}, hidden=true)
    private Boolean dumpBuildTime;
    @CommandLine.Option(names={"--sticky"}, description={"stick to exact versions locked (if exists)"})
    private Boolean sticky;
    @CommandLine.Option(names={"--target-dir"}, description={"target directory path"})
    private Path targetDir;
    @CommandLine.Option(names={"--export-openapi"}, description={"generate openAPI contract files for all the services in the current package"})
    private Boolean exportOpenAPI;
    @CommandLine.Option(names={"--export-component-model"}, description={"generate a model to represent interactions between the package components (i.e. service/type definitions) and, export it in JSON format"}, hidden=true)
    private Boolean exportComponentModel;
    @CommandLine.Option(names={"--graalvm"}, description={"enable native image generation"})
    private Boolean nativeImage;
    @CommandLine.Option(names={"--disable-syntax-tree-caching"}, hidden=true, description={"disable syntax tree caching for source files"}, defaultValue="false")
    private Boolean disableSyntaxTreeCaching;
    @CommandLine.Option(names={"--graalvm-build-options"}, description={"additional build options for native image generation"})
    private String graalVMBuildOptions;
    @CommandLine.Option(names={"--optimize-dependency-compilation"}, hidden=true, description={"experimental memory optimization for large projects"})
    private Boolean optimizeDependencyCompilation;
    @CommandLine.Option(names={"--locking-mode"}, hidden=true, description={"allow passing the package locking mode."}, converter={PackageLockingModeConverter.class})
    private PackageLockingMode lockingMode;

    public BuildCommand() {
        this.projectPath = Path.of(System.getProperty("user.dir"), new String[0]);
        this.outStream = System.out;
        this.errStream = System.err;
        this.exitWhenFinish = true;
    }

    BuildCommand(Path projectPath, PrintStream outStream, PrintStream errStream, boolean exitWhenFinish) {
        this.projectPath = projectPath;
        this.outStream = outStream;
        this.errStream = errStream;
        this.exitWhenFinish = exitWhenFinish;
        this.offline = true;
    }

    BuildCommand(Path projectPath, PrintStream outStream, PrintStream errStream, boolean exitWhenFinish, Boolean optimizeDependencyCompilation) {
        this.projectPath = projectPath;
        this.outStream = outStream;
        this.errStream = errStream;
        this.exitWhenFinish = exitWhenFinish;
        this.optimizeDependencyCompilation = optimizeDependencyCompilation;
        this.offline = true;
    }

    BuildCommand(Path projectPath, PrintStream outStream, PrintStream errStream, boolean exitWhenFinish, boolean dumpBuildTime) {
        this.projectPath = projectPath;
        this.outStream = outStream;
        this.errStream = errStream;
        this.exitWhenFinish = exitWhenFinish;
        this.dumpBuildTime = dumpBuildTime;
        this.offline = true;
    }

    BuildCommand(Path projectPath, PrintStream outStream, PrintStream errStream, boolean exitWhenFinish, String output) {
        this.projectPath = projectPath;
        this.outStream = outStream;
        this.errStream = errStream;
        this.exitWhenFinish = exitWhenFinish;
        this.output = output;
        this.offline = true;
    }

    BuildCommand(Path projectPath, PrintStream outStream, PrintStream errStream, boolean exitWhenFinish, Path targetDir) {
        this.projectPath = projectPath;
        this.outStream = outStream;
        this.errStream = errStream;
        this.exitWhenFinish = exitWhenFinish;
        this.targetDir = targetDir;
        this.offline = true;
    }

    BuildCommand(Path projectPath, PrintStream outStream, PrintStream errStream, boolean exitWhenFinish, boolean dumpBuildTime, boolean nativeImage, String graalVMBuildOptions) {
        this.projectPath = projectPath;
        this.outStream = outStream;
        this.errStream = errStream;
        this.exitWhenFinish = exitWhenFinish;
        this.dumpBuildTime = dumpBuildTime;
        this.offline = true;
        this.nativeImage = nativeImage;
        this.graalVMBuildOptions = graalVMBuildOptions;
    }

    @Override
    public void execute() {
        Project project;
        DiagnosticResult wpDiagnosticResult;
        long start = 0L;
        int exitCode = 0;
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo("build");
            this.errStream.println(commandUsageInfo);
            return;
        }
        BuildOptions buildOptions = this.constructBuildOptions();
        Path absProjectPath = this.projectPath.toAbsolutePath().normalize();
        try {
            if (buildOptions.dumpBuildTime()) {
                BuildTime.getInstance().timestamp = start = System.currentTimeMillis();
            }
            if (!(ProjectPaths.isBuildProjectRoot((Path)this.projectPath) || ProjectPaths.isStandaloneBalFile((Path)this.projectPath) || ProjectPaths.isWorkspaceProjectRoot((Path)this.projectPath))) {
                throw new ProjectException("invalid source provided: " + String.valueOf(absProjectPath) + ". Please provide a valid Ballerina package, workspace or a standalone file.");
            }
            ProjectLoadResult loadResult = ProjectLoader.load((Path)this.projectPath, (BuildOptions)buildOptions);
            wpDiagnosticResult = loadResult.diagnostics();
            if (wpDiagnosticResult.hasErrors()) {
                exitCode = 1;
            }
            project = loadResult.project();
            if (buildOptions.dumpBuildTime()) {
                BuildTime.getInstance().projectLoadDuration = System.currentTimeMillis() - start;
            }
        }
        catch (ProjectException e) {
            CommandUtil.printError(this.errStream, e.getMessage(), null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (!project.kind().equals((Object)ProjectKind.SINGLE_FILE_PROJECT) && this.output != null) {
            CommandUtil.printError(this.errStream, "'-o' and '--output' are only supported when building a single Ballerina file.", "bal build -o <output-file> <ballerina-file> ", true);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        RepoUtils.readSettings();
        if (!project.buildOptions().nativeImage() && !project.buildOptions().graalVMBuildOptions().isEmpty()) {
            this.outStream.println("WARNING: Additional GraalVM build options are ignored since graalvm flag is not set");
        }
        if (project.kind() == ProjectKind.WORKSPACE_PROJECT) {
            wpDiagnosticResult.diagnostics().forEach(diagnostic -> this.errStream.println(diagnostic.toString()));
            WorkspaceProject workspaceProject = (WorkspaceProject)project;
            DependencyGraph<BuildProject> projectDependencyGraph = CommandUtil.resolveWorkspaceDependencies(workspaceProject, this.outStream);
            ArrayList<BuildProject> topologicallySortedList = new ArrayList<BuildProject>(projectDependencyGraph.toTopologicallySortedList());
            if (!workspaceProject.sourceRoot().equals(absProjectPath)) {
                Optional<BuildProject> buildProjectOptional = projectDependencyGraph.getNodes().stream().filter(node -> node.sourceRoot().equals(absProjectPath)).findFirst();
                Collection projectDependencies = projectDependencyGraph.getAllDependencies((Object)buildProjectOptional.orElseThrow());
                topologicallySortedList.removeIf(prj -> !projectDependencies.contains(prj) && prj != buildProjectOptional.get());
            }
            HashMap<BuildProject, Boolean> rebuildCache = new HashMap<BuildProject, Boolean>();
            for (BuildProject buildProject : topologicallySortedList) {
                boolean skipExecutable = false;
                if (workspaceProject.sourceRoot().equals(absProjectPath)) {
                    if (this.hasDependents(buildProject, projectDependencyGraph)) {
                        skipExecutable = true;
                    }
                } else if (!buildProject.sourceRoot().equals(absProjectPath) && this.hasDependents(buildProject, projectDependencyGraph)) {
                    skipExecutable = true;
                }
                boolean isRebuildNeeded = this.isRebuildNeeded((Project)buildProject, skipExecutable);
                rebuildCache.put(buildProject, isRebuildNeeded);
                if (!isRebuildNeeded) {
                    for (BuildProject dependency : projectDependencyGraph.getDirectDependencies((Object)buildProject)) {
                        isRebuildNeeded = (Boolean)rebuildCache.get(dependency);
                        if (!isRebuildNeeded) continue;
                        rebuildCache.put(buildProject, true);
                        break;
                    }
                }
                this.executeTasks(false, (Project)buildProject, skipExecutable, isRebuildNeeded);
            }
        } else {
            this.executeTasks(project.kind().equals((Object)ProjectKind.SINGLE_FILE_PROJECT), project, false, this.isRebuildNeeded(project, false));
        }
        if (this.exitWhenFinish) {
            Runtime.getRuntime().exit(exitCode);
        }
    }

    private boolean hasDependents(BuildProject buildProject, DependencyGraph<BuildProject> projectDependencyGraph) {
        return !projectDependencyGraph.getDirectDependents((Object)buildProject).isEmpty();
    }

    private void executeTasks(boolean isSingleFile, Project project, boolean skipExecutable, boolean rebuildNeeded) {
        BuildOptions buildOptions = project.buildOptions();
        ArrayList<Diagnostic> buildToolDiagnostics = new ArrayList<Diagnostic>();
        TaskExecutor taskExecutor = new TaskExecutor.TaskBuilder().addTask(new CleanTargetDirTask(), isSingleFile || !rebuildNeeded).addTask(new RestoreCachedArtifactsTask(), rebuildNeeded).addTask(new RunBuildToolsTask(this.outStream, !rebuildNeeded, buildToolDiagnostics), isSingleFile).addTask(new ResolveMavenDependenciesTask(this.outStream, !rebuildNeeded)).addTask(new CompileTask(this.outStream, this.errStream, false, true, !rebuildNeeded, buildToolDiagnostics)).addTask(new CreateExecutableTask(this.outStream, this.output, null, false, !rebuildNeeded, skipExecutable)).addTask(new DumpBuildTimeTask(this.outStream), !buildOptions.dumpBuildTime()).addTask(new CacheArtifactsTask("build", skipExecutable), !rebuildNeeded || isSingleFile).addTask(new CreateFingerprintTask(false, skipExecutable), !rebuildNeeded || isSingleFile).build();
        taskExecutor.executeTasks(project);
    }

    private boolean isRebuildNeeded(Project project, boolean skipExecutable) {
        Path buildFilePath = project.targetDir().resolve("build");
        try {
            BuildJson buildJson = ProjectUtils.readBuildJson((Path)buildFilePath);
            if (!Objects.equals(buildJson.distributionVersion(), RepoUtils.getBallerinaVersion())) {
                return true;
            }
            if (buildJson.isExpiredLastUpdateTime()) {
                return true;
            }
            if (CommandUtil.isFilesModifiedSinceLastBuild(buildJson, project, false, skipExecutable)) {
                return true;
            }
            if (this.isRebuildForCurrCmd()) {
                return true;
            }
            return CommandUtil.isPrevCurrCmdCompatible(project.buildOptions(), buildJson.getBuildOptions());
        }
        catch (IOException iOException) {
            return true;
        }
    }

    private boolean isRebuildForCurrCmd() {
        return this.dumpBIR || Boolean.TRUE.equals(this.dumpBIRFile) || this.dumpGraph || this.dumpRawGraphs || Boolean.TRUE.equals(this.configSchemaGen) || Boolean.TRUE.equals(this.showDependencyDiagnostics) || Boolean.TRUE.equals(this.listConflictedClasses) || Boolean.TRUE.equals(this.dumpBuildTime) || this.targetDir != null || Boolean.TRUE.equals(this.exportOpenAPI) || Boolean.TRUE.equals(this.exportComponentModel) || Boolean.TRUE.equals(this.nativeImage) || this.cloud != null || Boolean.TRUE.equals(this.disableSyntaxTreeCaching) || this.graalVMBuildOptions != null;
    }

    private BuildOptions constructBuildOptions() {
        BuildOptions.BuildOptionsBuilder buildOptionsBuilder = BuildOptions.builder();
        buildOptionsBuilder.setExperimental(this.experimentalFlag).setOffline(this.offline).setObservabilityIncluded(this.observabilityIncluded).setCloud(this.cloud).setRemoteManagement(this.remoteManagement).setDumpBir(Boolean.valueOf(this.dumpBIR)).setDumpBirFile(this.dumpBIRFile).setDumpGraph(Boolean.valueOf(this.dumpGraph)).setDumpRawGraphs(Boolean.valueOf(this.dumpRawGraphs)).setListConflictedClasses(this.listConflictedClasses).setDumpBuildTime(this.dumpBuildTime).setSticky(this.sticky).setConfigSchemaGen(this.configSchemaGen).setExportOpenAPI(this.exportOpenAPI).setExportComponentModel(this.exportComponentModel).setNativeImage(this.nativeImage).disableSyntaxTreeCaching(this.disableSyntaxTreeCaching).setGraalVMBuildOptions(this.graalVMBuildOptions).setShowDependencyDiagnostics(this.showDependencyDiagnostics).setOptimizeDependencyCompilation(this.optimizeDependencyCompilation).setLockingMode(this.lockingMode);
        if (this.targetDir != null) {
            buildOptionsBuilder.targetDir(this.targetDir.toString());
        }
        return buildOptionsBuilder.setConfigSchemaGen(this.configSchemaGen).build();
    }

    @Override
    public String getName() {
        return "build";
    }

    @Override
    public void printLongDesc(StringBuilder out) {
        out.append(BLauncherCmd.getCommandUsageInfo("build"));
    }

    @Override
    public void printUsage(StringBuilder out) {
        out.append("  bal build [-o <output>] [--offline] \\n\" +\n            \"                    [<ballerina-file | package-path>]");
    }

    @Override
    public void setParentCmdParser(CommandLine parentCmdParser) {
    }
}

