/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.cmd;

import io.ballerina.cli.task.Task;
import io.ballerina.projects.Project;
import io.ballerina.projects.internal.model.Target;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Stream;

public class CacheArtifactsTask
implements Task {
    private final String currTask;
    private boolean skipExecutable = false;

    public CacheArtifactsTask(String currTask) {
        this.currTask = currTask;
    }

    public CacheArtifactsTask(String currTask, boolean skipExecutable) {
        this.currTask = currTask;
        this.skipExecutable = skipExecutable;
    }

    @Override
    public void execute(Project project) {
        block11: {
            try {
                List<Path> testArtifactsPaths;
                Path targetDir = project.targetDir();
                Path backupDir = project.targetDir().resolve("backup");
                Target target = new Target(targetDir);
                if ((this.currTask.equals("build") || this.currTask.equals("run")) && !this.skipExecutable) {
                    CacheArtifactsTask.copyFile(target.getExecutablePath(project.currentPackage()), targetDir, backupDir);
                    break block11;
                }
                if (!this.currTask.equals("test")) break block11;
                Path testSuitePath = target.getTestsCachePath().resolve("test_suit.json");
                if (Files.exists(testSuitePath, new LinkOption[0])) {
                    CacheArtifactsTask.copyFile(testSuitePath, targetDir, backupDir);
                }
                String packageOrg = project.currentPackage().packageOrg().toString();
                String packageName = project.currentPackage().packageName().toString();
                String packageVersion = project.currentPackage().packageVersion().toString();
                try (Stream<Path> paths = Files.walk(target.cachesPath().resolve(packageOrg).resolve(packageName).resolve(packageVersion), new FileVisitOption[0]);){
                    testArtifactsPaths = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".jar")).toList();
                }
                for (Path testArtifactPath : testArtifactsPaths) {
                    CacheArtifactsTask.copyFile(testArtifactPath, targetDir, backupDir);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void copyFile(Path sourceFilePath, Path sourceRootPath, Path destRootPath) throws IOException {
        Path relativePath = sourceRootPath.relativize(sourceFilePath);
        Path destFile = destRootPath.resolve(relativePath);
        Files.createDirectories(destFile.getParent(), new FileAttribute[0]);
        Files.copy(sourceFilePath, destFile, StandardCopyOption.REPLACE_EXISTING);
    }
}

