/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.cmd;

import io.ballerina.cli.BLauncherCmd;
import io.ballerina.cli.cmd.CommandUtil;
import io.ballerina.projects.util.ProjectUtils;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.AccessDeniedException;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import picocli.CommandLine;

@CommandLine.Command(name="init", description={"This command is deprecated and will be removed in a future release. Use `bal new .` instead"})
public class InitCommand
implements BLauncherCmd {
    private final Path userDir;
    private final PrintStream errStream;
    private final boolean exitWhenFinish;
    @CommandLine.Option(names={"--help", "-h"}, hidden=true)
    private boolean helpFlag;
    @CommandLine.Parameters
    private List<String> argList;

    public InitCommand() {
        this.userDir = Path.of(System.getProperty("user.dir"), new String[0]);
        this.errStream = System.err;
        this.exitWhenFinish = true;
        CommandUtil.initJarFs();
    }

    public InitCommand(Path userDir, PrintStream errStream, boolean exitWhenFinish) {
        this.userDir = userDir;
        this.errStream = errStream;
        this.exitWhenFinish = exitWhenFinish;
        CommandUtil.initJarFs();
    }

    @Override
    public void execute() {
        this.errStream.println("WARNING: This command is deprecated and will be removed in a future release. Use `bal new .` instead");
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo("init");
            this.errStream.println(commandUsageInfo);
            return;
        }
        if (ProjectUtils.isBallerinaProject((Path)this.userDir)) {
            CommandUtil.printError(this.errStream, "directory is already a Ballerina project.", null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (this.argList != null && 1 != this.argList.size()) {
            CommandUtil.printError(this.errStream, "too many arguments", "bal init <project-name>", true);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        Path projectRoot = ProjectUtils.findProjectRoot((Path)this.userDir);
        if (projectRoot != null) {
            CommandUtil.printError(this.errStream, "directory is already within a Ballerina project :" + projectRoot.resolve("Ballerina.toml").toString(), null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        String packageName = Optional.of(this.userDir.getFileName()).get().toString();
        if (this.argList != null && !this.argList.isEmpty() && !ProjectUtils.validatePackageName((String)(packageName = this.argList.get(0)))) {
            CommandUtil.printError(this.errStream, "invalid package name : '" + packageName + "' :\n" + ProjectUtils.getPackageValidationError((String)packageName), null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (!ProjectUtils.validateNameLength((String)packageName)) {
            CommandUtil.printError(this.errStream, "invalid package name : '" + packageName + "' :\nMaximum length of package name is 256 characters.", null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (!ProjectUtils.validatePackageName((String)packageName)) {
            this.errStream.println("package name is derived as '" + ProjectUtils.guessPkgName((String)packageName, (String)"app") + "'. Edit the Ballerina.toml to change it.");
            this.errStream.println();
        }
        try {
            CommandUtil.initPackage(this.userDir, packageName, ProjectUtils.guessOrgName());
        }
        catch (AccessDeniedException e) {
            CommandUtil.printError(this.errStream, "error occurred while initializing project :  Access Denied : " + e.getMessage(), null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        catch (IOException e) {
            CommandUtil.printError(this.errStream, "error occurred while initializing project : " + e.getMessage(), null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        this.errStream.println("Created new package '" + ProjectUtils.guessPkgName((String)packageName, (String)"app") + "'.");
    }

    @Override
    public String getName() {
        return "init";
    }

    @Override
    public void printLongDesc(StringBuilder out) {
        out.append(BLauncherCmd.getCommandUsageInfo("init"));
    }

    @Override
    public void printUsage(StringBuilder out) {
        out.append("  bal init \n");
    }

    @Override
    public void setParentCmdParser(CommandLine parentCmdParser) {
    }
}

