/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.cmd;

import io.ballerina.cli.BLauncherCmd;
import io.ballerina.shell.cli.BShellConfiguration;
import io.ballerina.shell.cli.ReplShellApplication;
import java.io.File;
import java.io.PrintStream;
import picocli.CommandLine;

@CommandLine.Command(name="shell", description={"Run Ballerina interactive REPL"})
public class ShellCommand
implements BLauncherCmd {
    private final PrintStream errStream;
    @CommandLine.Option(names={"--help", "-h", "?"}, hidden=true)
    private boolean helpFlag;
    @CommandLine.Option(names={"-d", "--debug"}, description={"Whether to enable debug mode from start."})
    private boolean isDebug = false;
    @CommandLine.Option(names={"--force-dumb"}, description={"Whether to force use of dumb terminal."})
    private boolean forceDumb = false;
    @CommandLine.Option(names={"-t", "--time-out"}, description={"Timeout to use for tree parsing."})
    private long timeOut = 100L;
    @CommandLine.Option(names={"-f", "--file"}, description={"Open file and load initial declarations."})
    private File file;

    public ShellCommand() {
        this.errStream = System.err;
    }

    public ShellCommand(PrintStream errStream, boolean forceDumb, long timeOut) {
        this.errStream = errStream;
        this.forceDumb = forceDumb;
        this.timeOut = timeOut;
    }

    @Override
    public void execute() {
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo("shell");
            this.errStream.println(commandUsageInfo);
            return;
        }
        try {
            BShellConfiguration.Builder builder = new BShellConfiguration.Builder().setDebug(this.isDebug).setDumb(this.forceDumb).setTreeParsingTimeoutMs(this.timeOut);
            if (this.file != null) {
                builder.setStartFile(this.file.getAbsolutePath());
            }
            BShellConfiguration configuration = builder.build();
            ReplShellApplication.execute((BShellConfiguration)configuration);
        }
        catch (Exception e) {
            this.errStream.println("something went wrong while executing REPL: " + String.valueOf(e));
        }
    }

    @Override
    public String getName() {
        return "shell";
    }

    @Override
    public void printLongDesc(StringBuilder out) {
        out.append(BLauncherCmd.getCommandUsageInfo("shell"));
    }

    @Override
    public void printUsage(StringBuilder out) {
        out.append("  bal shell [-d|--debug] [--force-dumb] [-f|--file] [-t|--time-out <time-out-ms>]\n");
    }

    @Override
    public void setParentCmdParser(CommandLine parentCmdParser) {
    }
}

