/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.cmd;

import io.ballerina.cli.BLauncherCmd;
import io.ballerina.cli.utils.PrintUtils;
import io.ballerina.projects.BalToolsManifest;
import io.ballerina.projects.BalToolsToml;
import io.ballerina.projects.BlendedBalToolsManifest;
import io.ballerina.projects.internal.BalToolsManifestBuilder;
import io.ballerina.projects.util.BalToolsUtil;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.wso2.ballerinalang.util.RepoUtils;
import picocli.CommandLine;

@CommandLine.Command(name="list", description={"List all tools available in the local environment."})
public class ToolListCommand
implements BLauncherCmd {
    private final PrintStream outStream = System.out;
    @CommandLine.Option(names={"-a", "--all"}, description={"List all available tools"})
    boolean all = false;
    @CommandLine.Option(names={"--help", "-h"}, hidden=true)
    private boolean helpFlag;

    @Override
    public void execute() {
        if (this.helpFlag) {
            this.outStream.println(BLauncherCmd.getCommandUsageInfo("tool-list"));
            return;
        }
        List<BalToolsManifest.Tool> tools = this.listBalToolsTomlFile(this.all);
        if (tools.isEmpty()) {
            this.outStream.println("no tools found locally.");
            return;
        }
        PrintUtils.printLocalTools(tools, RepoUtils.getTerminalWidth(), this.all);
    }

    private List<BalToolsManifest.Tool> listBalToolsTomlFile(boolean all) {
        BalToolsToml balToolsToml = BalToolsToml.from((Path)BalToolsUtil.BAL_TOOLS_TOML_PATH);
        BalToolsManifest balToolsManifest = BalToolsManifestBuilder.from((BalToolsToml)balToolsToml).build();
        BalToolsToml distBalToolsToml = BalToolsToml.from((Path)BalToolsUtil.DIST_BAL_TOOLS_TOML_PATH);
        BalToolsManifest distBalToolsManifest = BalToolsManifestBuilder.from((BalToolsToml)distBalToolsToml).build();
        BlendedBalToolsManifest blendedBalToolsManifest = BlendedBalToolsManifest.from((BalToolsManifest)balToolsManifest, (BalToolsManifest)distBalToolsManifest);
        ArrayList<BalToolsManifest.Tool> flattenedTools = new ArrayList<BalToolsManifest.Tool>();
        if (all) {
            blendedBalToolsManifest.tools().values().stream().flatMap(map -> map.values().stream()).flatMap(map -> map.values().stream()).sorted(Comparator.comparing(BalToolsManifest.Tool::id).thenComparing(BalToolsManifest.Tool::version).reversed()).forEach(tool -> {
                Optional activeTool = blendedBalToolsManifest.getActiveTool(tool.id());
                tool.setActive(activeTool.isPresent() && ((BalToolsManifest.Tool)activeTool.get()).version().equals(tool.version()));
                flattenedTools.add((BalToolsManifest.Tool)tool);
            });
        } else {
            for (Map.Entry toolEntry : blendedBalToolsManifest.compatibleTools().entrySet()) {
                Optional activeTool = blendedBalToolsManifest.getActiveTool((String)toolEntry.getKey());
                if (activeTool.isEmpty()) continue;
                flattenedTools.add((BalToolsManifest.Tool)activeTool.get());
            }
        }
        return flattenedTools;
    }

    @Override
    public String getName() {
        return "list";
    }

    @Override
    public void printLongDesc(StringBuilder out) {
        out.append(BLauncherCmd.getCommandUsageInfo("tool-list"));
    }

    @Override
    public void printUsage(StringBuilder out) {
        out.append("bal tool list [--all]");
    }

    @Override
    public void setParentCmdParser(CommandLine parentCmdParser) {
    }
}

