/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.cmd;

import io.ballerina.cli.BLauncherCmd;
import io.ballerina.cli.cmd.CommandUtil;
import io.ballerina.cli.utils.ToolUtils;
import io.ballerina.projects.BalToolsManifest;
import io.ballerina.projects.BalToolsToml;
import io.ballerina.projects.BlendedBalToolsManifest;
import io.ballerina.projects.JvmTarget;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.SemanticVersion;
import io.ballerina.projects.Settings;
import io.ballerina.projects.internal.BalToolsManifestBuilder;
import io.ballerina.projects.internal.model.Proxy;
import io.ballerina.projects.util.BalToolsUtil;
import io.ballerina.projects.util.ProjectUtils;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ballerinalang.central.client.CentralAPIClient;
import org.ballerinalang.central.client.exceptions.CentralClientException;
import org.ballerinalang.central.client.exceptions.PackageAlreadyExistsException;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.util.RepoUtils;
import picocli.CommandLine;

@CommandLine.Command(name="pull", description={"Pull the specified tool"})
public class ToolPullCommand
implements BLauncherCmd {
    public static final String EMPTY_STRING = "";
    private final boolean exitWhenFinish;
    private final PrintStream outStream;
    private final PrintStream errStream;
    private String toolId;
    private String version;
    private static final String TOOL_PULL_USAGE_TEXT = "bal tool pull <tool-id>";
    @CommandLine.Parameters(description={"Pull a tool"})
    private List<String> argList;
    @CommandLine.Option(names={"--repository"})
    private String repositoryName;
    @CommandLine.Option(names={"--help", "-h"}, hidden=true)
    private boolean helpFlag;
    @CommandLine.Option(names={"--force"}, hidden=true)
    private boolean force;

    public ToolPullCommand() {
        this.exitWhenFinish = true;
        this.outStream = System.out;
        this.errStream = System.err;
    }

    public ToolPullCommand(PrintStream outStream, PrintStream errStream, boolean exitWhenFinish) {
        this.outStream = outStream;
        this.errStream = errStream;
        this.exitWhenFinish = exitWhenFinish;
    }

    @Override
    public void execute() {
        if (this.helpFlag) {
            this.outStream.println(BLauncherCmd.getCommandUsageInfo("tool-pull"));
            return;
        }
        if (this.argList == null || this.argList.isEmpty()) {
            CommandUtil.printError(this.errStream, "tool id is not provided.", TOOL_PULL_USAGE_TEXT, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (this.argList.size() > 1) {
            CommandUtil.printError(this.errStream, "too many arguments.", TOOL_PULL_USAGE_TEXT, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (this.repositoryName != null && !this.repositoryName.equals("local")) {
            String errMsg = "unsupported repository '" + this.repositoryName + "' found. Only 'local' repository is supported.";
            CommandUtil.printError(this.errStream, errMsg, null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        String toolIdAndVersion = this.argList.get(0);
        String[] toolInfo = toolIdAndVersion.split(":");
        if (toolInfo.length == 2) {
            this.toolId = toolInfo[0];
            this.version = toolInfo[1];
        } else if (toolInfo.length == 1) {
            this.toolId = toolIdAndVersion;
            this.version = EMPTY_STRING;
        } else {
            CommandUtil.printError(this.errStream, "invalid tool id.", TOOL_PULL_USAGE_TEXT, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if ("local".equals(this.repositoryName) && EMPTY_STRING.equals(this.version)) {
            CommandUtil.printError(this.errStream, "tool version should be provided when pulling a tool from local repository", null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (!ProjectUtils.validateToolName((String)this.toolId)) {
            CommandUtil.printError(this.errStream, "invalid tool id.", TOOL_PULL_USAGE_TEXT, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (!Names.EMPTY.getValue().equals(this.version)) {
            try {
                SemanticVersion.from((String)this.version);
            }
            catch (ProjectException e) {
                CommandUtil.printError(this.errStream, "invalid tool version. " + e.getMessage(), TOOL_PULL_USAGE_TEXT, false);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
        }
        this.pullToolAndUpdateBalToolsToml(this.toolId, this.version);
    }

    @Override
    public String getName() {
        return EMPTY_STRING;
    }

    @Override
    public void printLongDesc(StringBuilder out) {
        BLauncherCmd.getCommandUsageInfo("tool-pull");
    }

    @Override
    public void printUsage(StringBuilder out) {
        out.append("bal tool pull <tool-id>[:<version>]");
    }

    @Override
    public void setParentCmdParser(CommandLine parentCmdParser) {
    }

    public void pullToolAndUpdateBalToolsToml(String toolIdArg, String version) {
        this.toolId = toolIdArg;
        this.version = version;
        Path balaCacheDirPath = RepoUtils.createAndGetHomeReposPath().resolve("repositories").resolve("central.ballerina.io").resolve("bala");
        String supportedPlatform = Arrays.stream(JvmTarget.values()).map(JvmTarget::code).collect(Collectors.joining(","));
        if ("local".equals(this.repositoryName)) {
            Optional<BalToolsManifest.Tool> toolFromLocalRepo = ToolUtils.getToolFromLocalRepo(this.toolId, version);
            if (toolFromLocalRepo.isEmpty()) {
                this.errStream.println("tool '" + this.toolId + ":" + version + "' is not available in local repository.\nUse 'bal push --repository=local' to publish it.");
                CommandUtil.exitError(this.exitWhenFinish);
            }
            BalToolsToml balToolsToml = BalToolsToml.from((Path)BalToolsUtil.BAL_TOOLS_TOML_PATH);
            BalToolsManifest balToolsManifest = BalToolsManifestBuilder.from((BalToolsToml)balToolsToml).build();
            this.addToBalToolsToml(balToolsToml, balToolsManifest, toolFromLocalRepo.orElseThrow(), this.errStream);
            this.outStream.println("tool '" + this.toolId + ":" + version + "' successfully set as the active version.");
            return;
        }
        try {
            Optional<BalToolsManifest.Tool> toolAvailableLocally = ToolUtils.getToolAvailableLocally(this.toolId, version, this.repositoryName);
            if (toolAvailableLocally.isPresent()) {
                this.outStream.println("tool '" + this.toolId + ":" + version + "' is already available locally.");
            } else {
                BalToolsManifest.Tool toolFromCentral = this.pullToolFromCentral(supportedPlatform, balaCacheDirPath);
                BalToolsToml balToolsToml = BalToolsToml.from((Path)BalToolsUtil.BAL_TOOLS_TOML_PATH);
                BalToolsManifest balToolsManifest = BalToolsManifestBuilder.from((BalToolsToml)balToolsToml).build();
                BalToolsToml distBalToolsToml = BalToolsToml.from((Path)BalToolsUtil.DIST_BAL_TOOLS_TOML_PATH);
                BalToolsManifest distBalToolsManifest = BalToolsManifestBuilder.from((BalToolsToml)distBalToolsToml).build();
                BlendedBalToolsManifest blendedBalToolsManifest = BlendedBalToolsManifest.from((BalToolsManifest)balToolsManifest, (BalToolsManifest)distBalToolsManifest);
                Optional activeTool = blendedBalToolsManifest.getActiveTool(this.toolId);
                if (this.force) {
                    toolFromCentral.setForce(true);
                    activeTool.ifPresent(tool -> tool.setForce(false));
                } else if (activeTool.isPresent()) {
                    if (SemanticVersion.from((String)((BalToolsManifest.Tool)activeTool.get()).version()).greaterThan(SemanticVersion.from((String)toolFromCentral.version()))) {
                        String warning = "WARNING: a higher version of the tool'" + this.toolId + ":" + ((BalToolsManifest.Tool)activeTool.get()).version() + "' is available locally and will be used as the active version. Run 'bal tool use " + this.toolId + ":" + toolFromCentral.version() + "' to use the pulled version forcefully.";
                        this.outStream.println(warning);
                        toolFromCentral.setActive(false);
                    } else if (((BalToolsManifest.Tool)activeTool.get()).force()) {
                        String warning = "WARNING: tool '" + this.toolId + ":" + ((BalToolsManifest.Tool)activeTool.get()).version() + "' is forcefully set as the active version. Run 'bal tool update --offline " + this.toolId + "' to set '" + toolFromCentral.version() + "' as the active version.";
                        this.outStream.println(warning);
                        toolFromCentral.setActive(false);
                    }
                }
                if (!this.addToBalToolsToml(balToolsToml, balToolsManifest, toolFromCentral, this.errStream)) {
                    CommandUtil.exitError(this.exitWhenFinish);
                } else if (this.force || toolFromCentral.active().booleanValue()) {
                    this.outStream.println("tool '" + this.toolId + ":" + toolFromCentral.version() + "' successfully set as the active version.");
                }
            }
        }
        catch (PackageAlreadyExistsException e) {
            this.errStream.println(e.getMessage());
            CommandUtil.exitError(this.exitWhenFinish);
        }
        catch (ProjectException | CentralClientException e) {
            CommandUtil.printError(this.errStream, "unexpected error occurred while pulling tool:" + e.getMessage(), null, false);
            BalToolsToml balToolsToml = BalToolsToml.from((Path)BalToolsUtil.DIST_BAL_TOOLS_TOML_PATH);
            BalToolsManifest balToolsManifest = BalToolsManifestBuilder.from((BalToolsToml)balToolsToml).build();
            Optional toolOptional = balToolsManifest.getActiveTool(this.toolId);
            if (toolOptional.isEmpty()) {
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
            this.outStream.println("tool '" + this.toolId + ":" + ((BalToolsManifest.Tool)toolOptional.get()).version() + "' from the distribution is set as the active version.");
        }
    }

    private BalToolsManifest.Tool pullToolFromCentral(String supportedPlatform, Path balaCacheDirPath) throws CentralClientException {
        Settings settings = RepoUtils.readSettings();
        System.setProperty("enableOutputStream", "true");
        CentralAPIClient client = new CentralAPIClient(RepoUtils.getRemoteRepoURL(), ProjectUtils.initializeProxy((Proxy)settings.getProxy()), settings.getProxy().username(), settings.getProxy().password(), ProjectUtils.getAccessTokenOfCLI((Settings)settings), settings.getCentral().getConnectTimeout(), settings.getCentral().getReadTimeout(), settings.getCentral().getWriteTimeout(), settings.getCentral().getCallTimeout(), settings.getCentral().getMaxRetries());
        String[] toolInfo = client.pullTool(this.toolId, this.version, balaCacheDirPath, supportedPlatform, RepoUtils.getBallerinaVersion(), false);
        boolean isPulled = Boolean.parseBoolean(toolInfo[0]);
        String org = toolInfo[0];
        String name = toolInfo[1];
        this.version = toolInfo[2];
        if (isPulled) {
            this.outStream.println("tool '" + this.toolId + ":" + this.version + "' pulled successfully.");
        }
        return new BalToolsManifest.Tool(this.toolId, org, name, this.version, Boolean.valueOf(true), null);
    }

    private boolean addToBalToolsToml(BalToolsToml balToolsToml, BalToolsManifest balToolsManifest, BalToolsManifest.Tool tool, PrintStream printStream) {
        boolean isCompatibleWithPlatform = BalToolsUtil.isCompatibleWithPlatform((String)tool.org(), (String)tool.name(), (String)tool.version(), (String)tool.repository());
        if (!isCompatibleWithPlatform) {
            printStream.println("Tool '" + this.toolId + ":" + tool.version() + "' is not compatible with the current Ballerina distribution version. Run 'bal tool list' to see compatible versions.");
            return false;
        }
        balToolsManifest.addTool(tool.id(), tool.org(), tool.name(), tool.version(), tool.active(), tool.repository(), tool.force());
        balToolsToml.modify(balToolsManifest);
        return true;
    }
}

