/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.cmd;

import io.ballerina.cli.BLauncherCmd;
import io.ballerina.cli.cmd.CommandUtil;
import io.ballerina.cli.utils.ToolUtils;
import io.ballerina.projects.BalToolsManifest;
import io.ballerina.projects.BalToolsToml;
import io.ballerina.projects.BlendedBalToolsManifest;
import io.ballerina.projects.JvmTarget;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.SemanticVersion;
import io.ballerina.projects.internal.BalToolsManifestBuilder;
import io.ballerina.projects.util.BalToolsUtil;
import io.ballerina.projects.util.BuildToolsUtil;
import io.ballerina.projects.util.ProjectUtils;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import picocli.CommandLine;

@CommandLine.Command(name="use", description={"Set a tool version as the active version."})
public class ToolUseCommand
implements BLauncherCmd {
    private final boolean exitWhenFinish;
    private final PrintStream outStream;
    private final PrintStream errStream;
    private static final String TOOL_USE_USAGE_TEXT = "bal tool use <tool-id>:<version>";
    @CommandLine.Parameters(description={"Use a tool"})
    private List<String> argList;
    @CommandLine.Option(names={"--repository"})
    private String repositoryName;
    @CommandLine.Option(names={"--help", "-h"}, hidden=true)
    private boolean helpFlag;

    public ToolUseCommand() {
        this.exitWhenFinish = true;
        this.outStream = System.out;
        this.errStream = System.err;
    }

    public ToolUseCommand(PrintStream outStream, PrintStream errStream, boolean exitWhenFinish) {
        this.outStream = outStream;
        this.errStream = errStream;
        this.exitWhenFinish = exitWhenFinish;
    }

    @Override
    public void execute() {
        Optional tool;
        if (this.helpFlag) {
            this.outStream.println(BLauncherCmd.getCommandUsageInfo("tool-use"));
            return;
        }
        if (this.argList == null || this.argList.isEmpty()) {
            CommandUtil.printError(this.errStream, "tool id is not provided.", TOOL_USE_USAGE_TEXT, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (this.argList.size() > 1) {
            CommandUtil.printError(this.errStream, "too many arguments.", TOOL_USE_USAGE_TEXT, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (this.repositoryName != null && !this.repositoryName.equals("local")) {
            String errMsg = "unsupported repository '" + this.repositoryName + "' found. Only 'local' repository is supported.";
            CommandUtil.printError(this.errStream, errMsg, null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        String toolIdAndVersion = this.argList.get(0);
        String[] toolInfo = toolIdAndVersion.split(":");
        if (toolInfo.length != 2) {
            CommandUtil.printError(this.errStream, "invalid tool id.", TOOL_USE_USAGE_TEXT, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        String toolId = toolInfo[0];
        String version = toolInfo[1];
        if (!ProjectUtils.validateToolName((String)toolId)) {
            CommandUtil.printError(this.errStream, "invalid tool id.", TOOL_USE_USAGE_TEXT, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        try {
            SemanticVersion.from((String)version);
        }
        catch (ProjectException e) {
            CommandUtil.printError(this.errStream, "invalid tool version. " + e.getMessage(), TOOL_USE_USAGE_TEXT, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        BalToolsToml balToolsToml = BalToolsToml.from((Path)BalToolsUtil.BAL_TOOLS_TOML_PATH);
        BalToolsManifest balToolsManifest = BalToolsManifestBuilder.from((BalToolsToml)balToolsToml).build();
        BalToolsToml distBalToolsToml = BalToolsToml.from((Path)BalToolsUtil.DIST_BAL_TOOLS_TOML_PATH);
        BalToolsManifest distBalToolsManifest = BalToolsManifestBuilder.from((BalToolsToml)distBalToolsToml).build();
        BlendedBalToolsManifest blendedBalToolsManifest = BlendedBalToolsManifest.from((BalToolsManifest)balToolsManifest, (BalToolsManifest)distBalToolsManifest);
        Optional activeTool = blendedBalToolsManifest.getActiveTool(toolId);
        if (activeTool.isPresent() && SemanticVersion.from((String)((BalToolsManifest.Tool)activeTool.get()).version()).greaterThan(SemanticVersion.from((String)version))) {
            this.outStream.println("WARNING: " + ((BalToolsManifest.Tool)activeTool.get()).id() + ":" + ((BalToolsManifest.Tool)activeTool.get()).version() + " is available locally. Run 'bal tool update " + toolId + "' to update to the latest version.\n");
        }
        if ((tool = blendedBalToolsManifest.getTool(toolId, version, this.repositoryName)).isEmpty()) {
            Optional<BalToolsManifest.Tool> toolFromLocalRepo = ToolUtils.getToolFromLocalRepo(toolId, version);
            if (toolFromLocalRepo.isEmpty()) {
                CommandUtil.printError(this.errStream, "tool '" + toolId + ":" + version + "' is not found. Run 'bal tool pull " + toolId + ":" + version + "' or 'bal tool pull " + toolId + ":" + version + " --repository=local' to fetch and set as the active version.", null, false);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
            CommandUtil.printError(this.errStream, "tool '" + toolId + ":" + version + "' is not found. Run 'bal tool pull " + toolId + ":" + version + "' to fetch and set as the active version.", null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        String org = ((BalToolsManifest.Tool)tool.get()).org();
        String name = ((BalToolsManifest.Tool)tool.get()).name();
        Optional currentActiveTool = blendedBalToolsManifest.getActiveTool(toolId);
        if (currentActiveTool.isPresent() && ((BalToolsManifest.Tool)currentActiveTool.get()).version().equals(((BalToolsManifest.Tool)tool.get()).version()) && Objects.equals(((BalToolsManifest.Tool)currentActiveTool.get()).repository(), ((BalToolsManifest.Tool)tool.get()).repository())) {
            this.outStream.println("tool '" + toolId + ":" + version + "' is the current active version.");
            return;
        }
        boolean isCompatibleWithPlatform = BalToolsUtil.isCompatibleWithPlatform((String)org, (String)name, (String)version, (String)((BalToolsManifest.Tool)tool.get()).repository());
        if (!isCompatibleWithPlatform) {
            CommandUtil.printError(this.errStream, "tool '" + toolId + ":" + version + "' is not compatible with the current distribution.", null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        balToolsManifest.resetCurrentActiveVersion(toolId);
        if ("distribution".equals(((BalToolsManifest.Tool)tool.get()).repository())) {
            this.copyToolToCentralCache((BalToolsManifest.Tool)tool.get());
            balToolsManifest.addTool(((BalToolsManifest.Tool)tool.get()).id(), ((BalToolsManifest.Tool)tool.get()).org(), ((BalToolsManifest.Tool)tool.get()).name(), ((BalToolsManifest.Tool)tool.get()).version(), Boolean.valueOf(true), null, true);
        } else {
            balToolsManifest.setActiveToolVersion(toolId, version, ((BalToolsManifest.Tool)tool.get()).repository(), true);
            currentActiveTool.ifPresent(tool1 -> tool1.setForce(false));
        }
        balToolsToml.modify(balToolsManifest);
        this.outStream.println("tool '" + toolId + ":" + version + "' successfully set as the active version.");
    }

    private void copyToolToCentralCache(BalToolsManifest.Tool tool) {
        Path relativeBalaPath = ProjectUtils.getRelativeBalaPath((String)tool.org(), (String)tool.name(), (String)tool.version(), (String)JvmTarget.JAVA_21.code());
        Path distBalaPath = BalToolsUtil.getRepoPath((String)tool.repository()).resolve(relativeBalaPath);
        Path centralCacheBalaPath = BuildToolsUtil.getCentralBalaDirPath().resolve(relativeBalaPath);
        try {
            Path optionalPath = Optional.of(centralCacheBalaPath.getParent()).get();
            if (!Files.exists(optionalPath, new LinkOption[0])) {
                Files.createDirectories(optionalPath, new FileAttribute[0]);
            }
            if (Files.exists(distBalaPath, new LinkOption[0]) && Files.isDirectory(distBalaPath, new LinkOption[0])) {
                this.copyDirectory(distBalaPath, centralCacheBalaPath);
            }
        }
        catch (IOException e) {
            CommandUtil.printError(this.errStream, "failed to copy tool to central cache: " + e.getMessage(), null, false);
            CommandUtil.exitError(this.exitWhenFinish);
        }
    }

    private void copyDirectory(Path source, Path target) throws IOException {
        try (Stream<Path> walk = Files.walk(source, new FileVisitOption[0]);){
            walk.forEach(sourcePath -> {
                try {
                    Path targetPath = target.resolve(source.relativize((Path)sourcePath));
                    if (Files.isDirectory(sourcePath, new LinkOption[0])) {
                        Files.createDirectories(targetPath, new FileAttribute[0]);
                    } else {
                        Files.copy(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    @Override
    public String getName() {
        return "use";
    }

    @Override
    public void printLongDesc(StringBuilder out) {
        out.append(BLauncherCmd.getCommandUsageInfo("tool-use"));
    }

    @Override
    public void printUsage(StringBuilder out) {
        out.append(TOOL_USE_USAGE_TEXT);
    }

    @Override
    public void setParentCmdParser(CommandLine parentCmdParser) {
    }
}

