/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.task;

import io.ballerina.cli.launcher.LauncherUtils;
import io.ballerina.cli.task.Task;
import io.ballerina.cli.utils.BuildTime;
import io.ballerina.cli.utils.BuildUtils;
import io.ballerina.cli.utils.FileUtils;
import io.ballerina.cli.utils.GraalVMCompatibilityUtils;
import io.ballerina.projects.EmitResult;
import io.ballerina.projects.JBallerinaBackend;
import io.ballerina.projects.JvmTarget;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.internal.model.Target;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class CreateExecutableTask
implements Task {
    private final transient PrintStream out;
    private Path output;
    private Path currentDir;
    private Target target;
    private final boolean isHideTaskOutput;
    private final boolean skipTask;
    private final boolean skipExecutable;

    public CreateExecutableTask(PrintStream out, String output, Target target, boolean isHideTaskOutput) {
        this(out, output, target, isHideTaskOutput, false);
    }

    public CreateExecutableTask(PrintStream out, String output, Target target, boolean isHideTaskOutput, boolean skipTask) {
        this(out, output, target, isHideTaskOutput, skipTask, false);
    }

    public CreateExecutableTask(PrintStream out, String output, Target target, boolean isHideTaskOutput, boolean skipTask, boolean skipExecutable) {
        this.out = out;
        this.target = target;
        this.isHideTaskOutput = isHideTaskOutput;
        this.skipTask = skipTask;
        this.skipExecutable = skipExecutable;
        if (output != null) {
            this.output = Path.of(output, new String[0]);
        }
    }

    @Override
    public void execute(Project project) {
        this.currentDir = Path.of(System.getProperty("user.dir"), new String[0]);
        if (this.target == null) {
            this.target = this.getTarget(project);
        }
        Path executablePath = this.getExecutablePath(project, this.target);
        if (!this.isHideTaskOutput && !this.skipExecutable) {
            this.out.println();
            if (!project.buildOptions().nativeImage()) {
                this.out.println("Generating executable" + (String)(this.skipTask ? " (UP-TO-DATE)\n\t" + String.valueOf(this.currentDir.relativize(executablePath)) : ""));
            }
        }
        if (this.skipTask) {
            return;
        }
        try {
            EmitResult emitResult;
            PackageCompilation pkgCompilation = project.currentPackage().getCompilation();
            JBallerinaBackend jBallerinaBackend = JBallerinaBackend.from((PackageCompilation)pkgCompilation, (JvmTarget)JvmTarget.JAVA_21);
            long start = 0L;
            if (project.buildOptions().dumpBuildTime()) {
                start = System.currentTimeMillis();
            }
            if (this.skipExecutable) {
                return;
            }
            if (project.buildOptions().nativeImage() && project.buildOptions().cloud().isEmpty()) {
                String warnings = GraalVMCompatibilityUtils.getAllWarnings(project.currentPackage(), jBallerinaBackend.targetPlatform().code(), false);
                if (!warnings.isEmpty()) {
                    this.out.println(warnings);
                }
                emitResult = jBallerinaBackend.emit(JBallerinaBackend.OutputType.GRAAL_EXEC, executablePath);
            } else {
                emitResult = jBallerinaBackend.emit(JBallerinaBackend.OutputType.EXEC, executablePath);
            }
            if (project.buildOptions().dumpBuildTime()) {
                BuildTime.getInstance().emitArtifactDuration = System.currentTimeMillis() - start;
                BuildTime.getInstance().compile = false;
            }
            if (!jBallerinaBackend.conflictedJars().isEmpty()) {
                this.out.println("\twarning: Detected conflicting jar files:");
                for (JBallerinaBackend.JarConflict conflict : jBallerinaBackend.conflictedJars()) {
                    this.out.println(conflict.getWarning(project.buildOptions().listConflictedClasses()));
                }
            }
            if (!emitResult.diagnostics().diagnostics().isEmpty() && !this.isHideTaskOutput) {
                emitResult.diagnostics().diagnostics().forEach(d -> this.out.println("\n" + d.toString()));
            }
        }
        catch (ProjectException e) {
            throw LauncherUtils.createLauncherException(e.getMessage());
        }
        if (!project.buildOptions().nativeImage() && !this.isHideTaskOutput) {
            Path relativePathToExecutable = this.currentDir.relativize(executablePath);
            if (project.buildOptions().getTargetPath() != null) {
                this.out.println("\t" + String.valueOf(relativePathToExecutable));
            } else if (relativePathToExecutable.toString().contains("..") || relativePathToExecutable.toString().contains("." + File.separator)) {
                this.out.println("\t" + String.valueOf(executablePath));
            } else {
                this.out.println("\t" + String.valueOf(relativePathToExecutable));
            }
        }
        BuildUtils.notifyPlugins(project, this.target);
    }

    private Target getTarget(Project project) {
        Target target;
        try {
            if (project.kind().equals((Object)ProjectKind.BUILD_PROJECT)) {
                target = new Target(project.targetDir());
            } else {
                target = new Target(Files.createTempDirectory("ballerina-cache" + System.nanoTime(), new FileAttribute[0]));
                target.setOutputPath(this.getExecutablePath(project));
            }
        }
        catch (IOException e) {
            throw LauncherUtils.createLauncherException("unable to resolve target path:" + e.getMessage());
        }
        catch (ProjectException e) {
            throw LauncherUtils.createLauncherException("unable to create executable:" + e.getMessage());
        }
        return target;
    }

    private Path getExecutablePath(Project project, Target target) {
        try {
            return target.getExecutablePath(project.currentPackage()).toAbsolutePath().normalize();
        }
        catch (IOException e) {
            throw LauncherUtils.createLauncherException(e.getMessage());
        }
    }

    private Path getExecutablePath(Project project) {
        Path fileName = project.sourceRoot().getFileName();
        if (this.output == null) {
            return this.currentDir.resolve(FileUtils.getFileNameWithoutExtension(fileName) + ".jar");
        }
        if (!this.output.isAbsolute()) {
            this.output = this.currentDir.resolve(this.output);
        }
        if (Files.isDirectory(this.output, new LinkOption[0])) {
            return this.output.resolve(FileUtils.getFileNameWithoutExtension(fileName) + ".jar");
        }
        if (!FileUtils.hasExtension(this.output)) {
            return Path.of(this.output.toString() + ".jar", new String[0]);
        }
        return this.output;
    }
}

