/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.task;

import io.ballerina.cli.launcher.LauncherUtils;
import io.ballerina.cli.task.Task;
import io.ballerina.cli.utils.BuildTime;
import io.ballerina.cli.utils.BuildUtils;
import io.ballerina.cli.utils.FileUtils;
import io.ballerina.cli.utils.NativeUtils;
import io.ballerina.cli.utils.TestUtils;
import io.ballerina.projects.EmitResult;
import io.ballerina.projects.JBallerinaBackend;
import io.ballerina.projects.JarLibrary;
import io.ballerina.projects.JvmTarget;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleDescriptor;
import io.ballerina.projects.ModuleName;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.TestEmitArgs;
import io.ballerina.projects.internal.model.Target;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.zip.ZipFile;
import org.ballerinalang.test.runtime.entity.TestSuite;
import org.ballerinalang.testerina.core.TestProcessor;

public class CreateTestExecutableTask
implements Task {
    private final transient PrintStream out;
    private final String groupList;
    private final String disableGroupList;
    private final boolean report;
    private final boolean coverage;
    private final boolean isRerunTestExecution;
    private final String singleExecTests;
    private final boolean listGroups;
    private final List<String> cliArgs;
    private final boolean isParallelExecution;

    public CreateTestExecutableTask(PrintStream out, String groupList, String disableGroupList, String singleExecTests, boolean listGroups, String[] cliArgs, boolean isParallelExecution) {
        this.out = out;
        this.groupList = groupList;
        this.disableGroupList = disableGroupList;
        this.report = false;
        this.coverage = false;
        this.isRerunTestExecution = false;
        this.singleExecTests = singleExecTests;
        this.listGroups = listGroups;
        this.cliArgs = List.of(cliArgs);
        this.isParallelExecution = isParallelExecution;
    }

    @Override
    public void execute(Project project) {
        Target target = this.getTarget(project);
        try {
            PackageCompilation pkgCompilation = project.currentPackage().getCompilation();
            JBallerinaBackend jBallerinaBackend = JBallerinaBackend.from((PackageCompilation)pkgCompilation, (JvmTarget)JvmTarget.JAVA_21);
            ArrayList<Diagnostic> emitDiagnostics = new ArrayList<Diagnostic>();
            Path testCachePath = target.getTestsCachePath();
            long start = 0L;
            if (project.buildOptions().dumpBuildTime()) {
                start = System.currentTimeMillis();
            }
            HashSet<JarLibrary> testExecDependencies = new HashSet<JarLibrary>();
            HashMap<String, TestSuite> testSuiteMap = new HashMap<String, TestSuite>();
            boolean suiteCreated = this.createTestSuiteForCloudArtifacts(project, jBallerinaBackend, target, testSuiteMap);
            if (suiteCreated) {
                this.writeCmdArgsToFile(this.getTestExecutableBasePath(target), target, TestUtils.getJsonFilePath(testCachePath));
                if (project.buildOptions().nativeImage()) {
                    NativeUtils.createReflectConfig(target.getNativeConfigPath(), project.currentPackage(), testSuiteMap);
                    boolean hasMockFunctions = false;
                    for (Map.Entry entry : testSuiteMap.entrySet()) {
                        if (((TestSuite)entry.getValue()).getMockFunctionNamesMap().isEmpty()) continue;
                        hasMockFunctions = true;
                        break;
                    }
                    if (hasMockFunctions) {
                        this.perModuleFatJarGeneration(testSuiteMap, target, jBallerinaBackend, emitDiagnostics, project);
                    } else {
                        this.standaloneFatJarGeneration(project, jBallerinaBackend, target, testExecDependencies, testCachePath, emitDiagnostics);
                    }
                } else {
                    this.standaloneFatJarGeneration(project, jBallerinaBackend, target, testExecDependencies, testCachePath, emitDiagnostics);
                }
            }
            if (project.buildOptions().dumpBuildTime()) {
                BuildTime.getInstance().emitArtifactDuration = System.currentTimeMillis() - start;
                BuildTime.getInstance().compile = false;
            }
            if (!jBallerinaBackend.conflictedJars().isEmpty()) {
                this.out.println("\twarning: Detected conflicting jar files:");
                for (JBallerinaBackend.JarConflict conflict : jBallerinaBackend.conflictedJars()) {
                    this.out.println(conflict.getWarning(project.buildOptions().listConflictedClasses()));
                }
            }
            if (!emitDiagnostics.isEmpty()) {
                emitDiagnostics.forEach(d -> this.out.println("\n" + d.toString()));
            }
        }
        catch (ProjectException | IOException e) {
            throw LauncherUtils.createLauncherException(e.getMessage());
        }
        BuildUtils.notifyPlugins(project, target);
        TestUtils.cleanTempCache(project, target.path());
    }

    private void standaloneFatJarGeneration(Project project, JBallerinaBackend jBallerinaBackend, Target target, HashSet<JarLibrary> testExecDependencies, Path testCachePath, List<Diagnostic> emitDiagnostics) throws IOException {
        for (ModuleDescriptor moduleDescriptor : project.currentPackage().moduleDependencyGraph().toTopologicallySortedList()) {
            Module module = project.currentPackage().module(moduleDescriptor.name());
            if (module.testDocumentIds().isEmpty()) continue;
            testExecDependencies.addAll(jBallerinaBackend.jarResolver().getJarFilePathsRequiredForTestExecution(module.moduleName()));
        }
        String jarName = project.currentPackage().packageName().toString();
        if (jarName.equals(".")) {
            Optional<Path> projectSourceRootFileName = Optional.ofNullable(project.sourceRoot().getFileName());
            if (projectSourceRootFileName.isPresent()) {
                jarName = FileUtils.getFileNameWithoutExtension(projectSourceRootFileName.get());
            } else {
                throw new IllegalStateException("unable to resolve project source root");
            }
        }
        Path testExecutablePath = this.getTestExecutableBasePath(target).resolve(jarName + "-testable.jar");
        List<Path> moduleJarPaths = TestUtils.getModuleJarPaths(jBallerinaBackend, project.currentPackage());
        ArrayList excludedClasses = new ArrayList();
        for (Path moduleJarPath : moduleJarPaths) {
            try (ZipFile zipFile = new ZipFile(moduleJarPath.toFile());){
                zipFile.stream().forEach(entry -> {
                    if (entry.getName().endsWith(".class")) {
                        excludedClasses.add(entry.getName().replace(File.separator, ".").replace(".class", ""));
                    }
                });
            }
        }
        EmitResult result = jBallerinaBackend.emit(new TestEmitArgs(JBallerinaBackend.OutputType.TEST, testExecutablePath, testExecDependencies, TestUtils.getJsonFilePath(testCachePath), TestUtils.getJsonFilePathInFatJar(File.separator), excludedClasses, "excludedClasses.txt"));
        emitDiagnostics.addAll(result.diagnostics().diagnostics());
    }

    private void perModuleFatJarGeneration(Map<String, TestSuite> testSuiteMap, Target target, JBallerinaBackend jBallerinaBackend, List<Diagnostic> emitDiagnostics, Project project) throws IOException {
        ArrayList clonedMaps = new ArrayList();
        testSuiteMap.keySet().forEach(mapEntry -> {
            HashMap<String, TestSuite> clonedMap = new HashMap<String, TestSuite>();
            clonedMap.put((String)mapEntry, (TestSuite)testSuiteMap.get(mapEntry));
            clonedMaps.add(clonedMap);
        });
        List<ModuleName> moduleNames = project.currentPackage().moduleDependencyGraph().toTopologicallySortedList().stream().map(ModuleDescriptor::name).toList();
        for (Map clonedMap : clonedMaps) {
            TestSuite testSuite = clonedMap.values().toArray(new TestSuite[0])[0];
            String moduleName = testSuite.getPackageID();
            NativeUtils.createReflectConfig(target.getNativeConfigPath(), project.currentPackage(), clonedMap);
            try {
                NativeUtils.modifyJarForFunctionMock(testSuite, target, moduleName);
            }
            catch (IOException e) {
                throw LauncherUtils.createLauncherException("error occurred while running tests", e);
            }
            ModuleName moduleNameObj = moduleNames.stream().filter(name -> name.toString().equals(moduleName)).findFirst().orElseThrow();
            testSuite.removeAllMockFunctions();
            Collection testDependencies = jBallerinaBackend.jarResolver().getJarFilePathsRequiredForTestExecution(moduleNameObj);
            List<Path> requiredDependencies = testSuite.getTestExecutionDependencies().stream().map(x$0 -> Path.of(x$0, new String[0])).toList();
            HashSet filteredTestDependencies = new HashSet();
            requiredDependencies.forEach(neededDependency -> {
                Optional<JarLibrary> foundDependency;
                String comparingStr = "-mod.jar";
                Optional<Path> neededDependencyFileName = Optional.ofNullable(neededDependency.getFileName());
                if (neededDependencyFileName.isPresent()) {
                    String requiredDependencyFileName = neededDependencyFileName.get().toString();
                    if (!requiredDependencyFileName.contains(comparingStr)) {
                        return;
                    }
                    String originalFileName = requiredDependencyFileName.replace(comparingStr, "");
                    foundDependency = testDependencies.stream().filter(dep -> {
                        Optional<Path> depFileName = Optional.ofNullable(dep.path().getFileName());
                        if (depFileName.isPresent()) {
                            return depFileName.get().toString().contains(originalFileName) && !depFileName.get().toString().contains("testable");
                        }
                        throw new IllegalStateException("unable to resolve dependency file name");
                    }).findFirst();
                    if (foundDependency.isEmpty()) {
                        return;
                    }
                } else {
                    throw new IllegalStateException("unable to resolve dependency file name");
                }
                JarLibrary modifiedJarLibrary = new JarLibrary(neededDependency, foundDependency.get().scope());
                filteredTestDependencies.add(modifiedJarLibrary);
                testDependencies.remove(foundDependency.get());
            });
            filteredTestDependencies.addAll(testDependencies);
            testSuite.removeAllTestExecutionDependencies();
            try {
                TestUtils.writeToTestSuiteJson(clonedMap, target.getTestsCachePath());
            }
            catch (IOException e) {
                throw LauncherUtils.createLauncherException("error while writing to test suite json file: " + e.getMessage());
            }
            Path testExecutablePath = this.getTestExecutableBasePath(target).resolve(moduleName + "-testable.jar");
            EmitResult result = jBallerinaBackend.emit(new TestEmitArgs(JBallerinaBackend.OutputType.TEST, testExecutablePath, filteredTestDependencies, TestUtils.getJsonFilePath(target.getTestsCachePath()), TestUtils.getJsonFilePathInFatJar(File.separator), new ArrayList(), "excludedClasses.txt"));
            emitDiagnostics.addAll(result.diagnostics().diagnostics());
        }
    }

    private boolean createTestSuiteForCloudArtifacts(Project project, JBallerinaBackend jBallerinaBackend, Target target, Map<String, TestSuite> testSuiteMap) {
        ArrayList<String> mockClassNames;
        ArrayList<String> moduleNamesList;
        TestProcessor testProcessor = new TestProcessor(jBallerinaBackend.jarResolver());
        boolean hasTests = TestUtils.createTestSuitesForProject(project, target, testProcessor, testSuiteMap, moduleNamesList = new ArrayList<String>(), mockClassNames = new ArrayList<String>(), this.isRerunTestExecution, this.report, this.coverage);
        if (hasTests) {
            try {
                TestUtils.writeToTestSuiteJson(testSuiteMap, target.getTestsCachePath());
                return true;
            }
            catch (IOException e) {
                throw LauncherUtils.createLauncherException("error while writing to test suite json file: " + e.getMessage());
            }
        }
        this.out.println("\tNo tests found");
        return false;
    }

    private Path getTestExecutableBasePath(Target target) {
        try {
            return target.getTestExecutableBasePath();
        }
        catch (IOException e) {
            throw LauncherUtils.createLauncherException(e.getMessage());
        }
    }

    private void writeCmdArgsToFile(Path path, Target target, Path testSuiteJsonPath) {
        ArrayList<String> cmdArgs = new ArrayList<String>();
        TestUtils.appendRequiredArgs(cmdArgs, target.path().toString(), TestUtils.getJacocoAgentJarPath(), testSuiteJsonPath.toString(), this.report, this.coverage, this.groupList, this.disableGroupList, this.singleExecTests, this.isRerunTestExecution, this.listGroups, this.cliArgs, false, this.isParallelExecution);
        Path writingPath = path.resolve("mainArgs.txt");
        try (BufferedWriter writer = Files.newBufferedWriter(writingPath, new OpenOption[0]);){
            for (String arg : cmdArgs) {
                writer.write(arg);
                writer.newLine();
            }
        }
        catch (IOException e) {
            throw LauncherUtils.createLauncherException("error while writing to file: " + e.getMessage());
        }
    }

    private Target getTarget(Project project) {
        Target target;
        block5: {
            try {
                if (project.kind().equals((Object)ProjectKind.BUILD_PROJECT)) {
                    target = new Target(project.targetDir());
                    break block5;
                }
                target = new Target(project.targetDir());
                Optional<Path> fileName = Optional.ofNullable(project.sourceRoot().getFileName());
                if (fileName.isPresent()) {
                    target.setOutputPath(target.path().resolve(FileUtils.getFileNameWithoutExtension(fileName.get()) + ".jar"));
                    break block5;
                }
                throw new IllegalStateException("unable to resolve target path");
            }
            catch (IOException e) {
                throw LauncherUtils.createLauncherException("unable to resolve target path:" + e.getMessage());
            }
            catch (ProjectException e) {
                throw LauncherUtils.createLauncherException("unable to create executable:" + e.getMessage());
            }
        }
        return target;
    }
}

