/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.task;

import io.ballerina.cli.cmd.CommandUtil;
import io.ballerina.cli.launcher.LauncherUtils;
import io.ballerina.cli.task.Task;
import io.ballerina.cli.utils.FileUtils;
import io.ballerina.projects.BuildTool;
import io.ballerina.projects.BuildToolResolution;
import io.ballerina.projects.Diagnostics;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageConfig;
import io.ballerina.projects.PackageManifest;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.buildtools.CodeGeneratorTool;
import io.ballerina.projects.buildtools.ToolContext;
import io.ballerina.projects.internal.PackageConfigCreator;
import io.ballerina.projects.internal.PackageDiagnostic;
import io.ballerina.projects.internal.ProjectDiagnosticErrorCode;
import io.ballerina.projects.util.BalToolsUtil;
import io.ballerina.projects.util.BuildToolsUtil;
import io.ballerina.projects.util.CustomURLClassLoader;
import io.ballerina.toml.api.Toml;
import io.ballerina.toml.semantic.diagnostics.TomlDiagnostic;
import io.ballerina.toml.semantic.diagnostics.TomlNodeLocation;
import io.ballerina.toml.validator.schema.Schema;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;

public class RunBuildToolsTask
implements Task {
    private final PrintStream outStream;
    private final List<Diagnostic> diagnostics;
    private final boolean exitWhenFinish;
    private final Map<PackageManifest.Tool.Field, ToolContext> toolContextMap = new HashMap<PackageManifest.Tool.Field, ToolContext>();
    private final boolean skipTask;

    public RunBuildToolsTask(PrintStream out, boolean skipTask, List<Diagnostic> diagnostics) {
        this.skipTask = skipTask;
        this.outStream = out;
        this.diagnostics = diagnostics;
        this.exitWhenFinish = true;
    }

    @Override
    public void execute(Project project) {
        BuildToolResolution buildToolResolution;
        project.setToolContextMap(this.toolContextMap);
        List<Diagnostic> toolManifestDiagnostics = project.currentPackage().manifest().diagnostics().diagnostics().stream().filter(diagnostic -> diagnostic.diagnosticInfo().code().startsWith("BCE53")).toList();
        toolManifestDiagnostics.forEach(this.outStream::println);
        ArrayList<Diagnostic> toolDiagnostics = new ArrayList<Diagnostic>(toolManifestDiagnostics);
        List toolEntries = project.currentPackage().manifest().tools();
        if (toolEntries.isEmpty()) {
            return;
        }
        this.outStream.println("\nExecuting Build Tools" + (this.skipTask ? " (UP-TO-DATE)" : ""));
        if (this.skipTask) {
            return;
        }
        for (PackageManifest.Tool toolEntry2 : toolEntries) {
            ToolContext toolContext = ToolContext.from((PackageManifest.Tool)toolEntry2, (Package)project.currentPackage(), (PrintStream)this.outStream);
            this.toolContextMap.put(toolEntry2.id(), toolContext);
        }
        try {
            buildToolResolution = project.currentPackage().getBuildToolResolution();
        }
        catch (ProjectException e) {
            CommandUtil.printError(this.outStream, e.getMessage(), null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        buildToolResolution.getDiagnosticList().forEach(this.outStream::println);
        toolDiagnostics.addAll(buildToolResolution.getDiagnosticList());
        List resolvedTools = buildToolResolution.getResolvedTools();
        Map<String, ClassLoader> classLoaderMap = this.createToolClassLoader(resolvedTools);
        List<PackageManifest.Tool> resolvedToolEntries = toolEntries.stream().filter(toolEntry -> resolvedTools.stream().anyMatch(tool -> tool.id().value().equals(toolEntry.type().value().split("\\.")[0]))).toList();
        for (PackageManifest.Tool toolEntry3 : resolvedToolEntries) {
            String commandName = toolEntry3.type().value();
            ToolContext toolContext = this.toolContextMap.get(toolEntry3.id());
            ClassLoader toolClassLoader = classLoaderMap.get(commandName.split("\\.")[0]);
            Thread.currentThread().setContextClassLoader(toolClassLoader);
            ServiceLoader<CodeGeneratorTool> toolServiceLoader = ServiceLoader.load(CodeGeneratorTool.class, toolClassLoader);
            Optional targetTool = BuildToolsUtil.getTargetTool((String)commandName, toolServiceLoader);
            if (targetTool.isEmpty()) {
                TomlDiagnostic diagnostic2 = BuildToolsUtil.getBuildToolCommandNotFoundDiagnostic((String)commandName, (TomlNodeLocation)toolEntry3.type().location());
                toolContext.reportDiagnostic((Diagnostic)diagnostic2);
                this.outStream.println(diagnostic2);
                this.printToolSkipWarning(toolEntry3);
                continue;
            }
            Optional cmdNameDiagnostic = BuildToolsUtil.getDiagnosticIfInvalidCommandName((String)commandName, (TomlNodeLocation)toolEntry3.id().location());
            if (cmdNameDiagnostic.isPresent()) {
                toolContext.reportDiagnostic((Diagnostic)cmdNameDiagnostic.get());
                this.outStream.println(cmdNameDiagnostic.get());
                this.printToolSkipWarning(toolEntry3);
                continue;
            }
            boolean hasOptionErrors = false;
            try {
                hasOptionErrors = this.validateOptionsToml(toolEntry3.optionsToml(), toolEntry3.type(), toolClassLoader);
                if (hasOptionErrors) {
                    DiagnosticInfo diagnosticInfo = new DiagnosticInfo(ProjectDiagnosticErrorCode.TOOL_OPTIONS_VALIDATION_FAILED.diagnosticId(), ProjectDiagnosticErrorCode.TOOL_OPTIONS_VALIDATION_FAILED.messageKey(), DiagnosticSeverity.ERROR);
                    TomlNodeLocation location = toolEntry3.optionsToml() == null ? toolEntry3.type().location() : toolEntry3.optionsTable().location();
                    TomlDiagnostic diagnostic3 = new TomlDiagnostic(location, diagnosticInfo, toolEntry3.type().value());
                    toolContext.reportDiagnostic((Diagnostic)diagnostic3);
                }
            }
            catch (IOException e) {
                this.outStream.printf("WARNING: Validation of tool options of '%s' for '%s' is skipped due to: %s%n", commandName, toolEntry3.id().value(), e.getMessage());
            }
            if (toolEntry3.hasErrorDiagnostic() || hasOptionErrors) {
                this.printToolSkipWarning(toolEntry3);
                continue;
            }
            try {
                this.outStream.printf("\t%s(%s)%n", toolEntry3.type().value(), toolEntry3.id().value());
                ((CodeGeneratorTool)targetTool.get()).execute(toolContext);
                toolDiagnostics.addAll(toolContext.diagnostics());
                for (Diagnostic d2 : toolContext.diagnostics()) {
                    if (d2.toString().contains("(1:1,1:1)")) {
                        this.outStream.println(new PackageDiagnostic(d2.diagnosticInfo(), toolContext.toolId()));
                        continue;
                    }
                    this.outStream.println(new PackageDiagnostic(d2.diagnosticInfo(), d2.location()));
                }
            }
            catch (Exception e) {
                throw LauncherUtils.createLauncherException(e.getMessage());
            }
        }
        boolean hasErrors = toolDiagnostics.stream().anyMatch(d -> d.diagnosticInfo().severity().equals((Object)DiagnosticSeverity.ERROR));
        if (hasErrors) {
            throw LauncherUtils.createLauncherException("build tool execution contains errors");
        }
        this.diagnostics.addAll(buildToolResolution.getDiagnosticList());
        Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
        this.reloadProject(project);
        this.outStream.println();
    }

    private boolean validateOptionsToml(Toml optionsToml, PackageManifest.Tool.Field toolType, ClassLoader toolClassLoader) throws IOException {
        if (optionsToml == null) {
            return this.validateEmptyOptionsToml(toolType, toolClassLoader);
        }
        FileUtils.validateToml(optionsToml, toolType.value(), toolClassLoader);
        optionsToml.diagnostics().forEach(this.outStream::println);
        return !Diagnostics.filterErrors((Collection)optionsToml.diagnostics()).isEmpty();
    }

    private boolean validateEmptyOptionsToml(PackageManifest.Tool.Field toolType, ClassLoader toolClassLoader) throws IOException {
        Schema schema = Schema.from((String)FileUtils.readSchema(toolType.value(), toolClassLoader));
        List requiredFields = schema.required();
        if (!requiredFields.isEmpty()) {
            for (String field : requiredFields) {
                String message = "missing required optional field '" + field + "'";
                DiagnosticInfo diagnosticInfo = new DiagnosticInfo(ProjectDiagnosticErrorCode.MISSING_TOOL_PROPERTIES_IN_BALLERINA_TOML.diagnosticId(), ProjectDiagnosticErrorCode.MISSING_TOOL_PROPERTIES_IN_BALLERINA_TOML.messageKey(), DiagnosticSeverity.ERROR);
                TomlDiagnostic diagnostic = new TomlDiagnostic(toolType.location(), diagnosticInfo, message);
                this.outStream.println(diagnostic);
            }
            return true;
        }
        return false;
    }

    private Map<String, ClassLoader> createToolClassLoader(List<BuildTool> resolvedTools) {
        HashMap<String, ClassLoader> classLoaderMap = new HashMap<String, ClassLoader>();
        for (BuildTool resolvedTool : resolvedTools) {
            List<File> toolJars = RunBuildToolsTask.getToolCommandJarAndDependencyJars(resolvedTool);
            URL[] urls = (URL[])toolJars.stream().map(file -> {
                try {
                    return file.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw LauncherUtils.createUsageExceptionWithHelp("invalid tool jar: " + file.getAbsolutePath());
                }
            }).toArray(URL[]::new);
            ClassLoader systemClassLoader = this.getClass().getClassLoader();
            classLoaderMap.put(resolvedTool.id().value(), (ClassLoader)new CustomURLClassLoader(urls, systemClassLoader));
        }
        return classLoaderMap;
    }

    private void printToolSkipWarning(PackageManifest.Tool toolEntry) {
        this.outStream.printf("WARNING: Execution of '%s:%s' is skipped due to errors%n", toolEntry.type().value(), toolEntry.id() != null ? toolEntry.id().value() : "");
    }

    private void reloadProject(Project project) {
        PackageConfig packageConfig = PackageConfigCreator.createBuildProjectConfig((Path)project.sourceRoot(), (boolean)project.buildOptions().disableSyntaxTree());
        project.addPackage(packageConfig);
    }

    private static List<File> getToolCommandJarAndDependencyJars(BuildTool buildTool) {
        return io.ballerina.cli.launcher.util.BalToolsUtil.findJarFiles(CommandUtil.getPlatformSpecificBalaPath(buildTool.org().value(), buildTool.name().value(), buildTool.version().toString(), BalToolsUtil.getRepoPath((String)buildTool.repository().orElse(null))).resolve("tool").resolve("libs").toFile());
    }
}

