/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.task;

import io.ballerina.cli.launcher.LauncherUtils;
import io.ballerina.cli.task.Task;
import io.ballerina.cli.utils.BuildTime;
import io.ballerina.cli.utils.GraalVMCompatibilityUtils;
import io.ballerina.cli.utils.NativeUtils;
import io.ballerina.cli.utils.TestUtils;
import io.ballerina.projects.JBallerinaBackend;
import io.ballerina.projects.JarResolver;
import io.ballerina.projects.JvmTarget;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleDescriptor;
import io.ballerina.projects.ModuleName;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.internal.model.Target;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.ballerinalang.test.runtime.entity.ModuleStatus;
import org.ballerinalang.test.runtime.entity.PackageTestResult;
import org.ballerinalang.test.runtime.entity.TestReport;
import org.ballerinalang.test.runtime.entity.TestSuite;
import org.ballerinalang.testerina.core.TestProcessor;
import org.wso2.ballerinalang.util.Lists;

public class RunNativeImageTestTask
implements Task {
    private static final String WIN_EXEC_EXT = "exe";
    private final PrintStream out;
    private String groupList;
    private String disableGroupList;
    private boolean report;
    private boolean coverage;
    private final boolean isRerunTestExecution;
    private String singleExecTests;
    private final boolean listGroups;
    private final boolean isParallelExecution;
    TestReport testReport;

    public RunNativeImageTestTask(PrintStream out, boolean rerunTests, String groupList, String disableGroupList, String testList, String includes, String coverageFormat, Map<String, Module> modules, boolean listGroups, boolean isParallelExecution, TestReport testReport) {
        this.out = out;
        this.isRerunTestExecution = rerunTests;
        if (disableGroupList != null) {
            this.disableGroupList = disableGroupList;
        } else if (groupList != null) {
            this.groupList = groupList;
        }
        if (testList != null) {
            this.singleExecTests = testList;
        }
        this.listGroups = listGroups;
        this.isParallelExecution = isParallelExecution;
        this.testReport = testReport;
    }

    @Override
    public void execute(Project project) {
        Module module;
        Path testsCachePath;
        Target target;
        Path cachesRoot;
        long start = 0L;
        if (project.buildOptions().dumpBuildTime()) {
            start = System.currentTimeMillis();
        }
        this.report = project.buildOptions().testReport();
        this.coverage = project.buildOptions().codeCoverage();
        try {
            if (project.kind() == ProjectKind.BUILD_PROJECT) {
                cachesRoot = project.sourceRoot();
                target = new Target(project.targetDir());
            } else {
                cachesRoot = Files.createTempDirectory("ballerina-test-cache" + System.nanoTime(), new FileAttribute[0]);
                target = new Target(cachesRoot);
            }
            testsCachePath = target.getTestsCachePath();
        }
        catch (IOException e) {
            throw LauncherUtils.createLauncherException("error while creating target directory: ", e);
        }
        boolean hasTests = false;
        PackageCompilation packageCompilation = project.currentPackage().getCompilation();
        JBallerinaBackend jBallerinaBackend = JBallerinaBackend.from((PackageCompilation)packageCompilation, (JvmTarget)JvmTarget.JAVA_21);
        JarResolver jarResolver = jBallerinaBackend.jarResolver();
        TestProcessor testProcessor = new TestProcessor(jarResolver);
        ArrayList<HashMap> testSuiteMapEntries = new ArrayList<HashMap>();
        boolean isMockFunctionExist = false;
        for (Object moduleDescriptor : project.currentPackage().moduleDependencyGraph().toTopologicallySortedList()) {
            HashMap<String, TestSuite> hashMap = new HashMap<String, TestSuite>();
            module = project.currentPackage().module(moduleDescriptor.name());
            ModuleName moduleName = module.moduleName();
            TestSuite suite = testProcessor.testSuite(module).orElse(null);
            if (suite == null) continue;
            if (!hasTests) {
                hasTests = true;
            }
            if (!this.isRerunTestExecution) {
                TestUtils.clearFailedTestsJson(target.path());
            }
            if (project.kind() == ProjectKind.SINGLE_FILE_PROJECT) {
                suite.setSourceFileName(project.sourceRoot().getFileName().toString());
            }
            suite.setReportRequired(this.report);
            if (!isMockFunctionExist) {
                isMockFunctionExist = !suite.getMockFunctionNamesMap().isEmpty();
            }
            String resolvedModuleName = module.isDefaultModule() ? moduleName.toString() : module.moduleName().moduleNamePart();
            hashMap.put(resolvedModuleName, suite);
            testSuiteMapEntries.add(hashMap);
        }
        if (!hasTests) {
            this.out.println("\tNo tests found");
            if (this.report) {
                PackageTestResult packageTestResult = new PackageTestResult();
                packageTestResult.setProjectName(project.currentPackage().packageName().toString());
                for (ModuleDescriptor moduleDescriptor : project.currentPackage().moduleDependencyGraph().toTopologicallySortedList()) {
                    module = project.currentPackage().module(moduleDescriptor.name());
                    ModuleStatus moduleStatus = new ModuleStatus();
                    String moduleName2 = module.moduleName().toString();
                    if (!moduleName2.equals(project.currentPackage().packageName().toString())) {
                        moduleName2 = ModuleName.from((PackageName)project.currentPackage().packageName(), (String)module.moduleName().moduleNamePart()).toString();
                    }
                    moduleStatus.setName(moduleName2);
                    packageTestResult.addModuleStatus(moduleStatus);
                }
                this.testReport.addPackage(packageTestResult);
                try {
                    TestUtils.generateTesterinaReports(project, packageTestResult);
                }
                catch (IOException e) {
                    throw LauncherUtils.createLauncherException("error occurred while generating test report:", e);
                }
            }
        }
        if (!isMockFunctionExist && !testSuiteMapEntries.isEmpty()) {
            HashMap testSuiteMap = (HashMap)testSuiteMapEntries.remove(0);
            while (!testSuiteMapEntries.isEmpty()) {
                testSuiteMap.putAll((Map)testSuiteMapEntries.remove(0));
            }
            testSuiteMapEntries.add(testSuiteMap);
        }
        int accumulatedTestResult = 0;
        for (Map map : testSuiteMapEntries) {
            try {
                Path nativeConfigPath = target.getNativeConfigPath();
                NativeUtils.createReflectConfig(nativeConfigPath, project.currentPackage(), map);
            }
            catch (IOException e) {
                throw LauncherUtils.createLauncherException("error while generating the necessary graalvm reflection config ", e);
            }
            if (map.size() == 1) {
                TestSuite testSuite = map.values().toArray(new TestSuite[0])[0];
                String string = testSuite.getPackageID();
                try {
                    NativeUtils.modifyJarForFunctionMock(testSuite, target, string);
                }
                catch (IOException e) {
                    throw LauncherUtils.createLauncherException("error occurred while running tests", e);
                }
            }
            for (Map.Entry entry : map.entrySet()) {
                TestSuite testSuite = (TestSuite)entry.getValue();
                if (testSuite.getMockFunctionNamesMap().isEmpty()) continue;
                testSuite.removeAllMockFunctions();
            }
            TestUtils.writeToTestSuiteJson(map, testsCachePath);
            try {
                int testResult;
                String string = GraalVMCompatibilityUtils.getAllWarnings(project.currentPackage(), jBallerinaBackend.targetPlatform().code(), true);
                if (!string.isEmpty()) {
                    this.out.println(string);
                }
                if ((testResult = this.runTestSuiteWithNativeImage(project.currentPackage(), target, map)) != 0) {
                    accumulatedTestResult = testResult;
                }
                if (!this.report) continue;
                PackageTestResult packageTestResult = new PackageTestResult();
                packageTestResult.setProjectName(project.currentPackage().packageName().toString());
                for (Map.Entry entry : map.entrySet()) {
                    String moduleName3 = (String)entry.getKey();
                    ModuleStatus moduleStatus = TestUtils.loadModuleStatusFromFile(testsCachePath.resolve(moduleName3).resolve("module_status.json"));
                    if (moduleStatus == null) continue;
                    if (!moduleName3.equals(project.currentPackage().packageName().toString())) {
                        moduleName3 = ModuleName.from((PackageName)project.currentPackage().packageName(), (String)moduleName3).toString();
                        moduleStatus.setName(moduleName3);
                    }
                    packageTestResult.addModuleStatus(moduleStatus);
                }
                try {
                    TestUtils.generateTesterinaReports(project, packageTestResult);
                }
                catch (IOException e) {
                    TestUtils.cleanTempCache(project, cachesRoot);
                    throw LauncherUtils.createLauncherException("error occurred while generating test report:", e);
                }
            }
            catch (IOException iOException) {
                TestUtils.cleanTempCache(project, cachesRoot);
                throw LauncherUtils.createLauncherException("error occurred while running tests: ", iOException);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        if (accumulatedTestResult != 0) {
            TestUtils.cleanTempCache(project, cachesRoot);
            throw LauncherUtils.createLauncherException("there are test failures");
        }
        TestUtils.cleanTempCache(project, cachesRoot);
        if (project.buildOptions().dumpBuildTime()) {
            BuildTime.getInstance().testingExecutionDuration = System.currentTimeMillis() - start;
        }
    }

    private int runTestSuiteWithNativeImage(Package currentPackage, Target target, Map<String, TestSuite> testSuiteMap) throws IOException, InterruptedException {
        String packageName = currentPackage.packageName().toString();
        String classPath = NativeUtils.getClassPath(testSuiteMap);
        String jacocoAgentJarPath = "";
        Object nativeImageCommand = System.getenv("GRAALVM_HOME");
        try {
            if (nativeImageCommand == null) {
                throw new ProjectException("GraalVM installation directory not found. Set GRAALVM_HOME as an environment variable\nHINT: To install GraalVM, follow the link: https://ballerina.io/learn/build-the-executable-locally/#configure-graalvm");
            }
            File commandExecutable = Path.of((String)(nativeImageCommand = (String)nativeImageCommand + File.separator + "bin" + File.separator + (NativeUtils.OS.contains("win") ? "native-image.cmd" : "native-image")), new String[0]).toFile();
            if (!commandExecutable.exists()) {
                throw new ProjectException("Cannot find '" + commandExecutable.getName() + "' in the GRAALVM_HOME/bin directory. Install it using: gu install native-image");
            }
        }
        catch (ProjectException e) {
            throw LauncherUtils.createLauncherException(e.getMessage());
        }
        ArrayList<Object> cmdArgs = new ArrayList<Object>();
        ArrayList<Object> nativeArgs = new ArrayList<Object>();
        String graalVMBuildOptions = currentPackage.project().buildOptions().graalVMBuildOptions();
        nativeArgs.add(graalVMBuildOptions);
        cmdArgs.add(nativeImageCommand);
        Path nativeConfigPath = target.getNativeConfigPath();
        Path nativeTargetPath = target.getNativePath();
        cmdArgs.add("org.ballerinalang.test.runtime.BTestMain");
        cmdArgs.add("@" + String.valueOf(nativeConfigPath.resolve("native-image-args.txt")));
        nativeArgs.addAll(Lists.of((Object[])new String[]{"-cp", classPath}));
        if (currentPackage.project().kind() == ProjectKind.SINGLE_FILE_PROJECT) {
            packageName = currentPackage.project().sourceRoot().getFileName().toString().replace(".bal", "");
            this.validateResourcesWithinJar(testSuiteMap, packageName);
        } else if (testSuiteMap.size() == 1) {
            packageName = testSuiteMap.values().toArray(new TestSuite[0])[0].getPackageID();
        }
        nativeArgs.add("-o " + NativeUtils.convertWinPathToUnixFormat(NativeUtils.addQuotationMarkToString(nativeTargetPath.toString() + "/" + packageName)));
        nativeArgs.add("-H:+UnlockExperimentalVMOptions");
        nativeArgs.add("-H:ReflectionConfigurationFiles=" + NativeUtils.convertWinPathToUnixFormat(NativeUtils.addQuotationMarkToString(nativeConfigPath.resolve("reflect-config.json").toString())));
        nativeArgs.add("-H:-UnlockExperimentalVMOptions");
        nativeArgs.add("--no-fallback");
        try (FileWriter nativeArgumentWriter = new FileWriter(nativeConfigPath.resolve("native-image-args.txt").toString(), Charset.defaultCharset());){
            nativeArgumentWriter.write(String.join((CharSequence)" ", nativeArgs));
            nativeArgumentWriter.flush();
        }
        catch (IOException e) {
            throw LauncherUtils.createLauncherException("error while generating the necessary graalvm argument file", e);
        }
        ProcessBuilder builder = new ProcessBuilder(new String[0]).redirectErrorStream(true);
        builder.command(cmdArgs.toArray(new String[0]));
        Process process = builder.start();
        StreamGobbler outputGobbler = new StreamGobbler(process.getInputStream(), this.out);
        outputGobbler.start();
        if (process.waitFor() == 0) {
            outputGobbler.join();
            cmdArgs = new ArrayList();
            String generatedImagePath = String.valueOf(nativeTargetPath.resolve(packageName)) + this.getGeneratedImageExtension();
            cmdArgs.add(generatedImagePath);
            cmdArgs.add(Boolean.toString(false));
            cmdArgs.add(target.path().resolve("cache").resolve("tests_cache").resolve("test_suit.json").toString());
            cmdArgs.add(target.path().toString());
            cmdArgs.add(jacocoAgentJarPath);
            cmdArgs.add(Boolean.toString(this.report));
            cmdArgs.add(Boolean.toString(this.coverage));
            cmdArgs.add(this.groupList != null ? this.groupList : "");
            cmdArgs.add(this.disableGroupList != null ? this.disableGroupList : "");
            cmdArgs.add(this.singleExecTests != null ? this.singleExecTests : "");
            cmdArgs.add(Boolean.toString(this.isRerunTestExecution));
            cmdArgs.add(Boolean.toString(this.listGroups));
            cmdArgs.add(Boolean.toString(this.isParallelExecution));
            builder.command(cmdArgs.toArray(new String[0]));
            process = builder.start();
            outputGobbler = new StreamGobbler(process.getInputStream(), this.out);
            outputGobbler.start();
            int exitCode = process.waitFor();
            outputGobbler.join();
            return exitCode;
        }
        return 1;
    }

    private void validateResourcesWithinJar(Map<String, TestSuite> testSuiteMap, String packageName) throws IOException {
        TestSuite testSuite = testSuiteMap.values().toArray(new TestSuite[0])[0];
        List dependencies = testSuite.getTestExecutionDependencies();
        String jarPath = "";
        for (String dependency : dependencies) {
            if (!dependency.contains(packageName + ".jar")) continue;
            jarPath = dependency;
        }
        try (ZipInputStream jarInputStream = new ZipInputStream(new FileInputStream(jarPath));){
            ZipEntry entry;
            boolean isResourceExist = false;
            while ((entry = jarInputStream.getNextEntry()) != null) {
                String path = entry.getName();
                if (path.startsWith("resources/")) {
                    isResourceExist = true;
                }
                jarInputStream.closeEntry();
            }
            if (isResourceExist) {
                throw LauncherUtils.createLauncherException("native image testing is not supported for standalone Ballerina files containing resources");
            }
        }
    }

    private String getGeneratedImageExtension() {
        if (NativeUtils.OS.contains("win")) {
            return ".exe";
        }
        return "";
    }

    private static class StreamGobbler
    extends Thread {
        private final InputStream inputStream;
        private final PrintStream printStream;

        public StreamGobbler(InputStream inputStream, PrintStream printStream) {
            this.inputStream = inputStream;
            this.printStream = printStream;
        }

        @Override
        public void run() {
            try (Scanner sc = new Scanner(this.inputStream, StandardCharsets.UTF_8);){
                while (sc.hasNextLine()) {
                    this.printStream.println(sc.nextLine());
                }
            }
        }
    }
}

