/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import io.ballerina.cli.launcher.LauncherUtils;
import io.ballerina.identifier.Utils;
import io.ballerina.projects.Package;
import io.ballerina.projects.internal.model.Target;
import io.ballerina.runtime.internal.utils.RuntimeUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.ballerinalang.test.runtime.entity.MockFunctionReplaceVisitor;
import org.ballerinalang.test.runtime.entity.TestSuite;
import org.ballerinalang.test.runtime.util.TesterinaUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;

public final class NativeUtils {
    private static final String MODULE_INIT_CLASS_NAME = "$_init";
    private static final String TEST_EXEC_FUNCTION = "__execute__";
    public static final String OS = System.getProperty("os.name").toLowerCase(Locale.getDefault());
    private static final ReflectConfigClassMethod REFLECTION_CONFIG_EXECUTE_METHOD = new ReflectConfigClassMethod("__execute__", new String[]{"io.ballerina.runtime.internal.scheduling.Strand", "io.ballerina.runtime.api.values.BString", "io.ballerina.runtime.api.values.BString", "io.ballerina.runtime.api.values.BString", "io.ballerina.runtime.api.values.BString", "io.ballerina.runtime.api.values.BString", "io.ballerina.runtime.api.values.BString", "io.ballerina.runtime.api.values.BString", "io.ballerina.runtime.api.values.BString", "io.ballerina.runtime.api.values.BString", "io.ballerina.runtime.api.values.BString", "io.ballerina.runtime.api.values.BString"});

    private NativeUtils() {
    }

    public static void createReflectConfig(Path nativeConfigPath, Package currentPackage, Map<String, TestSuite> testSuiteMap) throws IOException {
        String org = currentPackage.packageOrg().toString();
        String version = currentPackage.packageVersion().toString();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        ArrayList<ReflectConfigClass> classList = new ArrayList<ReflectConfigClass>();
        for (Map.Entry<String, TestSuite> entry : testSuiteMap.entrySet()) {
            BufferedReader br;
            Gson gsonRead;
            Map testFileMockedFunctionMapping;
            Path mockedFunctionClassPath;
            File mockedFunctionClassFile;
            String moduleName = entry.getKey();
            TestSuite testSuite = entry.getValue();
            String name = testSuite.getPackageID();
            Map testUtilityFunctions = testSuiteMap.get(moduleName).getTestUtilityFunctions();
            if (testUtilityFunctions.containsKey(TEST_EXEC_FUNCTION)) {
                ReflectConfigClass testTestExecuteGeneratedRefConfClz = new ReflectConfigClass((String)testSuiteMap.get(moduleName).getTestUtilityFunctions().get(TEST_EXEC_FUNCTION));
                testTestExecuteGeneratedRefConfClz.addReflectConfigClassMethod(REFLECTION_CONFIG_EXECUTE_METHOD);
                classList.add(testTestExecuteGeneratedRefConfClz);
                ReflectConfigClass testInitRefConfClz = new ReflectConfigClass(NativeUtils.getQualifiedClassName(org, name, version, MODULE_INIT_CLASS_NAME));
                testInitRefConfClz.addReflectConfigClassMethod(new ReflectConfigClassMethod("main", new String[]{"java.lang.String[]"}));
                testInitRefConfClz.addReflectConfigClassMethod(new ReflectConfigClassMethod("$getTestExecutionState", new String[0]));
                classList.add(testInitRefConfClz);
            }
            if (!testSuiteMap.get(moduleName).getMockFunctionNamesMap().isEmpty()) {
                ReflectConfigClass functionMockingEntryClz = new ReflectConfigClass(NativeUtils.getQualifiedClassName(org, name, version, name.replace(".", "$$$")));
                functionMockingEntryClz.setQueryAllDeclaredMethods(true);
                functionMockingEntryClz.setAllDeclaredFields(true);
                functionMockingEntryClz.setUnsafeAllocated(true);
                classList.add(functionMockingEntryClz);
            }
            if (!(mockedFunctionClassFile = new File((mockedFunctionClassPath = nativeConfigPath.resolve("mocked-func-class-map.json")).toString())).isFile() || (testFileMockedFunctionMapping = (Map)(gsonRead = new Gson()).fromJson((Reader)(br = Files.newBufferedReader(mockedFunctionClassPath, StandardCharsets.UTF_8)), (TypeToken)new TypeToken<Map<String, String[]>>(){})).isEmpty()) continue;
            for (Map.Entry testFileMockedFunctionMappingEntry : testFileMockedFunctionMapping.entrySet()) {
                String moduleNameForTestClz = ((String)testFileMockedFunctionMappingEntry.getKey()).split("/")[0];
                if (!moduleNameForTestClz.equals(name)) continue;
                String testFile = ((String)testFileMockedFunctionMappingEntry.getKey()).split("/")[1];
                String[] mockedFunctions = (String[])testFileMockedFunctionMappingEntry.getValue();
                String qualifiedTestClassName = NativeUtils.getQualifiedClassName(org, moduleNameForTestClz, version, testFile);
                Class<?> qualifiedTestClass = NativeUtils.validateClassExistance(testSuite, qualifiedTestClassName);
                if (qualifiedTestClass == null) continue;
                HashSet<String> methodSet = NativeUtils.getMethodSet(qualifiedTestClass);
                ReflectConfigClass originalTestFileRefConfClz = new ReflectConfigClass(qualifiedTestClassName);
                for (String mockedFunction : mockedFunctions) {
                    if (!methodSet.contains(mockedFunction)) continue;
                    originalTestFileRefConfClz.addReflectConfigClassMethod(new ReflectConfigClassMethod(mockedFunction));
                    originalTestFileRefConfClz.setUnsafeAllocated(true);
                    originalTestFileRefConfClz.setAllDeclaredFields(true);
                    originalTestFileRefConfClz.setQueryAllDeclaredMethods(true);
                }
                classList.add(originalTestFileRefConfClz);
            }
        }
        HashMap<String, List<String>> mockFunctionClassMapping = new HashMap<String, List<String>>();
        NativeUtils.extractMockFunctionClassMapping(testSuiteMap, mockFunctionClassMapping);
        for (Map.Entry entry : mockFunctionClassMapping.entrySet()) {
            String mockFunctionClass = (String)entry.getKey();
            ReflectConfigClass originalBalFileRefConfClz = new ReflectConfigClass(mockFunctionClass);
            for (String originalMockFunction : (List)entry.getValue()) {
                originalBalFileRefConfClz.addReflectConfigClassMethod(new ReflectConfigClassMethod(originalMockFunction));
            }
            originalBalFileRefConfClz.setQueryAllDeclaredMethods(true);
            originalBalFileRefConfClz.setQueryAllDeclaredMethods(true);
            originalBalFileRefConfClz.setUnsafeAllocated(true);
            classList.add(originalBalFileRefConfClz);
        }
        ReflectConfigClass runtimeEntityTestSuiteRefConfClz = new ReflectConfigClass("org.ballerinalang.test.runtime.entity.TestSuite");
        runtimeEntityTestSuiteRefConfClz.setAllDeclaredFields(true);
        runtimeEntityTestSuiteRefConfClz.setUnsafeAllocated(true);
        classList.add(runtimeEntityTestSuiteRefConfClz);
        try (FileWriter fileWriter = new FileWriter(nativeConfigPath.resolve("reflect-config.json").toString(), Charset.defaultCharset());){
            gson.toJson(classList, (Appendable)fileWriter);
            ((Writer)fileWriter).flush();
        }
    }

    private static HashSet<String> getMethodSet(Class<?> qualifiedTestClass) {
        HashSet<String> methodSet = new HashSet<String>();
        for (Method method : qualifiedTestClass.getMethods()) {
            methodSet.add(method.getName());
        }
        return methodSet;
    }

    private static Class<?> validateClassExistance(TestSuite testSuite, String qualifiedTestClassName) {
        Class<?> classToCheck;
        List testExecutionDependencies = testSuite.getTestExecutionDependencies();
        ClassLoader classLoader = AccessController.doPrivileged(() -> new URLClassLoader(NativeUtils.getURLList(testExecutionDependencies).toArray(new URL[0]), ClassLoader.getSystemClassLoader()));
        try {
            classToCheck = classLoader.loadClass(qualifiedTestClassName);
        }
        catch (Throwable e) {
            return null;
        }
        return classToCheck;
    }

    public static List<URL> getURLList(List<String> jarFilePaths) {
        ArrayList<URL> urlList = new ArrayList<URL>();
        for (String jarFilePath : jarFilePaths) {
            try {
                urlList.add(Path.of(jarFilePath, new String[0]).toUri().toURL());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Failed to create classloader with all jar files", e);
            }
        }
        return urlList;
    }

    private static void extractMockFunctionClassMapping(Map<String, TestSuite> testSuiteMap, Map<String, List<String>> mockFunctionClassMapping) {
        for (Map.Entry<String, TestSuite> testSuiteEntry : testSuiteMap.entrySet()) {
            TestSuite suite = testSuiteEntry.getValue();
            for (Map.Entry mockFunctionEntry : suite.getMockFunctionNamesMap().entrySet()) {
                String functionToMock;
                String functionToMockClassName;
                String key = (String)mockFunctionEntry.getKey();
                if (key.indexOf("~") == -1) {
                    functionToMockClassName = key.substring(0, key.indexOf("#"));
                    functionToMock = key.substring(key.indexOf("#") + 1);
                } else if (key.indexOf("#") == -1) {
                    functionToMockClassName = key.substring(0, key.indexOf("~"));
                    functionToMock = key.substring(key.indexOf("~") + 1);
                } else if (key.indexOf("#") < key.indexOf("~")) {
                    functionToMockClassName = key.substring(0, key.indexOf("#"));
                    functionToMock = key.substring(key.indexOf("#") + 1);
                } else {
                    functionToMockClassName = key.substring(0, key.indexOf("~"));
                    functionToMock = key.substring(key.indexOf("~") + 1);
                }
                functionToMock = functionToMock.replace("\\", "");
                mockFunctionClassMapping.computeIfAbsent(functionToMockClassName, k -> new ArrayList()).add("$ORIG_" + functionToMock);
            }
        }
    }

    public static void createResourceConfig(Path nativeConfigPath) throws IOException {
        ResourceConfigClass resourceConfigClass = new ResourceConfigClass();
        resourceConfigClass.addResourceConfigBundle(new ResourceConfigBundles("MessagesBundle", new String[]{""}));
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try (FileWriter writer = new FileWriter(nativeConfigPath.resolve("resource-config.json").toString(), Charset.defaultCharset());){
            gson.toJson((Object)resourceConfigClass, (Appendable)writer);
            ((Writer)writer).flush();
        }
    }

    private static String getQualifiedClassName(String orgName, String packageName, String version, String className) {
        if (!".".equals(packageName)) {
            className = Utils.encodeNonFunctionIdentifier((String)packageName) + "$test." + RuntimeUtils.getMajorVersion((String)version) + "." + (String)className;
        }
        if (!"$anon".equals(orgName)) {
            className = Utils.encodeNonFunctionIdentifier((String)orgName) + "." + (String)className;
        }
        return className;
    }

    public static void modifyJarForFunctionMock(TestSuite testSuite, Target target, String moduleName) throws IOException {
        String testJarName = testSuite.getOrgName() + "-" + moduleName + "-" + testSuite.getVersion() + "-testable.jar";
        String testJarPath = "";
        Object modifiedJarName = "";
        String mainJarPath = "";
        Object mainJarName = "";
        if (testSuite.getMockFunctionNamesMap().isEmpty()) {
            return;
        }
        List testExecutionDependencies = testSuite.getTestExecutionDependencies();
        ArrayList<String> classLoaderUrlList = new ArrayList<String>();
        for (String testExecutionDependency : testExecutionDependencies) {
            if (!testExecutionDependency.endsWith(testJarName)) continue;
            testJarPath = testExecutionDependency;
            classLoaderUrlList.add(testJarPath);
        }
        ClassLoader classLoader = null;
        HashMap<String, List<String>> classVsMockFunctionsMap = new HashMap<String, List<String>>();
        Map mockFunctionMap = testSuite.getMockFunctionNamesMap();
        NativeUtils.populateClassNameVsFunctionToMockMap(classVsMockFunctionsMap, mockFunctionMap);
        HashMap mainJarVsClassMapping = new HashMap();
        for (Map.Entry classVsMockFunctionsEntry : classVsMockFunctionsMap.entrySet()) {
            String className = (String)classVsMockFunctionsEntry.getKey();
            String[] classMetaData = className.split("\\.");
            mainJarName = classMetaData[0] + "-" + classMetaData[1].replace("&0046", ".") + "-" + classMetaData[2];
            if (mainJarVsClassMapping.containsKey(mainJarName)) {
                ((List)mainJarVsClassMapping.get(mainJarName)).add(className);
                continue;
            }
            ArrayList<Object> classList = new ArrayList<Object>();
            classList.add(className);
            mainJarVsClassMapping.put(mainJarName, classList);
        }
        for (Map.Entry mainJarVsClassEntry : mainJarVsClassMapping.entrySet()) {
            Object testExecutionDependency2;
            mainJarName = (String)mainJarVsClassEntry.getKey();
            modifiedJarName = (String)mainJarName + "-mod.jar";
            for (Object testExecutionDependency2 : testExecutionDependencies) {
                if (!((String)testExecutionDependency2).contains((CharSequence)mainJarName) || ((String)testExecutionDependency2).contains("testable")) continue;
                mainJarPath = testExecutionDependency2;
                break;
            }
            classLoaderUrlList.add(mainJarPath);
            classLoader = AccessController.doPrivileged(() -> new URLClassLoader(NativeUtils.getURLList(classLoaderUrlList).toArray(new URL[0]), ClassLoader.getSystemClassLoader()));
            HashMap<String, byte[]> modifiedClassDef = new HashMap<String, byte[]>();
            testExecutionDependency2 = ((List)mainJarVsClassEntry.getValue()).iterator();
            while (testExecutionDependency2.hasNext()) {
                String className = (String)testExecutionDependency2.next();
                List functionNamesList = (List)classVsMockFunctionsMap.get(className);
                byte[] classFile = NativeUtils.getModifiedClassBytes(className, functionNamesList, testSuite, classLoader);
                modifiedClassDef.put(className, classFile);
            }
            Map<String, byte[]> unmodifiedFiles = NativeUtils.loadUnmodifiedFilesWithinJar(mainJarPath);
            String modifiedJarPath = target.path().resolve("cache").resolve(testSuite.getOrgName()).resolve(testSuite.getPackageName()).resolve(testSuite.getVersion()).resolve("java21").toString() + "/" + (String)modifiedJarName;
            NativeUtils.dumpJar(modifiedClassDef, unmodifiedFiles, modifiedJarPath);
            testExecutionDependencies.remove(mainJarPath);
            testExecutionDependencies.add(modifiedJarPath);
        }
    }

    private static void dumpJar(Map<String, byte[]> modifiedClassDefs, Map<String, byte[]> unmodifiedFiles, String modifiedJarPath) throws IOException {
        ArrayList<CallSite> duplicatePaths = new ArrayList<CallSite>();
        try (JarOutputStream jarOutputStream = new JarOutputStream(new FileOutputStream(modifiedJarPath));){
            String entry;
            for (Map.Entry<String, byte[]> modifiedClassDef : modifiedClassDefs.entrySet()) {
                if (modifiedClassDef.getValue().length <= 0) continue;
                entry = modifiedClassDef.getKey();
                String path = entry.replace(".", "/") + ".class";
                duplicatePaths.add((CallSite)((Object)path));
                jarOutputStream.putNextEntry(new ZipEntry(path));
                jarOutputStream.write(modifiedClassDefs.get(entry));
                jarOutputStream.closeEntry();
            }
            for (Map.Entry<String, byte[]> unmodifiedFile : unmodifiedFiles.entrySet()) {
                entry = unmodifiedFile.getKey();
                if (duplicatePaths.contains(entry)) continue;
                jarOutputStream.putNextEntry(new ZipEntry(entry));
                jarOutputStream.write(unmodifiedFiles.get(entry));
                jarOutputStream.closeEntry();
            }
        }
    }

    private static Map<String, byte[]> loadUnmodifiedFilesWithinJar(String mainJarPath) throws IOException {
        ZipEntry entry;
        HashMap<String, byte[]> unmodifiedFiles = new HashMap<String, byte[]>();
        File jarFile = new File(mainJarPath);
        ZipInputStream jarInputStream = new ZipInputStream(new FileInputStream(jarFile));
        while ((entry = jarInputStream.getNextEntry()) != null) {
            String path = entry.getName();
            if (!entry.isDirectory()) {
                byte[] bytes = IOUtils.toByteArray((InputStream)jarInputStream);
                unmodifiedFiles.put(path, bytes);
            }
            jarInputStream.closeEntry();
        }
        jarInputStream.close();
        return unmodifiedFiles;
    }

    private static void populateClassNameVsFunctionToMockMap(Map<String, List<String>> classVsMockFunctionsMap, Map<String, String> mockFunctionMap) {
        for (Map.Entry<String, String> entry : mockFunctionMap.entrySet()) {
            String functionToMock;
            String functionToMockClassName;
            String key = entry.getKey();
            if (!key.contains("~")) {
                functionToMockClassName = key.substring(0, key.indexOf("#"));
                functionToMock = key.substring(key.indexOf("#"));
            } else if (!key.contains("#")) {
                functionToMockClassName = key.substring(0, key.indexOf("~"));
                functionToMock = key.substring(key.indexOf("~"));
            } else if (key.indexOf("#") < key.indexOf("~")) {
                functionToMockClassName = key.substring(0, key.indexOf("#"));
                functionToMock = key.substring(key.indexOf("#"));
            } else {
                functionToMockClassName = key.substring(0, key.indexOf("~"));
                functionToMock = key.substring(key.indexOf("~"));
            }
            functionToMock = functionToMock.replace("\\", "");
            classVsMockFunctionsMap.computeIfAbsent(functionToMockClassName, k -> new ArrayList()).add(functionToMock);
        }
    }

    private static byte[] getModifiedClassBytes(String className, List<String> functionNames, TestSuite suite, ClassLoader classLoader) {
        Class<?> functionToMockClass;
        try {
            functionToMockClass = classLoader.loadClass(className);
        }
        catch (Throwable e) {
            throw LauncherUtils.createLauncherException("failed to load class: " + className);
        }
        byte[] classFile = new byte[]{};
        boolean readFromBytes = false;
        for (Method method1 : functionToMockClass.getDeclaredMethods()) {
            Class<?> mockFunctionClass;
            if (functionNames.contains("#" + method1.getName())) {
                Class<?> testClass;
                String desugaredMockFunctionName = "$MOCK_" + method1.getName();
                String testClassName = TesterinaUtils.getQualifiedClassName((String)suite.getOrgName(), (String)suite.getTestPackageID(), (String)suite.getVersion(), (String)suite.getPackageID().replace(".", "$$$"));
                try {
                    testClass = classLoader.loadClass(testClassName);
                }
                catch (Throwable e) {
                    throw LauncherUtils.createLauncherException("failed to prepare " + testClassName + " for mocking reason:" + e.getMessage());
                }
                for (Method method2 : testClass.getDeclaredMethods()) {
                    if (!method2.getName().equals(desugaredMockFunctionName)) continue;
                    if (!readFromBytes) {
                        classFile = NativeUtils.replaceMethodBody(method1, method2);
                        readFromBytes = true;
                        continue;
                    }
                    classFile = NativeUtils.replaceMethodBody(classFile, method1, method2);
                }
                continue;
            }
            if (!functionNames.contains("~" + method1.getName())) continue;
            String key = className + "~" + method1.getName();
            String mockFunctionName = (String)suite.getMockFunctionNamesMap().get(key);
            if (mockFunctionName == null) continue;
            String mockFunctionClassName = (String)suite.getTestUtilityFunctions().get(mockFunctionName);
            try {
                mockFunctionClass = classLoader.loadClass(mockFunctionClassName);
            }
            catch (ClassNotFoundException e) {
                throw LauncherUtils.createLauncherException("failed to prepare " + mockFunctionClassName + " for mocking reason:" + e.getMessage());
            }
            for (Method method2 : mockFunctionClass.getDeclaredMethods()) {
                if (!method2.getName().equals(mockFunctionName)) continue;
                if (!readFromBytes) {
                    classFile = NativeUtils.replaceMethodBody(method1, method2);
                    readFromBytes = true;
                    continue;
                }
                classFile = NativeUtils.replaceMethodBody(classFile, method1, method2);
            }
        }
        return classFile;
    }

    private static byte[] replaceMethodBody(Method method, Method mockMethod) {
        ClassReader cr;
        Class<?> clazz = method.getDeclaringClass();
        try (InputStream ins = clazz.getResourceAsStream(clazz.getSimpleName() + ".class");){
            cr = new ClassReader(Objects.requireNonNull(ins));
        }
        catch (IOException e) {
            throw LauncherUtils.createLauncherException("failed to get the class reader object for the class " + clazz.getSimpleName());
        }
        ClassWriter cw = new ClassWriter(cr, 3);
        MockFunctionReplaceVisitor cv = new MockFunctionReplaceVisitor(458752, cw, method.getName(), Type.getMethodDescriptor((Method)method), mockMethod);
        cr.accept((ClassVisitor)cv, 0);
        return cw.toByteArray();
    }

    private static byte[] replaceMethodBody(byte[] classFile, Method method, Method mockMethod) {
        ClassReader cr = new ClassReader(classFile);
        ClassWriter cw = new ClassWriter(cr, 3);
        MockFunctionReplaceVisitor cv = new MockFunctionReplaceVisitor(458752, cw, method.getName(), Type.getMethodDescriptor((Method)method), mockMethod);
        cr.accept((ClassVisitor)cv, 0);
        return cw.toByteArray();
    }

    public static String getClassPath(Map<String, TestSuite> testSuiteMap) {
        List<Object> dependencies = new ArrayList();
        for (Map.Entry<String, TestSuite> testSuiteEntry : testSuiteMap.entrySet()) {
            dependencies.addAll(testSuiteEntry.getValue().getTestExecutionDependencies());
        }
        dependencies = dependencies.stream().distinct().map(x -> NativeUtils.convertWinPathToUnixFormat(NativeUtils.addQuotationMarkToString(x))).toList();
        StringJoiner classPath = new StringJoiner(File.pathSeparator);
        dependencies.forEach(classPath::add);
        return classPath.toString();
    }

    public static String addQuotationMarkToString(String word) {
        return "\"" + word + "\"";
    }

    public static String convertWinPathToUnixFormat(String path) {
        if (OS.contains("win")) {
            path = path.replace("\\", "/");
        }
        return path;
    }

    private static class ReflectConfigClass {
        private final String name;
        private List<ReflectConfigClassMethod> methods;
        private boolean allDeclaredFields;
        private boolean unsafeAllocated;
        private boolean queryAllDeclaredMethods;

        public ReflectConfigClass(String name) {
            this.name = name;
        }

        public void addReflectConfigClassMethod(ReflectConfigClassMethod method) {
            if (this.methods == null) {
                this.methods = new ArrayList<ReflectConfigClassMethod>();
            }
            this.methods.add(method);
        }

        public void setAllDeclaredFields(boolean allDeclaredFields) {
            this.allDeclaredFields = allDeclaredFields;
        }

        public void setUnsafeAllocated(boolean unsafeAllocated) {
            this.unsafeAllocated = unsafeAllocated;
        }

        public void setQueryAllDeclaredMethods(boolean queryAllDeclaredMethods) {
            this.queryAllDeclaredMethods = queryAllDeclaredMethods;
        }

        public String getName() {
            return this.name;
        }

        public boolean isAllDeclaredFields() {
            return this.allDeclaredFields;
        }

        public boolean isUnsafeAllocated() {
            return this.unsafeAllocated;
        }

        public boolean isQueryAllDeclaredMethods() {
            return this.queryAllDeclaredMethods;
        }
    }

    private static class ReflectConfigClassMethod {
        private final String name;
        private String[] parameterTypes;

        public ReflectConfigClassMethod(String name) {
            this.name = name;
        }

        public ReflectConfigClassMethod(String name, String[] parameterTypes) {
            this.name = name;
            this.parameterTypes = parameterTypes;
        }

        public String getName() {
            return this.name;
        }

        public String[] getParameterTypes() {
            return this.parameterTypes;
        }
    }

    private static class ResourceConfigClass {
        private final List<ResourceConfigBundles> bundles = new ArrayList<ResourceConfigBundles>();

        public void addResourceConfigBundle(ResourceConfigBundles resourceConfigBundles) {
            this.bundles.add(resourceConfigBundles);
        }
    }

    private static class ResourceConfigBundles {
        private final String name;
        private final String[] locales;

        private ResourceConfigBundles(String name, String[] locales) {
            this.name = name;
            this.locales = locales;
        }

        public String getName() {
            return this.name;
        }

        public String[] getLocales() {
            return this.locales;
        }
    }
}

