/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.mcp;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.Parameter;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.ReferenceType;
import io.ballerina.runtime.api.types.RemoteMethodType;
import io.ballerina.runtime.api.types.ServiceType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.stdlib.mcp.ModuleUtils;
import java.util.List;
import java.util.Optional;

public final class McpServiceMethodHelper {
    private static final String TOOLS_FIELD_NAME = "tools";
    private static final String NAME_FIELD_NAME = "name";
    private static final String DESCRIPTION_FIELD_NAME = "description";
    private static final String SCHEMA_FIELD_NAME = "schema";
    private static final String INPUT_SCHEMA_FIELD_NAME = "inputSchema";
    private static final String ARGUMENTS_FIELD_NAME = "arguments";
    private static final String CONTENT_FIELD_NAME = "content";
    private static final String TYPE_FIELD_NAME = "type";
    private static final String TEXT_FIELD_NAME = "text";
    private static final String ANNOTATION_MCP_TOOL = "Tool";
    private static final String TYPE_TEXT_CONTENT = "TextContent";
    private static final String TEXT_VALUE_NAME = "text";
    private static final String MCP_SERVICE_FIELD = "mcpService";
    private static final String MCP_PACKAGE_NAME = "mcp";
    private static final String SESSION_TYPE_NAME = "Session";

    private McpServiceMethodHelper() {
    }

    public static Object invokeOnListTools(Environment env, BObject mcpService) {
        return env.getRuntime().callMethod(mcpService, "onListTools", null, new Object[0]);
    }

    public static Object invokeOnCallTool(Environment env, BObject mcpService, BMap<?, ?> params, Object session) {
        return env.getRuntime().callMethod(mcpService, "onCallTool", null, new Object[]{params, session});
    }

    public static Object listToolsForRemoteFunctions(BObject mcpService, BTypedesc typed) {
        RecordType resultRecordType = (RecordType)typed.getDescribingType();
        BMap result = ValueCreator.createRecordValue((RecordType)resultRecordType);
        ArrayType toolsArrayType = (ArrayType)((Field)resultRecordType.getFields().get(TOOLS_FIELD_NAME)).getFieldType();
        BArray tools = ValueCreator.createArrayValue((ArrayType)toolsArrayType);
        for (RemoteMethodType remoteMethod : McpServiceMethodHelper.getRemoteMethods(mcpService)) {
            remoteMethod.getAnnotations().entrySet().stream().filter(e -> ((BString)e.getKey()).getValue().contains(ANNOTATION_MCP_TOOL)).findFirst().ifPresent(annotation -> tools.append(McpServiceMethodHelper.createToolRecord(toolsArrayType, remoteMethod, (BMap)annotation.getValue())));
        }
        result.put((Object)StringUtils.fromString((String)TOOLS_FIELD_NAME), (Object)tools);
        return result;
    }

    public static Object callToolForRemoteFunctions(Environment env, BObject mcpService, BMap<?, ?> params, Object session, BTypedesc typed) {
        BString toolName = (BString)params.get((Object)StringUtils.fromString((String)NAME_FIELD_NAME));
        Optional<RemoteMethodType> method = McpServiceMethodHelper.getRemoteMethods(mcpService).stream().filter(rmt -> rmt.getName().equals(toolName.getValue())).findFirst();
        if (method.isEmpty()) {
            return ModuleUtils.createError("RemoteMethodType with name '" + toolName.getValue() + "' not found");
        }
        Object[] args = McpServiceMethodHelper.buildArgsForMethod(method.get(), (BMap)params.get((Object)StringUtils.fromString((String)ARGUMENTS_FIELD_NAME)), session);
        Object result = env.getRuntime().callMethod(mcpService, toolName.getValue(), null, args);
        return McpServiceMethodHelper.createCallToolResult(typed, result);
    }

    public static Object addMcpServiceToDispatcher(BObject dispatcherService, BObject mcpService) {
        try {
            dispatcherService.addNativeData(MCP_SERVICE_FIELD, (Object)mcpService);
            return null;
        }
        catch (Exception e) {
            return ModuleUtils.createError("Failed to add MCP service to dispatcher: " + e.getMessage());
        }
    }

    public static Object getMcpServiceFromDispatcher(BObject dispatcherService) {
        try {
            Object mcpService = dispatcherService.getNativeData(MCP_SERVICE_FIELD);
            if (mcpService == null) {
                return ModuleUtils.createError("MCP service not found in dispatcher");
            }
            return mcpService;
        }
        catch (Exception e) {
            return ModuleUtils.createError("Failed to get MCP service from dispatcher: " + e.getMessage());
        }
    }

    private static List<RemoteMethodType> getRemoteMethods(BObject mcpService) {
        ServiceType serviceType = (ServiceType)mcpService.getOriginalType();
        return List.of(serviceType.getRemoteMethods());
    }

    private static BMap<BString, Object> createToolRecord(ArrayType toolsArrayType, RemoteMethodType remoteMethod, BMap<?, ?> annotationValue) {
        RecordType toolRecordType = (RecordType)((ReferenceType)toolsArrayType.getElementType()).getReferredType();
        BMap tool = ValueCreator.createRecordValue((RecordType)toolRecordType);
        tool.put((Object)StringUtils.fromString((String)NAME_FIELD_NAME), (Object)StringUtils.fromString((String)remoteMethod.getName()));
        tool.put((Object)StringUtils.fromString((String)DESCRIPTION_FIELD_NAME), annotationValue.get((Object)StringUtils.fromString((String)DESCRIPTION_FIELD_NAME)));
        tool.put((Object)StringUtils.fromString((String)INPUT_SCHEMA_FIELD_NAME), annotationValue.get((Object)StringUtils.fromString((String)SCHEMA_FIELD_NAME)));
        return tool;
    }

    private static Object[] buildArgsForMethod(RemoteMethodType method, BMap<?, ?> arguments, Object session) {
        List<Parameter> params = List.of(method.getParameters());
        Object[] args = new Object[params.size()];
        for (int i = 0; i < params.size(); ++i) {
            Parameter param = params.get(i);
            if (McpServiceMethodHelper.isSessionParameter(param)) {
                args[i] = session;
                continue;
            }
            String paramName = param.name;
            args[i] = arguments == null ? null : arguments.get((Object)StringUtils.fromString((String)paramName));
        }
        return args;
    }

    private static boolean isSessionParameter(Parameter param) {
        Type paramType = param.type;
        return MCP_PACKAGE_NAME.equals(paramType.getPackage().getName()) && SESSION_TYPE_NAME.equals(paramType.getName());
    }

    private static Object createCallToolResult(BTypedesc typed, Object result) {
        RecordType resultRecordType = (RecordType)typed.getDescribingType();
        BMap callToolResult = ValueCreator.createRecordValue((RecordType)resultRecordType);
        ArrayType contentArrayType = (ArrayType)((Field)resultRecordType.getFields().get(CONTENT_FIELD_NAME)).getFieldType();
        BArray contentArray = ValueCreator.createArrayValue((ArrayType)contentArrayType);
        UnionType contentUnionType = (UnionType)contentArrayType.getElementType();
        Optional<Type> textContentTypeOpt = contentUnionType.getMemberTypes().stream().filter(type -> TYPE_TEXT_CONTENT.equals(type.getName())).findFirst();
        if (textContentTypeOpt.isEmpty()) {
            return ModuleUtils.createError("No member type named 'TextContent' found in content union type.");
        }
        RecordType textContentRecordType = (RecordType)((ReferenceType)textContentTypeOpt.get()).getReferredType();
        BMap textContent = ValueCreator.createRecordValue((RecordType)textContentRecordType);
        textContent.put((Object)StringUtils.fromString((String)TYPE_FIELD_NAME), (Object)StringUtils.fromString((String)"text"));
        textContent.put((Object)StringUtils.fromString((String)"text"), (Object)StringUtils.fromString((String)(result == null ? "" : result.toString())));
        contentArray.append((Object)textContent);
        callToolResult.put((Object)StringUtils.fromString((String)CONTENT_FIELD_NAME), (Object)contentArray);
        return callToolResult;
    }
}

