/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.mcp;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BStream;
import io.ballerina.stdlib.mcp.ModuleUtils;

public final class SseEventStreamHelper {
    private static final String SSE_STREAM_NATIVE_KEY = "sseStream";

    private SseEventStreamHelper() {
    }

    public static void attachSseStream(BObject object, BStream sseStream) {
        object.addNativeData(SSE_STREAM_NATIVE_KEY, (Object)sseStream);
    }

    public static Object getNextSseEvent(Environment env, BObject object) {
        BStream sseStream = (BStream)object.getNativeData(SSE_STREAM_NATIVE_KEY);
        if (sseStream == null) {
            return ModuleUtils.createError("Unable to obtain elements from stream. SSE stream not found.");
        }
        BObject iteratorObject = sseStream.getIteratorObj();
        return env.getRuntime().callMethod(iteratorObject, "next", null, new Object[0]);
    }

    public static Object closeSseEventStream(Environment env, BObject object) {
        BStream sseStream = (BStream)object.getNativeData(SSE_STREAM_NATIVE_KEY);
        if (sseStream == null) {
            return ModuleUtils.createError("Unable to obtain elements from stream. SSE stream not found.");
        }
        BObject iteratorObject = sseStream.getIteratorObj();
        return env.getRuntime().callMethod(iteratorObject, "close", null, new Object[0]);
    }
}

