/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.ldap;

import com.unboundid.ldap.sdk.AsyncRequestID;
import com.unboundid.ldap.sdk.AsyncSearchResultListener;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultReference;
import io.ballerina.lib.ldap.Client;
import io.ballerina.lib.ldap.Utils;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class CustomSearchResultListener
implements AsyncSearchResultListener {
    private static final long serialVersionUID = 1L;
    private transient CompletableFuture<Object> future;
    private transient List<BMap<BString, Object>> references;
    private transient List<BMap<BString, Object>> entries;
    private final String dN;

    public CustomSearchResultListener(CompletableFuture<Object> future, String dN) {
        this.dN = dN;
        this.future = future;
        this.references = new ArrayList<BMap<BString, Object>>();
        this.entries = new ArrayList<BMap<BString, Object>>();
    }

    public void searchResultReceived(AsyncRequestID requestID, SearchResult searchResult) {
        if (!searchResult.getResultCode().equals((Object)ResultCode.SUCCESS)) {
            LDAPException ldapException = new LDAPException((LDAPResult)searchResult);
            this.future.complete(Utils.createError(ldapException.getMessage(), ldapException));
            return;
        }
        if (this.entries.isEmpty()) {
            String errorMessage = String.format("Entry is not found for DN: '%s'", this.dN);
            LDAPException ldapException = new LDAPException(ResultCode.OTHER, errorMessage);
            this.future.complete(Utils.createError(ldapException.getMessage(), ldapException));
            return;
        }
        this.future.complete(Utils.createSearchResultRecord(searchResult, this.references, this.entries));
    }

    public void searchEntryReturned(SearchResultEntry searchEntry) {
        BMap<BString, Object> entry = Utils.createEntryRecord();
        for (Attribute attribute : searchEntry.getAttributes()) {
            Client.processAttribute(attribute, entry);
        }
        this.entries.add(entry);
    }

    public void searchReferenceReturned(SearchResultReference searchReference) {
        this.references.add(Utils.createSearchReferenceRecord(searchReference));
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.references = new ArrayList<BMap<BString, Object>>();
        this.entries = new ArrayList<BMap<BString, Object>>();
    }

    public void setFuture(CompletableFuture<Object> future) {
        this.future = future;
    }
}

