/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.ldap;

import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldap.sdk.SearchScope;
import io.ballerina.lib.ldap.ModuleUtils;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public final class Utils {
    public static final String ERROR_TYPE = "Error";
    public static final String ERROR_DETAILS = "ErrorDetails";
    public static final String SEARCH_RESULT = "SearchResult";
    public static final String SEARCH_REFERENCE = "SearchReference";
    public static final String SEARCH_REFERENCES = "searchReferences";
    public static final String ENTRIES = "entries";
    public static final String ENTRY = "Entry";
    public static final String RESULT_STATUS = "resultCode";
    public static final String MESSAGE_ID = "messageId";
    public static final String URIS = "uris";
    public static final String CONTROLS = "controls";
    public static final String CONTROL = "Control";
    public static final String OID = "oid";
    public static final String IS_CRITICAL = "isCritical";
    public static final String VALUE = "value";
    public static final String ENTRY_NOT_FOUND = "Entry is not found for DN: '%s'";
    public static final String SID_REVISION_ERROR = "objectSid revision must be 1";
    public static final String OBJECT_GUID_LENGTH_ERROR = "objectGUID must be a 16-byte array";
    public static final String LDAP_CONNECTION_CLOSED_ERROR = "LDAP Connection has been closed";

    private Utils() {
    }

    public static BError createError(String message, Throwable throwable) {
        BError cause = Objects.isNull(throwable) ? null : ErrorCreator.createError((Throwable)throwable);
        return ErrorCreator.createError((Module)ModuleUtils.getModule(), (String)ERROR_TYPE, (BString)StringUtils.fromString((String)message), (BError)cause, null);
    }

    public static BError createError(String message, LDAPException ldapException) {
        BError cause = Objects.isNull(ldapException) ? null : ErrorCreator.createError((Throwable)ldapException);
        BMap<BString, Object> errorDetails = Utils.getErrorDetails(Objects.requireNonNull(ldapException));
        return ErrorCreator.createError((Module)ModuleUtils.getModule(), (String)ERROR_TYPE, (BString)StringUtils.fromString((String)message), (BError)cause, errorDetails);
    }

    private static BMap<BString, Object> getErrorDetails(LDAPException ldapException) {
        String resultCode = ldapException.getResultCode().getName().toUpperCase(Locale.ROOT);
        return ValueCreator.createRecordValue((Module)ModuleUtils.getModule(), (String)ERROR_DETAILS, Map.of(RESULT_STATUS, resultCode));
    }

    public static BMap<BString, Object> createSearchResultRecord(SearchResult searchResult, List<BMap<BString, Object>> references, List<BMap<BString, Object>> entries) {
        String resultCode = searchResult.getResultCode().getName().toUpperCase(Locale.ROOT);
        HashMap<String, String> valueMap = new HashMap<String, String>();
        valueMap.put(RESULT_STATUS, resultCode);
        if (!references.isEmpty()) {
            ArrayType referenceType = TypeCreator.createArrayType((Type)TypeUtils.getType(references.get(0)));
            valueMap.put(SEARCH_REFERENCES, (String)ValueCreator.createArrayValue((Object[])references.toArray(), (ArrayType)referenceType));
        }
        if (!entries.isEmpty()) {
            ArrayType entriesType = TypeCreator.createArrayType((Type)TypeUtils.getType(entries.get(0)));
            valueMap.put(ENTRIES, (String)ValueCreator.createArrayValue((Object[])entries.toArray(), (ArrayType)entriesType));
        }
        return ValueCreator.createRecordValue((Module)ModuleUtils.getModule(), (String)SEARCH_RESULT, valueMap);
    }

    public static BMap<BString, Object> createEntryRecord() {
        return ValueCreator.createRecordValue((Module)ModuleUtils.getModule(), (String)ENTRY, (BMap)null);
    }

    public static BMap<BString, Object> createSearchReferenceRecord(SearchResultReference searchResultReference) {
        int messageId = searchResultReference.getMessageID();
        String[] uris = searchResultReference.getReferralURLs();
        ArrayList<BMap<BString, Object>> controls = new ArrayList<BMap<BString, Object>>();
        ArrayType controlArrayType = null;
        for (Control control : searchResultReference.getControls()) {
            controlArrayType = TypeCreator.createArrayType((Type)TypeUtils.getType((Object)control));
            controls.add(Utils.createControlRecord(control));
        }
        BArray referralUris = ValueCreator.createArrayValue((BString[])Utils.convertToBStringArray(uris));
        if (controlArrayType != null) {
            BArray controlElements = ValueCreator.createArrayValue((Object[])controls.toArray(), (ArrayType)controlArrayType);
            return ValueCreator.createRecordValue((Module)ModuleUtils.getModule(), (String)SEARCH_REFERENCE, Map.of(MESSAGE_ID, messageId, URIS, referralUris, CONTROLS, controlElements));
        }
        return ValueCreator.createRecordValue((Module)ModuleUtils.getModule(), (String)SEARCH_REFERENCE, Map.of(MESSAGE_ID, messageId, URIS, referralUris));
    }

    public static BMap<BString, Object> createControlRecord(Control control) {
        String oid = control.getOID();
        boolean isCritical = control.isCritical();
        String value = control.getValue().stringValue();
        return ValueCreator.createRecordValue((Module)ModuleUtils.getModule(), (String)CONTROL, Map.of(OID, oid, IS_CRITICAL, isCritical, VALUE, value));
    }

    public static BString[] convertToBStringArray(String[] stringArray) {
        BString[] bStringArray = new BString[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            bStringArray[i] = StringUtils.fromString((String)stringArray[i]);
        }
        return bStringArray;
    }

    public static String[] convertToStringArray(Object[] objectArray) {
        if (Objects.isNull(objectArray)) {
            return new String[0];
        }
        return (String[])Arrays.stream(objectArray).filter(Objects::nonNull).map(Object::toString).toArray(String[]::new);
    }

    public static BArray convertToBArray(Object[] objectArray) {
        if (Objects.isNull(objectArray)) {
            return ValueCreator.createArrayValue((BString[])new BString[0]);
        }
        BString[] array = (BString[])Arrays.stream(objectArray).filter(Objects::nonNull).map(object -> StringUtils.fromString((String)object.toString())).toArray(BString[]::new);
        return ValueCreator.createArrayValue((BString[])array);
    }

    public static SearchScope getSearchScope(BString scope) {
        return switch (scope.getValue()) {
            case "SUB" -> SearchScope.SUB;
            case "ONE" -> SearchScope.ONE;
            case "BASE" -> SearchScope.BASE;
            case "SUBORDINATE_SUBTREE" -> SearchScope.SUBORDINATE_SUBTREE;
            default -> throw new IllegalArgumentException("Invalid scope value: " + scope.getValue());
        };
    }

    public static String convertObjectSidToString(byte[] objectSid) {
        int i;
        if (objectSid[0] != 1) {
            throw new IllegalArgumentException(SID_REVISION_ERROR);
        }
        StringBuilder stringSidBuilder = new StringBuilder("S-1-");
        int subAuthorityCount = objectSid[1] & 0xFF;
        long identifierAuthority = 0L;
        int offset = 2;
        int size = 6;
        for (i = 0; i < size; ++i) {
            identifierAuthority |= (long)(objectSid[offset + i] & 0xFF) << 8 * (size - 1 - i);
        }
        if ((double)identifierAuthority < Math.pow(2.0, 32.0)) {
            stringSidBuilder.append(identifierAuthority);
        } else {
            stringSidBuilder.append("0x").append(Long.toHexString(identifierAuthority).toUpperCase(Locale.ROOT));
        }
        offset = 8;
        size = 4;
        i = 0;
        while (i < subAuthorityCount) {
            long subAuthority = 0L;
            for (int j = 0; j < size; ++j) {
                subAuthority |= (long)(objectSid[offset + j] & 0xFF) << 8 * j;
            }
            stringSidBuilder.append("-").append(subAuthority);
            ++i;
            offset += size;
        }
        return stringSidBuilder.toString();
    }

    public static String convertObjectGUIDToString(byte[] objectGUID) {
        if (Objects.isNull(objectGUID) || objectGUID.length != 16) {
            throw new IllegalArgumentException(OBJECT_GUID_LENGTH_ERROR);
        }
        return String.format("%02x%02x%02x%02x-%02x%02x-%02x%02x-%02x%02x-%02x%02x%02x%02x%02x%02x", objectGUID[3], objectGUID[2], objectGUID[1], objectGUID[0], objectGUID[5], objectGUID[4], objectGUID[7], objectGUID[6], objectGUID[8], objectGUID[9], objectGUID[10], objectGUID[11], objectGUID[12], objectGUID[13], objectGUID[14], objectGUID[15]);
    }
}

