/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.validator;

import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.openapi.validator.ValidatorUtils;
import io.ballerina.openapi.validator.error.CompilationError;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.lang.invoke.CallSite;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class TypeValidatorUtils {
    public static void validateRecordType(Schema<?> schema, TypeSymbol typeSymbol, String balRecord, SyntaxNodeAnalysisContext context, OpenAPI openAPI, String oasName, DiagnosticSeverity severity) {
        if (typeSymbol instanceof RecordTypeSymbol || typeSymbol instanceof TypeReferenceTypeSymbol) {
            Map<String, Schema> properties = schema.getProperties();
            if (schema instanceof ObjectSchema) {
                properties = schema.getProperties();
            }
            if (typeSymbol instanceof TypeReferenceTypeSymbol) {
                typeSymbol = ((TypeReferenceTypeSymbol)typeSymbol).typeDescriptor();
            }
            RecordTypeSymbol recordTypeSymbol = (RecordTypeSymbol)typeSymbol;
            Map fieldSymbolList = recordTypeSymbol.fieldDescriptors();
            for (Map.Entry<String, RecordFieldSymbol> entry : fieldSymbolList.entrySet()) {
                boolean isFieldExist = false;
                for (Map.Entry<String, Schema> property : properties.entrySet()) {
                    if (!((String)entry.getKey()).trim().equals(property.getKey().trim())) continue;
                    isFieldExist = true;
                    String fieldType = ((RecordFieldSymbol)entry.getValue()).typeDescriptor().signature();
                    if (((RecordFieldSymbol)entry.getValue()).typeDescriptor() instanceof TypeReferenceTypeSymbol) {
                        TypeReferenceTypeSymbol typeRef = (TypeReferenceTypeSymbol)((RecordFieldSymbol)entry.getValue()).typeDescriptor();
                        fieldType = (String)typeRef.definition().getName().get();
                    }
                    Schema schemaValue = property.getValue();
                    String oas = ValidatorUtils.getNumberFormatType(schemaValue);
                    Optional<String> oasType = TypeValidatorUtils.convertOpenAPITypeToBallerina(oas);
                    if (schemaValue instanceof ArraySchema) {
                        ArraySchema arraySchema = (ArraySchema)schemaValue;
                        TypeValidatorUtils.validateArrayTypeMismatch(balRecord, context, entry, arraySchema, severity);
                        break;
                    }
                    if (schemaValue.get$ref() != null) {
                        Schema componentSchema = openAPI.getComponents().getSchemas().get(ValidatorUtils.extractReferenceType(schemaValue.get$ref()).orElse(null));
                        TypeValidatorUtils.validateRecordType(componentSchema, entry.getValue().typeDescriptor(), fieldType, context, openAPI, ValidatorUtils.extractReferenceType(schemaValue.get$ref()).orElse(null), severity);
                        break;
                    }
                    if (schemaValue instanceof ObjectSchema) {
                        return;
                    }
                    if (!oasType.isEmpty() && fieldType.equals(oasType.get())) break;
                    ValidatorUtils.reportDiagnostic(context, CompilationError.TYPE_MISMATCH_FIELD, entry.getValue().getLocation().orElse(null), severity, oas, fieldType, entry.getKey(), balRecord);
                    break;
                }
                if (isFieldExist) continue;
                ValidatorUtils.reportDiagnostic(context, CompilationError.UNDEFINED_BRECORD_FIELD, ((RecordFieldSymbol)entry.getValue()).getLocation().orElse(null), severity, entry.getKey(), balRecord, oasName);
            }
        }
    }

    private static void validateArrayTypeMismatch(String balRecord, SyntaxNodeAnalysisContext context, Map.Entry<String, RecordFieldSymbol> field, ArraySchema arraySchema, DiagnosticSeverity severity) {
        String balFieldType = field.getValue().typeDescriptor().signature();
        Schema<?> arraySchemaItems = arraySchema.getItems();
        String array = "[]";
        StringBuilder arrayBuilder = new StringBuilder();
        arrayBuilder.append(array);
        String oasArrayItems = arraySchema.getItems().getType();
        if (arraySchemaItems instanceof ArraySchema) {
            ArraySchema traverseNestedArraySchema = (ArraySchema)arraySchemaItems;
            arrayBuilder.append(array);
            oasArrayItems = traverseNestedArraySchema.getItems().getType();
            while (traverseNestedArraySchema.getItems() instanceof ArraySchema) {
                Schema<?> traversSchemaNestedArraySchemaType = traverseNestedArraySchema.getItems();
                if (traversSchemaNestedArraySchemaType instanceof ArraySchema) {
                    traverseNestedArraySchema = (ArraySchema)traversSchemaNestedArraySchemaType;
                    arrayBuilder.append(array);
                    continue;
                }
                Optional<String> oasItems = TypeValidatorUtils.convertOpenAPITypeToBallerina(traversSchemaNestedArraySchemaType.getType().trim());
                if (oasItems.isEmpty()) {
                    oasArrayItems = traversSchemaNestedArraySchemaType.getType().trim();
                    continue;
                }
                oasArrayItems = oasItems.get();
            }
        }
        Optional<CallSite> oasType = Optional.of(TypeValidatorUtils.convertOpenAPITypeToBallerina(oasArrayItems).orElse(oasArrayItems) + arrayBuilder.toString());
        String messageOasType = oasArrayItems + arrayBuilder.toString();
        if (!balFieldType.equals(oasType.get())) {
            ValidatorUtils.reportDiagnostic(context, CompilationError.TYPE_MISMATCH_FIELD, field.getValue().getLocation().orElse(null), severity, messageOasType, balFieldType, field.getKey(), balRecord);
        }
    }

    public static Optional<String> convertOpenAPITypeToBallerina(String type) {
        if (type == null) {
            return Optional.empty();
        }
        switch (type) {
            case "integer": {
                return Optional.of("int");
            }
            case "string": {
                return Optional.of("string");
            }
            case "boolean": {
                return Optional.of("boolean");
            }
            case "array": {
                return Optional.of("[]");
            }
            case "object": {
                return Optional.of("record");
            }
            case "double": 
            case "number": {
                return Optional.of("decimal");
            }
            case "float": {
                return Optional.of("float");
            }
        }
        return Optional.empty();
    }

    public static Optional<String> convertBallerinaType(SyntaxKind type) {
        switch (type) {
            case INT_TYPE_DESC: {
                return Optional.of("int");
            }
            case STRING_TYPE_DESC: {
                return Optional.of("string");
            }
            case BOOLEAN_TYPE_DESC: {
                return Optional.of("boolean");
            }
            case ARRAY_TYPE_DESC: {
                return Optional.of("[]");
            }
            case RECORD_TYPE_DESC: {
                return Optional.of("record");
            }
            case DECIMAL_TYPE_DESC: {
                return Optional.of("decimal");
            }
            case FLOAT_TYPE_DESC: {
                return Optional.of("float");
            }
        }
        return Optional.empty();
    }

    public static void validateObjectSchema(ObjectSchema objectSchema, TypeSymbol typeSymbol, SyntaxNodeAnalysisContext context, String balRecord, Location parentLocation, DiagnosticSeverity severity) {
        Location location = typeSymbol.getLocation().isEmpty() ? parentLocation : (Location)typeSymbol.getLocation().get();
        if (typeSymbol instanceof RecordTypeSymbol || typeSymbol instanceof TypeReferenceTypeSymbol) {
            if (typeSymbol instanceof TypeReferenceTypeSymbol) {
                typeSymbol = ((TypeReferenceTypeSymbol)typeSymbol).typeDescriptor();
            }
            RecordTypeSymbol recordTypeSymbol = (RecordTypeSymbol)typeSymbol;
            Map<String, Schema> properties = objectSchema.getProperties();
            Map recordFieldSymbolMap = recordTypeSymbol.fieldDescriptors();
            AtomicInteger numberOfMissingFields = new AtomicInteger();
            properties.forEach((key, value) -> {
                AtomicBoolean isPropertyExist = new AtomicBoolean(false);
                recordFieldSymbolMap.forEach((fieldName, fieldValue) -> {
                    if (key.equals(fieldName.trim())) {
                        isPropertyExist.set(true);
                    }
                });
                if (!isPropertyExist.get()) {
                    numberOfMissingFields.addAndGet(1);
                    ValidatorUtils.reportDiagnostic(context, CompilationError.MISSING_OAS_PROPERTY, location, severity, key, balRecord);
                }
            });
        }
    }
}

