/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.validator.model;

import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.tools.diagnostics.Location;
import java.util.Map;

public class ResourceMethod {
    private final String path;
    private final Location location;
    private final String method;
    private final Map<String, Node> parameters;
    private final RequiredParameterNode body;
    private final Map<String, Node> headers;
    private final ReturnTypeDescriptorNode returnNode;

    public ResourceMethod(ResourceMethodBuilder resourceMethodBuilder) {
        this.path = resourceMethodBuilder.path;
        this.location = resourceMethodBuilder.location;
        this.method = resourceMethodBuilder.method;
        this.parameters = resourceMethodBuilder.parameters;
        this.body = resourceMethodBuilder.body;
        this.headers = resourceMethodBuilder.headers;
        this.returnNode = resourceMethodBuilder.returnNode;
    }

    public String getPath() {
        return this.path;
    }

    public Location getLocation() {
        return this.location;
    }

    public String getMethod() {
        return this.method;
    }

    public Map<String, Node> getParameters() {
        return this.parameters;
    }

    public RequiredParameterNode getBody() {
        return this.body;
    }

    public Map<String, Node> getHeaders() {
        return this.headers;
    }

    public ReturnTypeDescriptorNode getReturnNode() {
        return this.returnNode;
    }

    public static class ResourceMethodBuilder {
        private String path;
        private Location location;
        private String method;
        private Map<String, Node> parameters;
        private RequiredParameterNode body;
        private Map<String, Node> headers;
        private ReturnTypeDescriptorNode returnNode;

        public ResourceMethodBuilder withPath(String path) {
            this.path = path;
            return this;
        }

        public ResourceMethodBuilder withLocation(Location resourcePosition) {
            this.location = resourcePosition;
            return this;
        }

        public ResourceMethodBuilder withMethod(String method) {
            this.method = method;
            return this;
        }

        public ResourceMethodBuilder withParameters(Map<String, Node> parameters) {
            this.parameters = parameters;
            return this;
        }

        public ResourceMethodBuilder withBody(RequiredParameterNode body) {
            this.body = body;
            return this;
        }

        public ResourceMethodBuilder withHeaders(Map<String, Node> headers) {
            this.headers = headers;
            return this;
        }

        public ResourceMethodBuilder withReturnNode(ReturnTypeDescriptorNode returnNode) {
            this.returnNode = returnNode;
            return this;
        }

        public ResourceMethod build() {
            ResourceMethod resourceMethod = new ResourceMethod(this);
            return resourceMethod;
        }
    }
}

