/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.api.constants;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BString;
import java.math.BigDecimal;
import java.math.MathContext;

public final class RuntimeConstants {
    public static final String MAIN_FUNCTION_NAME = "main";
    public static final String MODULE_INIT_CLASS_NAME = "$_init";
    public static final String CONFIGURATION_CLASS_NAME = "$configurationMapper";
    public static final String TEST_PACKAGE_NAME = "$test";
    public static final String FILE_NAME_PERIOD_SEPARATOR = "$$$";
    public static final String BALLERINA_ARGS_INIT_PREFIX = "--";
    public static final int BALLERINA_ARGS_INIT_PREFIX_LENGTH = "--".length();
    public static final String CONFIG_SEPARATOR = "=";
    public static final String CONFIG_FILE_PROPERTY = "b7a.config.file";
    public static final String EMPTY = "";
    public static final String ANON_ORG = "$anon";
    public static final String DOT = ".";
    public static final String ORG_NAME_SEPARATOR = "/";
    public static final String VERSION_SEPARATOR = ":";
    public static final String UNDERSCORE = "_";
    public static final String COLON = ":";
    public static final String BLANG_SRC_FILE_EXT = "bal";
    public static final String BLANG_SRC_FILE_SUFFIX = ".bal";
    public static final String BALLERINA_BUILTIN_PKG_PREFIX = "ballerina";
    public static final String USER_HOME = "user.home";
    public static final String BALLERINA_HOME = "ballerina.home";
    public static final String BALLERINA_PACKAGE_PREFIX = "ballerina/";
    public static final String BALLERINA_MAX_POOL_SIZE_ENV_VAR = "BALLERINA_MAX_POOL_SIZE";
    public static final Module BALLERINA_LANG_ERROR_PKG_ID = new Module("ballerina", "lang.error", "0");
    public static final Module BALLERINA_QUERY_PKG_ID = new Module("ballerina", "lang.query", "0");
    public static final String STRING_LANG_LIB = "lang.string";
    public static final String MAP_LANG_LIB = "lang.map";
    public static final String ARRAY_LANG_LIB = "lang.array";
    public static final String TYPEDESC_LANG_LIB = "lang.typedesc";
    public static final String VALUE_LANG_LIB = "lang.value";
    public static final String XML_LANG_LIB = "lang.xml";
    public static final String FUNCTION_LANG_LIB = "lang.function";
    public static final String FUTURE_LANG_LIB = "lang.future";
    public static final String OBJECT_LANG_LIB = "lang.object";
    public static final String TABLE_LANG_LIB = "lang.table";
    public static final String INT_LANG_LIB = "lang.int";
    public static final String FLOAT_LANG_LIB = "lang.float";
    public static final String DECIMAL_LANG_LIB = "lang.decimal";
    public static final String BOOLEAN_LANG_LIB = "lang.boolean";
    public static final String TRANSACTION_LANG_LIB = "lang.transaction";
    public static final String REGEXP_LANG_LIB = "lang.regexp";
    public static final String DEFAULT_WORKER_NAME = "default";
    public static final String STRING_NULL_VALUE = null;
    public static final BString BSTRING_NULL_VALUE = null;
    public static final BString STRING_EMPTY_VALUE = StringUtils.fromString("");
    public static final Long INT_MAX_VALUE = Long.MAX_VALUE;
    public static final Long INT_MIN_VALUE = Long.MIN_VALUE;
    public static final Integer BBYTE_MIN_VALUE = 0;
    public static final Integer BBYTE_MAX_VALUE = 255;
    public static final Integer SIGNED32_MAX_VALUE = Integer.MAX_VALUE;
    public static final Integer SIGNED32_MIN_VALUE = Integer.MIN_VALUE;
    public static final Integer SIGNED16_MAX_VALUE = Short.MAX_VALUE;
    public static final Integer SIGNED16_MIN_VALUE = Short.MIN_VALUE;
    public static final Integer SIGNED8_MAX_VALUE = 127;
    public static final Integer SIGNED8_MIN_VALUE = -128;
    public static final Long UNSIGNED32_MAX_VALUE = 0xFFFFFFFFL;
    public static final Integer UNSIGNED16_MAX_VALUE = 65535;
    public static final Integer UNSIGNED8_MAX_VALUE = 255;
    public static final double BINT_MAX_VALUE_DOUBLE_RANGE_MAX = 9.223372036854776E18;
    public static final double BINT_MIN_VALUE_DOUBLE_RANGE_MIN = -9.223372036854776E18;
    public static final BigDecimal BINT_MAX_VALUE_BIG_DECIMAL_RANGE_MAX = new BigDecimal("9223372036854775807.5", MathContext.DECIMAL128);
    public static final BigDecimal BINT_MIN_VALUE_BIG_DECIMAL_RANGE_MIN = new BigDecimal("-9223372036854775808.5", MathContext.DECIMAL128);
    public static final String INTERNAL_ERROR_MESSAGE = "ballerina: Oh no, something really went wrong. Bad. Sad.\n\nWe appreciate it if you can report the code that broke Ballerina in\nhttps://github.com/ballerina-platform/ballerina-lang/issues with the\nlog you get below and your sample code.\n\nWe thank you for helping make us better.\n";
    public static final String DEFAULT_LOG_FILE_HANDLER_PATTERN = "org.ballerinalang.logging.handlers.DefaultLogFileHandler.pattern";
    public static final String BALLERINA_VERSION = "ballerina.version";
    public static final String SYSTEM_PROP_BAL_DEBUG = "debug";
    public static final String SYSTEM_PROP_PROFILE_DEBUG = "profilerDebug";
    public static final String GLOBAL_TRANSACTION_ID = "globalTransactionId";
    public static final String TRANSACTION_URL = "transactionUrl";
    public static final String TRANSACTION_INFO = "transactionInfo";
    public static final String STATE_ID = "b7a.state.id";
    public static final String IS_INTERRUPTIBLE = "b7a.state.interruptible";
    public static final String TYPE = "type";
    public static final String DATA = "data";
    public static final String NULL = "null";
    public static final String DEFAULT = "default";
    public static final String DISTRIBUTED_TRANSACTIONS = "b7a.distributed.transactions.enabled";
    public static final String FALSE = "false";
    public static final String CURRENT_TRANSACTION_CONTEXT_PROPERTY = "currentTrxContext";

    private RuntimeConstants() {
    }
}

