/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.api.types.semtype;

import io.ballerina.runtime.api.types.semtype.Atom;
import io.ballerina.runtime.api.types.semtype.Bdd;
import io.ballerina.runtime.api.types.semtype.BddIsEmptyPredicate;
import io.ballerina.runtime.api.types.semtype.Env;
import io.ballerina.runtime.internal.types.semtype.BddMemo;
import io.ballerina.runtime.internal.types.semtype.FunctionAtomicType;
import io.ballerina.runtime.internal.types.semtype.ListAtomicType;
import io.ballerina.runtime.internal.types.semtype.MappingAtomicType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;

public final class Context {
    private final List<BddMemo> memoStack = new ArrayList<BddMemo>();
    public final Env env;
    public final Map<Bdd, BddMemo> listMemo = new WeakHashMap<Bdd, BddMemo>();
    public final Map<Bdd, BddMemo> mappingMemo = new WeakHashMap<Bdd, BddMemo>();
    public final Map<Bdd, BddMemo> functionMemo = new WeakHashMap<Bdd, BddMemo>();

    private Context(Env env) {
        this.env = env;
    }

    public static Context from(Env env) {
        return new Context(env);
    }

    public boolean memoSubtypeIsEmpty(Map<Bdd, BddMemo> memoTable, BddIsEmptyPredicate isEmptyPredicate, Bdd bdd) {
        BddMemo m = memoTable.computeIfAbsent(bdd, ignored -> new BddMemo());
        return m.isEmpty().orElseGet(() -> this.memoSubTypeIsEmptyInner(isEmptyPredicate, bdd, m));
    }

    private boolean memoSubTypeIsEmptyInner(BddIsEmptyPredicate isEmptyPredicate, Bdd bdd, BddMemo m) {
        boolean isLoop;
        m.isEmpty = BddMemo.Status.PROVISIONAL;
        int initStackDepth = this.memoStack.size();
        this.memoStack.add(m);
        boolean isEmpty = isEmptyPredicate.apply(this, bdd);
        boolean bl = isLoop = m.isEmpty == BddMemo.Status.LOOP;
        if (!isEmpty || initStackDepth == 0) {
            this.resetMemoizedValues(initStackDepth, isEmpty, isLoop, m);
        }
        return isEmpty;
    }

    private void resetMemoizedValues(int initStackDepth, boolean isEmpty, boolean isLoop, BddMemo m) {
        for (int i = initStackDepth + 1; i < this.memoStack.size(); ++i) {
            BddMemo.Status memoStatus = this.memoStack.get((int)i).isEmpty;
            if (Objects.requireNonNull(memoStatus) != BddMemo.Status.PROVISIONAL && memoStatus != BddMemo.Status.LOOP && memoStatus != BddMemo.Status.CYCLIC) continue;
            this.memoStack.get((int)i).isEmpty = isEmpty ? BddMemo.Status.TRUE : BddMemo.Status.NULL;
        }
        if (this.memoStack.size() > initStackDepth) {
            this.memoStack.subList(initStackDepth, this.memoStack.size()).clear();
        }
        m.isEmpty = isLoop && isEmpty ? BddMemo.Status.CYCLIC : (isEmpty ? BddMemo.Status.TRUE : BddMemo.Status.FALSE);
    }

    public ListAtomicType listAtomType(Atom atom) {
        return this.env.listAtomType(atom);
    }

    public MappingAtomicType mappingAtomType(Atom atom) {
        return this.env.mappingAtomType(atom);
    }

    public FunctionAtomicType functionAtomicType(Atom atom) {
        return this.env.functionAtomType(atom);
    }
}

