/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.configurable.providers.toml;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.internal.configurable.exceptions.ConfigException;
import io.ballerina.runtime.internal.configurable.providers.toml.ConfigToml;
import io.ballerina.runtime.internal.configurable.providers.toml.TomlProvider;
import io.ballerina.runtime.internal.errors.ErrorCodes;
import io.ballerina.toml.semantic.ast.TomlTableNode;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Set;

public class TomlFileProvider
extends TomlProvider {
    private final Path configPath;

    public TomlFileProvider(Module rootModule, Path configPath, Set<Module> moduleSet) {
        super(rootModule, moduleSet);
        this.configPath = configPath;
    }

    @Override
    public void initialize() {
        this.tomlNode = this.getConfigTomlData(this.configPath);
        super.initialize();
    }

    private TomlTableNode getConfigTomlData(Path configFilePath) {
        if (!Files.exists(configFilePath, new LinkOption[0])) {
            throw new ConfigException(ErrorCodes.CONFIG_TOML_FILE_NOT_FOUND, configFilePath);
        }
        return new ConfigToml(configFilePath).tomlAstNode();
    }
}

