/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.launch;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.internal.configurable.ConfigMap;
import io.ballerina.runtime.internal.configurable.ConfigProvider;
import io.ballerina.runtime.internal.configurable.ConfigResolver;
import io.ballerina.runtime.internal.configurable.VariableKey;
import io.ballerina.runtime.internal.configurable.providers.ConfigDetails;
import io.ballerina.runtime.internal.configurable.providers.cli.CliProvider;
import io.ballerina.runtime.internal.configurable.providers.env.EnvVarProvider;
import io.ballerina.runtime.internal.configurable.providers.toml.TomlConstants;
import io.ballerina.runtime.internal.configurable.providers.toml.TomlContentProvider;
import io.ballerina.runtime.internal.configurable.providers.toml.TomlFileProvider;
import io.ballerina.runtime.internal.diagnostics.RuntimeDiagnosticLog;
import io.ballerina.runtime.internal.troubleshoot.StrandDump;
import io.ballerina.runtime.internal.utils.RuntimeUtils;
import java.io.File;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sun.misc.Signal;

public final class LaunchUtils {
    private static final PrintStream outStream = System.out;

    private LaunchUtils() {
    }

    public static void startTrapSignalHandler() {
        try {
            Signal.handle(new Signal("TRAP"), signal -> outStream.println(StrandDump.getStrandDump()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static void addModuleConfigData(Map<Module, VariableKey[]> configurationData, Module m, VariableKey[] variableKeys) {
        VariableKey[] mergedKeyArray;
        VariableKey[] currKeys = configurationData.get(m);
        if (currKeys == null) {
            mergedKeyArray = variableKeys;
        } else {
            mergedKeyArray = new VariableKey[currKeys.length + variableKeys.length];
            System.arraycopy(currKeys, 0, mergedKeyArray, 0, currKeys.length);
            System.arraycopy(variableKeys, 0, mergedKeyArray, currKeys.length, variableKeys.length);
        }
        configurationData.put(m, mergedKeyArray);
    }

    public static void initConfigurableVariables(Module rootModule, Map<Module, VariableKey[]> configurationData, String[] args, Path[] configFilePaths, String configContent) {
        EnvVarProvider envVarProvider;
        RuntimeDiagnosticLog diagnosticLog = new RuntimeDiagnosticLog();
        CliProvider cliConfigProvider = new CliProvider(rootModule, args);
        LinkedList<ConfigProvider> supportedConfigProviders = new LinkedList<ConfigProvider>();
        Set<Module> moduleSet = configurationData.keySet();
        if (configContent != null) {
            supportedConfigProviders.add(new TomlContentProvider(rootModule, configContent, moduleSet));
        }
        for (int i = configFilePaths.length - 1; i >= 0; --i) {
            supportedConfigProviders.add(new TomlFileProvider(rootModule, configFilePaths[i], moduleSet));
        }
        supportedConfigProviders.add(cliConfigProvider);
        Map<String, String> envVariables = System.getenv();
        if (!envVariables.isEmpty() && (envVarProvider = new EnvVarProvider(rootModule, envVariables)).hasConfigs()) {
            supportedConfigProviders.add(envVarProvider);
        }
        ConfigResolver configResolver = new ConfigResolver(configurationData, diagnosticLog, supportedConfigProviders);
        ConfigMap.setConfigurableMap(configResolver.resolveConfigs());
        if (!diagnosticLog.getDiagnosticList().isEmpty()) {
            RuntimeUtils.handleDiagnosticErrors(diagnosticLog);
        }
    }

    public static ConfigDetails getConfigurationDetails() {
        ArrayList<Path> paths = new ArrayList<Path>();
        Map<String, String> envVars = System.getenv();
        String configContent = LaunchUtils.populateConfigDetails(paths, envVars);
        return new ConfigDetails(paths.toArray(new Path[0]), configContent);
    }

    private static String populateConfigDetails(List<Path> paths, Map<String, String> envVars) {
        if (envVars.containsKey("BAL_CONFIG_FILES")) {
            String[] configPathList;
            for (String pathString : configPathList = envVars.get("BAL_CONFIG_FILES").split(File.pathSeparator)) {
                paths.add(Path.of(pathString, new String[0]));
            }
        } else {
            if (envVars.containsKey("BAL_CONFIG_DATA")) {
                return envVars.get("BAL_CONFIG_DATA");
            }
            if (Files.exists(TomlConstants.DEFAULT_CONFIG_PATH, new LinkOption[0])) {
                paths.add(TomlConstants.DEFAULT_CONFIG_PATH);
            }
        }
        return null;
    }

    public static ConfigDetails getTestConfigPaths(Module module, String pkgName, String sourceRoot) {
        String moduleName = module.getName();
        Path testConfigPath = Path.of(sourceRoot, new String[0]);
        if (!Files.exists(testConfigPath, new LinkOption[0])) {
            testConfigPath = LaunchUtils.getSourceRootInContainer();
        }
        if (!moduleName.equals(pkgName)) {
            testConfigPath = testConfigPath.resolve("modules").resolve(moduleName.substring(moduleName.indexOf(".") + 1));
        }
        if (!Files.exists(testConfigPath = testConfigPath.resolve("tests").resolve("Config.toml"), new LinkOption[0])) {
            return new ConfigDetails(new Path[0], null);
        }
        return new ConfigDetails(new Path[]{testConfigPath}, null);
    }

    private static Path getSourceRootInContainer() {
        return Path.of(RuntimeUtils.USER_DIR, new String[0]);
    }
}

