/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.lock;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.internal.errors.ErrorReasons;
import io.ballerina.runtime.internal.scheduling.Strand;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class BLockStore {
    private final Map<String, ReentrantLock> globalLockMap = new HashMap<String, ReentrantLock>();
    private final ReentrantReadWriteLock storeLock = new ReentrantReadWriteLock();

    public void lock(Strand strand, String lockName) {
        try {
            strand.yield();
            this.getLockFromMap(lockName).lock();
            ++strand.acquiredLockCount;
        }
        finally {
            strand.resume();
        }
    }

    public void lock(Strand strand, ReentrantLock lock) {
        try {
            strand.yield();
            lock.lock();
            ++strand.acquiredLockCount;
        }
        finally {
            strand.resume();
        }
    }

    public void unlock(Strand strand, String lockName) {
        try {
            strand.yield();
            this.getLockFromMap(lockName).unlock();
            --strand.acquiredLockCount;
        }
        finally {
            strand.resume();
        }
    }

    public void unlock(Strand strand, ReentrantLock lock) {
        try {
            strand.yield();
            lock.unlock();
            --strand.acquiredLockCount;
        }
        finally {
            strand.resume();
        }
    }

    public void panicIfInLock(Strand strand) {
        if (strand.acquiredLockCount > 0) {
            throw ErrorCreator.createError(ErrorReasons.ASYNC_CALL_INSIDE_LOCK);
        }
    }

    private ReentrantLock getLockFromMap(String lockName) {
        ReentrantLock lock;
        try {
            this.storeLock.readLock().lock();
            lock = this.globalLockMap.get(lockName);
        }
        finally {
            this.storeLock.readLock().unlock();
        }
        if (lock != null) {
            return lock;
        }
        return this.addLockToMap(lockName);
    }

    private ReentrantLock addLockToMap(String lockName) {
        try {
            this.storeLock.writeLock().lock();
            ReentrantLock reentrantLock = this.globalLockMap.computeIfAbsent(lockName, k -> new ReentrantLock());
            return reentrantLock;
        }
        finally {
            this.storeLock.writeLock().unlock();
        }
    }
}

