/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.query.clauses;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.query.clauses.QueryClause;
import io.ballerina.runtime.internal.query.utils.QueryConstants;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GroupBy
implements QueryClause {
    private final BArray groupingKeys;
    private final BArray nonGroupingKeys;
    private final Environment env;

    private GroupBy(Environment env, BArray groupingKeys, BArray nonGroupingKeys) {
        this.groupingKeys = groupingKeys;
        this.nonGroupingKeys = nonGroupingKeys;
        this.env = env;
    }

    public static GroupBy initGroupByClause(Environment env, BArray groupingKeys, BArray nonGroupingKeys) {
        return new GroupBy(env, groupingKeys, nonGroupingKeys);
    }

    @Override
    public Stream<BMap<BString, Object>> process(Stream<BMap<BString, Object>> inputStream) {
        Map groupedData = inputStream.collect(Collectors.groupingBy(frame -> new GroupKey(this.extractOriginalKey((BMap<BString, Object>)frame)), LinkedHashMap::new, Collectors.toList()));
        return groupedData.values().stream().map(this::aggregateNonGroupingKeys);
    }

    private BMap<BString, Object> aggregateNonGroupingKeys(List<BMap<BString, Object>> frames) {
        BMap<BString, Object> groupedRecord = frames.getFirst();
        for (int i = 0; i < this.nonGroupingKeys.size(); ++i) {
            BString nonGroupingKey = (BString)this.nonGroupingKeys.get(i);
            Object[] values = frames.stream().map(f -> f.get(nonGroupingKey)).toArray();
            BArray valuesArray = ValueCreator.createArrayValue(values, PredefinedTypes.TYPE_ANY_ARRAY);
            groupedRecord.put(nonGroupingKey, valuesArray);
        }
        return groupedRecord;
    }

    private BMap<BString, Object> extractOriginalKey(BMap<BString, Object> frame) {
        BMap<BString, Object> keyMap = ValueCreator.createMapValue(TypeCreator.createMapType(PredefinedTypes.TYPE_ANY));
        for (int i = 0; i < this.groupingKeys.size(); ++i) {
            Object value;
            BString key = (BString)this.groupingKeys.get(i);
            if (frame.containsKey(key)) {
                value = frame.get(key);
            } else {
                BMap nestedRec = (BMap)frame.get(QueryConstants.VALUE_FIELD);
                value = nestedRec.get(key);
            }
            keyMap.put(key, value);
        }
        return keyMap;
    }

    private record GroupKey(BMap<BString, Object> keyMap) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof GroupKey)) {
                return false;
            }
            GroupKey other = (GroupKey)o;
            return TypeChecker.isEqual(this.keyMap, other.keyMap);
        }

        @Override
        public int hashCode() {
            return 1;
        }
    }
}

