/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.query.clauses;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BFunctionPointer;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.query.clauses.QueryClause;
import io.ballerina.runtime.internal.query.utils.QueryConstants;
import io.ballerina.runtime.internal.query.utils.QueryException;
import io.ballerina.runtime.internal.utils.ValueComparisonUtils;
import java.util.Comparator;
import java.util.stream.Stream;

public class OrderBy
implements QueryClause {
    private final BFunctionPointer orderKeyFunction;
    private final Environment env;

    private OrderBy(Environment env, BFunctionPointer orderKeyFunction) {
        this.orderKeyFunction = orderKeyFunction;
        this.env = env;
    }

    public static OrderBy initOrderByClause(Environment env, BFunctionPointer orderKeyFunction) {
        return new OrderBy(env, orderKeyFunction);
    }

    @Override
    public Stream<BMap<BString, Object>> process(Stream<BMap<BString, Object>> inputStream) {
        return inputStream.peek(frame -> {
            Object result = this.orderKeyFunction.call(this.env.getRuntime(), frame);
            if (result instanceof BError) {
                BError error = (BError)result;
                throw new QueryException(error);
            }
        }).sorted(this.getComparator());
    }

    private Comparator<BMap<BString, Object>> getComparator() {
        return (frame1, frame2) -> {
            BArray orderKey1Array = (BArray)frame1.get(QueryConstants.ORDER_KEY);
            BArray orderKey2Array = (BArray)frame2.get(QueryConstants.ORDER_KEY);
            BArray orderDirectionArray = (BArray)frame1.get(QueryConstants.ORDER_DIRECTION);
            int size = orderKey1Array.size();
            for (int i = 0; i < size; ++i) {
                boolean ascending;
                String direction;
                Object key2;
                Object key1 = orderKey1Array.getRefValue(i);
                int comparison = ValueComparisonUtils.compareValues(key1, key2 = orderKey2Array.getRefValue(i), direction = (ascending = orderDirectionArray.getBoolean(i)) ? "ascending" : "descending");
                if (comparison == 0) continue;
                return ascending ? comparison : -comparison;
            }
            return 0;
        };
    }
}

