/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.query.clauses;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BFunctionPointer;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.query.clauses.QueryClause;
import io.ballerina.runtime.internal.query.utils.QueryException;
import java.util.stream.Stream;

public class Where
implements QueryClause {
    private final BFunctionPointer filterFunc;
    private final Environment env;

    private Where(Environment env, BFunctionPointer filterFunc) {
        this.filterFunc = filterFunc;
        this.env = env;
    }

    public static Where initWhereClause(Environment env, BFunctionPointer filterFunc) {
        return new Where(env, filterFunc);
    }

    @Override
    public Stream<BMap<BString, Object>> process(Stream<BMap<BString, Object>> inputStream) {
        return inputStream.filter(frame -> {
            Object result = this.filterFunc.call(this.env.getRuntime(), frame);
            if (result instanceof Boolean) {
                Boolean booleanValue = (Boolean)result;
                return booleanValue;
            }
            throw new QueryException((BError)result);
        });
    }
}

