/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.query.utils;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.constants.RuntimeConstants;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.internal.values.ErrorValue;
import io.ballerina.runtime.internal.values.MapValueImpl;

public class QueryException
extends RuntimeException {
    private final BError error;

    public QueryException(BError error) {
        this.error = this.createDistinctError("Error", RuntimeConstants.BALLERINA_QUERY_PKG_ID, error);
    }

    public QueryException(BError error, boolean isCompleteEarlyError) {
        this.error = this.createDistinctError("CompleteEarlyError", RuntimeConstants.BALLERINA_QUERY_PKG_ID, error);
    }

    public QueryException(String message) {
        this.error = ErrorCreator.createError(StringUtils.fromString(message));
    }

    public BError getError() {
        return this.error;
    }

    public BError createDistinctError(String typeIdName, Module typeIdPkg, BError error) {
        MapValueImpl details = (MapValueImpl)error.getDetails();
        return new ErrorValue(error.getType(), error.getErrorMessage(), error.getCause(), details, typeIdName, typeIdPkg);
    }
}

