/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.types.HandleType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.semtype.BasicTypeBitSet;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.ConcurrentLazySupplier;
import io.ballerina.runtime.internal.types.BSemTypeWrapper;
import io.ballerina.runtime.internal.types.BType;
import io.ballerina.runtime.internal.values.RefValue;

public final class BHandleType
extends BSemTypeWrapper<BHandleTypeImpl>
implements HandleType {
    private static final BasicTypeBitSet BASIC_TYPE = Builder.getHandleType();

    public BHandleType(String typeName, Module pkg) {
        super(new ConcurrentLazySupplier<BHandleTypeImpl>(() -> BHandleTypeImpl.create(typeName, pkg)), typeName, pkg, 50, Builder.getHandleType());
    }

    @Override
    public BasicTypeBitSet getBasicType() {
        return BASIC_TYPE;
    }

    protected static final class BHandleTypeImpl
    extends BType
    implements HandleType {
        private static final BHandleTypeImpl DEFAULT = new BHandleTypeImpl("handle", PredefinedTypes.EMPTY_MODULE);

        private static BHandleTypeImpl create(String typeName, Module pkg) {
            if (typeName.equals("handle") && pkg == PredefinedTypes.EMPTY_MODULE) {
                return DEFAULT;
            }
            return new BHandleTypeImpl(typeName, pkg);
        }

        private BHandleTypeImpl(String typeName, Module pkg) {
            super(typeName, pkg, RefValue.class, false);
        }

        @Override
        public <V> V getZeroValue() {
            return null;
        }

        @Override
        public <V> V getEmptyValue() {
            return null;
        }

        @Override
        public int getTag() {
            return 50;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public BasicTypeBitSet getBasicType() {
            return BASIC_TYPE;
        }
    }
}

