/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types;

import io.ballerina.runtime.api.types.TypeIdentifier;
import io.ballerina.runtime.internal.types.semtype.CacheFactory;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public final class TypeIdSupplier {
    public static final int MAX_RESERVED_ID = 128;
    private static final Map<TypeIdentifier, Integer> cache = CacheFactory.createCachingHashMap();
    private static final AtomicInteger nextNamedId = new AtomicInteger(128);
    private static final AtomicInteger nextReservedId = new AtomicInteger(0);
    private static final AtomicInteger nextAnonId = new AtomicInteger(-2);
    private static final AtomicBoolean reservedIdsExhausted = new AtomicBoolean(false);

    private TypeIdSupplier() {
    }

    public static int namedId(TypeIdentifier id) {
        if (id.avoidCaching()) {
            return TypeIdSupplier.getAnonId();
        }
        Integer cachedId = cache.get(id);
        if (cachedId != null) {
            return cachedId;
        }
        int newId = TypeIdSupplier.getNamedId();
        cache.put(id, newId);
        return newId;
    }

    public static int getReservedId() {
        if (reservedIdsExhausted.get()) {
            return TypeIdSupplier.getNamedId();
        }
        int id = nextReservedId.getAndIncrement();
        if (id >= 128) {
            reservedIdsExhausted.set(true);
            return TypeIdSupplier.getNamedId();
        }
        return id;
    }

    public static int getNamedId() {
        assert (nextNamedId.get() < 0x7FFFFFFE);
        return nextNamedId.getAndIncrement();
    }

    public static int getAnonId() {
        assert (nextAnonId.get() > -2147483647);
        return nextAnonId.getAndDecrement();
    }

    public static IdKind kind(int id) {
        if (id < 0) {
            return IdKind.UNNAMED;
        }
        if (id < 128) {
            return IdKind.RESERVED;
        }
        return IdKind.NAMED;
    }

    public static boolean isAnon(int id) {
        return id < 0;
    }

    public static enum IdKind {
        RESERVED,
        NAMED,
        UNNAMED;

    }
}

