/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types.semtype;

import io.ballerina.runtime.api.types.semtype.Atom;
import io.ballerina.runtime.api.types.semtype.BasicTypeCode;
import io.ballerina.runtime.api.types.semtype.BddNode;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.Definition;
import io.ballerina.runtime.api.types.semtype.Env;
import io.ballerina.runtime.api.types.semtype.RecAtom;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.internal.types.semtype.BFunctionSubType;
import io.ballerina.runtime.internal.types.semtype.FunctionAtomicType;
import io.ballerina.runtime.internal.types.semtype.FunctionQualifiers;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class FunctionDefinition
extends Definition {
    private volatile RecAtom rec;
    private volatile SemType semType;
    private final Lock lock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SemType getSemType(Env env) {
        try {
            RecAtom rec;
            this.lock.lock();
            if (this.semType != null) {
                SemType semType = this.semType;
                return semType;
            }
            this.rec = rec = env.recFunctionAtom();
            SemType semType = this.createSemType(rec);
            return semType;
        }
        finally {
            this.lock.unlock();
        }
    }

    private SemType createSemType(Atom atom) {
        SemType semType;
        BddNode bdd = BddNode.bddAtom(atom);
        this.semType = semType = Builder.basicSubType(BasicTypeCode.BT_FUNCTION, BFunctionSubType.createDelegate(bdd));
        return semType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SemType define(Env env, SemType args, SemType ret, FunctionQualifiers qualifiers) {
        FunctionAtomicType atomicType = new FunctionAtomicType(args, ret, qualifiers.toSemType(env));
        try {
            Atom atom;
            this.lock.lock();
            RecAtom rec = this.rec;
            if (rec != null) {
                atom = rec;
                env.setRecFunctionAtomType(rec, atomicType);
            } else {
                atom = env.functionAtom(atomicType);
            }
            SemType semType = this.createSemType(atom);
            return semType;
        }
        finally {
            this.lock.unlock();
        }
    }
}

