/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.utils;

import io.ballerina.runtime.api.constants.RuntimeConstants;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMapInitialValueEntry;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.errors.ErrorCodes;
import io.ballerina.runtime.internal.errors.ErrorHelper;
import io.ballerina.runtime.internal.errors.ErrorReasons;
import io.ballerina.runtime.internal.values.ErrorValue;
import io.ballerina.runtime.internal.values.MapValueImpl;
import io.ballerina.runtime.internal.values.MappingInitialValueEntry;

public final class ErrorUtils {
    private static final BString ERROR_MESSAGE_FIELD = StringUtils.fromString("message");
    private static final BString ERROR_CAUSE_FIELD = StringUtils.fromString("cause");

    private ErrorUtils() {
    }

    public static ErrorValue createInteropError(Throwable e) {
        BMapInitialValueEntry[] initialValues;
        Throwable cause = e.getCause();
        if (cause instanceof ErrorValue) {
            ErrorValue bError = (ErrorValue)cause;
            return bError;
        }
        String message = e.getMessage();
        if (message != null && cause != null) {
            initialValues = new MappingInitialValueEntry[]{new MappingInitialValueEntry.KeyValueEntry(ERROR_MESSAGE_FIELD, StringUtils.fromString(message)), new MappingInitialValueEntry.KeyValueEntry(ERROR_CAUSE_FIELD, ErrorCreator.createError(StringUtils.fromString(cause.getClass().getName()), StringUtils.fromString(cause.getMessage())))};
        } else if (message != null || cause != null) {
            initialValues = new MappingInitialValueEntry[1];
            initialValues[0] = message != null ? new MappingInitialValueEntry.KeyValueEntry(ERROR_MESSAGE_FIELD, StringUtils.fromString(message)) : new MappingInitialValueEntry.KeyValueEntry(ERROR_CAUSE_FIELD, ErrorCreator.createError(StringUtils.fromString(cause.getClass().getName()), StringUtils.fromString(cause.getMessage())));
        } else {
            initialValues = new MappingInitialValueEntry[]{};
        }
        MapValueImpl<BString, Object> detailMap = new MapValueImpl<BString, Object>(PredefinedTypes.TYPE_ERROR_DETAIL, initialValues);
        return (ErrorValue)ErrorCreator.createError(StringUtils.fromString(e.getClass().getName()), detailMap);
    }

    public static ErrorValue trapError(Throwable throwable) {
        BError error = ErrorCreator.createError(ErrorReasons.STACK_OVERFLOW_ERROR);
        error.setStackTrace(throwable.getStackTrace());
        return (ErrorValue)error;
    }

    public static ErrorValue createCancelledFutureError() {
        return (ErrorValue)ErrorCreator.createError(ErrorReasons.FUTURE_CANCELLED);
    }

    public static BError createIntOverflowError() {
        throw ErrorCreator.createError(ErrorReasons.NUMBER_OVERFLOW, ErrorHelper.getErrorDetails(ErrorCodes.INT_RANGE_OVERFLOW_ERROR, new Object[0]));
    }

    public static BError createIntOverflowError(BString errorMsg) {
        throw ErrorCreator.createError(errorMsg, ErrorHelper.getErrorDetails(ErrorCodes.INT_RANGE_OVERFLOW_ERROR, new Object[0]));
    }

    public static BError createTypeCastError(Object sourceVal, Type targetType) {
        throw ErrorCreator.createError(ErrorReasons.TYPE_CAST_ERROR, ErrorHelper.getErrorDetails(ErrorCodes.TYPE_CAST_ERROR, TypeChecker.getType(sourceVal), targetType));
    }

    public static BError createTypeCastError(Object sourceVal, Type targetType, String detailMessage) {
        return ErrorCreator.createError(ErrorReasons.TYPE_CAST_ERROR, ErrorHelper.getErrorMessage(ErrorCodes.TYPE_CAST_ERROR, TypeChecker.getType(sourceVal), targetType).concat(StringUtils.fromString(": " + detailMessage)));
    }

    public static BError createBToJTypeCastError(Object sourceVal, String targetType) {
        throw ErrorCreator.createError(ErrorReasons.TYPE_CAST_ERROR, ErrorHelper.getErrorDetails(ErrorCodes.J_TYPE_CAST_ERROR, TypeChecker.getType(sourceVal), targetType));
    }

    public static BError createJToBTypeCastError(Object sourceVal, Type targetType) {
        throw ErrorCreator.createError(ErrorHelper.getErrorMessage(ErrorCodes.TYPE_ASSIGNABLE_ERROR, sourceVal, targetType));
    }

    public static BError createJToBTypeCastError(Object value) {
        throw ErrorCreator.createError(ErrorHelper.getErrorMessage(ErrorCodes.J_TYPE_ASSIGNABLE_ERROR, value));
    }

    public static BError createNumericConversionError(Object inputValue, Type targetType) {
        throw ErrorCreator.createError(ErrorReasons.NUMBER_CONVERSION_ERROR, ErrorHelper.getErrorDetails(ErrorCodes.INCOMPATIBLE_SIMPLE_TYPE_CONVERT_OPERATION, TypeChecker.getType(inputValue), inputValue, targetType));
    }

    public static BError createNumericConversionError(Object inputValue, Type inputType, Type targetType) {
        throw ErrorCreator.createError(ErrorReasons.NUMBER_CONVERSION_ERROR, ErrorHelper.getErrorDetails(ErrorCodes.INCOMPATIBLE_SIMPLE_TYPE_CONVERT_OPERATION, inputType, inputValue, targetType));
    }

    public static BError createOperationNotSupportedError(Type lhsType, Type rhsType) {
        throw ErrorCreator.createError(ErrorReasons.OPERATION_NOT_SUPPORTED_ERROR, ErrorHelper.getErrorDetails(ErrorCodes.UNSUPPORTED_COMPARISON_OPERATION, lhsType, rhsType));
    }

    public static BError createUnorderedTypesError(Object lhsValue, Object rhsValue) {
        throw ErrorCreator.createError(ErrorReasons.UNORDERED_TYPES_ERROR, ErrorHelper.getErrorDetails(ErrorCodes.UNORDERED_TYPES_IN_COMPARISON, lhsValue, rhsValue));
    }

    public static BError createConversionError(Object inputValue, Type targetType) {
        return ErrorCreator.createError(ErrorReasons.BALLERINA_PREFIXED_CONVERSION_ERROR, ErrorHelper.getErrorDetails(ErrorCodes.INCOMPATIBLE_CONVERT_OPERATION, TypeChecker.getType(inputValue), targetType));
    }

    public static BError createConversionError(Object inputValue, Type targetType, String detailMessage) {
        return ErrorCreator.createError(ErrorReasons.BALLERINA_PREFIXED_CONVERSION_ERROR, ErrorHelper.getErrorMessage(ErrorCodes.INCOMPATIBLE_CONVERT_OPERATION, TypeChecker.getType(inputValue), targetType).concat(StringUtils.fromString(": " + detailMessage)));
    }

    public static BError createInvalidDecimalError(String value) {
        throw ErrorCreator.createError(ErrorReasons.UNSUPPORTED_DECIMAL_ERROR, ErrorHelper.getErrorDetails(ErrorCodes.UNSUPPORTED_DECIMAL_VALUE, value));
    }

    public static BError createInvalidFractionDigitsError() {
        throw ErrorCreator.createError(ErrorReasons.getModulePrefixedReason("lang.float", "InvalidFractionDigits"), ErrorHelper.getErrorDetails(ErrorCodes.INVALID_FRACTION_DIGITS, new Object[0]));
    }

    public static BError createNoMessageError(String channelKey) {
        String[] splitWorkers = channelKey.split(":")[0].split("->");
        return ErrorCreator.createError(RuntimeConstants.BALLERINA_LANG_ERROR_PKG_ID, "NoMessage", ErrorReasons.NO_MESSAGE_ERROR, null, ErrorHelper.getErrorDetails(ErrorCodes.NO_MESSAGE_ERROR, StringUtils.fromString(splitWorkers[0]), StringUtils.fromString(splitWorkers[1])));
    }

    public static BError createWaitOnSameFutureError() {
        return ErrorCreator.createError(StringUtils.fromString("multiple waits on the same future is not allowed"));
    }

    public static BError createErrorFromThrowable(Throwable t) {
        if (t instanceof BError) {
            BError error = (BError)t;
            return error;
        }
        Throwable throwable = t.getCause();
        if (throwable instanceof BError) {
            BError error = (BError)throwable;
            return error;
        }
        BError error = t instanceof StackOverflowError ? ErrorCreator.createError(ErrorReasons.STACK_OVERFLOW_ERROR) : (t instanceof OutOfMemoryError ? ErrorCreator.createError(ErrorReasons.JAVA_OUT_OF_MEMORY_ERROR, StringUtils.fromString(t.getMessage())) : ErrorCreator.createError(t));
        error.setStackTrace(t.getStackTrace());
        return error;
    }
}

