/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.values;

import io.ballerina.runtime.api.constants.RuntimeConstants;
import io.ballerina.runtime.api.types.XmlNodeType;
import io.ballerina.runtime.api.values.BLink;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BXml;
import io.ballerina.runtime.api.values.BXmlNonElementItem;
import io.ballerina.runtime.internal.errors.ErrorCodes;
import io.ballerina.runtime.internal.errors.ErrorHelper;
import io.ballerina.runtime.internal.values.IteratorValue;
import io.ballerina.runtime.internal.values.MapValue;
import io.ballerina.runtime.internal.values.ReadOnlyUtils;
import io.ballerina.runtime.internal.values.XmlSequence;
import io.ballerina.runtime.internal.values.XmlText;
import io.ballerina.runtime.internal.values.XmlValue;
import io.ballerina.runtime.internal.xml.BallerinaXmlSerializer;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;

public abstract class XmlNonElementItem
extends XmlValue
implements BXmlNonElementItem {
    OMFactory factory = OMAbstractFactory.getOMFactory();

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public String getItemType() {
        return this.getNodeType().value();
    }

    @Override
    public String getElementName() {
        return null;
    }

    @Override
    public BString getAttribute(String localName, String namespace) {
        return null;
    }

    @Override
    public BString getAttribute(String localName, String namespace, String prefix) {
        return null;
    }

    @Override
    public void setAttribute(String localName, String namespace, String prefix, String value) {
    }

    @Override
    public MapValue<BString, BString> getAttributesMap() {
        return null;
    }

    @Override
    public void setAttributes(BMap<BString, BString> attributes) {
    }

    @Override
    public BXml elements() {
        return new XmlSequence();
    }

    @Override
    public BXml elements(String qname) {
        return null;
    }

    @Override
    public XmlValue children() {
        return new XmlSequence();
    }

    @Override
    public XmlValue children(String qname) {
        return new XmlSequence();
    }

    @Override
    public void setChildren(BXml seq) {
    }

    @Override
    @Deprecated
    public void addChildren(BXml seq) {
    }

    @Override
    public BXml strip() {
        return new XmlText("");
    }

    @Override
    public abstract XmlNodeType getNodeType();

    @Override
    public BXml slice(long startIndex, long endIndex) {
        return null;
    }

    @Override
    public BXml descendants(List<String> qnames) {
        return new XmlSequence();
    }

    @Override
    public BXml descendants() {
        return new XmlSequence();
    }

    @Override
    public XmlValue getItem(int index) {
        if (index == 0) {
            return this;
        }
        if (index > 0) {
            return new XmlSequence();
        }
        throw ErrorHelper.getRuntimeException(ErrorCodes.XML_SEQUENCE_INDEX_OUT_OF_RANGE, 1, index);
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public void build() {
    }

    @Override
    public void removeAttribute(String qname) {
    }

    @Override
    @Deprecated
    public void removeChildren(String qname) {
    }

    public abstract OMNode value();

    @Override
    public IteratorValue<?> getIterator() {
        return new IteratorValue<Object>(this){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public Void next() {
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public String stringValue(BLink parent) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            BallerinaXmlSerializer ballerinaXMLSerializer = new BallerinaXmlSerializer(outputStream);
            ballerinaXMLSerializer.write(this);
            ballerinaXMLSerializer.flush();
            String str = new String(outputStream.toByteArray(), StandardCharsets.UTF_8);
            ballerinaXMLSerializer.close();
            return str;
        }
        catch (Throwable t) {
            XmlNonElementItem.handleXmlException("failed to get xml as string: ", t);
            return RuntimeConstants.STRING_NULL_VALUE;
        }
    }

    @Override
    public String informalStringValue(BLink parent) {
        return "`" + this.toString() + "`";
    }

    @Override
    public String expressionStringValue(BLink parent) {
        return "xml`" + this.toString() + "`";
    }

    public String toString() {
        return this.stringValue(null);
    }

    @Override
    public void freezeDirect() {
        this.type = ReadOnlyUtils.setImmutableTypeAndGetEffectiveType(this.type);
        this.typedesc = null;
    }

    public abstract boolean equals(Object var1);

    @Override
    protected void setAttributesOnInitialization(BMap<BString, BString> attributes) {
    }

    @Override
    protected void setAttributeOnInitialization(String localName, String namespace, String prefix, String value) {
    }
}

