/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.profiler.runtime;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class Data {
    protected final String stackKey;
    protected final String stackIndex;
    protected String stackTrace = null;
    public long totalTime;
    private final ConcurrentHashMap<String, Long> startTimes = new ConcurrentHashMap();

    public Data(String stackIndex, String stackKey) {
        this.stackIndex = stackIndex;
        this.stackKey = stackKey;
        this.totalTime = 0L;
    }

    public synchronized void start(String strandId) {
        if (this.startTimes.containsKey(strandId)) {
            return;
        }
        this.startTimes.put(strandId, TimeUnit.MILLISECONDS.convert(System.nanoTime(), TimeUnit.NANOSECONDS));
    }

    public synchronized void stop(String strandId) {
        long elapsed = TimeUnit.MILLISECONDS.convert(System.nanoTime(), TimeUnit.NANOSECONDS) - this.startTimes.remove(strandId);
        this.totalTime += elapsed;
    }

    private String getFormattedStats() {
        return "{\"time\": \"" + this.totalTime + "\", \"stackTrace\": " + this.stackTrace + "}";
    }

    public String toString() {
        return this.getFormattedStats();
    }
}

