/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.profiler.runtime;

import io.ballerina.identifier.Utils;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public final class StackTraceMap {
    private static final AtomicInteger localVarIndex = new AtomicInteger(0);
    private static final ConcurrentHashMap<String, Integer> stackTraceIndexMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, String> indexStackTraceMap = new ConcurrentHashMap();

    private StackTraceMap() {
    }

    static String getStackIndex(String stackElement) {
        Integer stackIndex = stackTraceIndexMap.get(stackElement);
        if (stackIndex != null) {
            return String.valueOf(stackIndex);
        }
        int index = localVarIndex.getAndIncrement();
        stackTraceIndexMap.put(stackElement, index);
        String indexStr = String.valueOf(index);
        indexStackTraceMap.put(indexStr, stackElement);
        return indexStr;
    }

    static String getCallStackString(String stackKey) {
        String[] stackElements = stackKey.split("\\$");
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < stackElements.length - 1; ++i) {
            sb.append("\"").append(StackTraceMap.decodeStackElement(indexStackTraceMap.get(stackElements[i]))).append("\",");
        }
        sb.append("\"").append(StackTraceMap.decodeStackElement(indexStackTraceMap.get(stackElements[stackElements.length - 1]))).append("\"]");
        return sb.toString();
    }

    private static String decodeStackElement(String stackElement) {
        return Utils.decodeIdentifier(stackElement.replace("values.\\$", ""));
    }
}

