/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.semver.checker.comparator;

import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.semver.checker.comparator.Comparator;
import io.ballerina.semver.checker.diff.DiffKind;
import io.ballerina.semver.checker.diff.DiffType;
import io.ballerina.semver.checker.diff.NodeListDiffImpl;
import io.ballerina.semver.checker.diff.SemverImpact;
import io.ballerina.semver.checker.util.SyntaxTreeUtils;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class DumbNodeListComparator<T extends Node>
implements Comparator {
    private final List<T> newNodes;
    private final List<T> oldNodes;
    private final DiffKind nodeKind;

    DumbNodeListComparator(List<T> newNodes, List<T> oldNodes) {
        this(newNodes, oldNodes, null);
    }

    DumbNodeListComparator(NodeList<T> newNodes, NodeList<T> oldNodes) {
        this(newNodes, oldNodes, null);
    }

    DumbNodeListComparator(List<T> newNodes, List<T> oldNodes, DiffKind nodeKind) {
        this.newNodes = newNodes;
        this.oldNodes = oldNodes;
        this.nodeKind = nodeKind;
    }

    DumbNodeListComparator(NodeList<T> newNodes, NodeList<T> oldNodes, DiffKind nodeKind) {
        this.newNodes = newNodes != null ? newNodes.stream().toList() : null;
        this.oldNodes = oldNodes != null ? oldNodes.stream().toList() : null;
        this.nodeKind = nodeKind;
    }

    public Optional<? extends NodeListDiffImpl<? extends Node>> computeDiff() {
        NodeListDiffImpl.Builder<T> diffBuilder = new NodeListDiffImpl.Builder<T>(this.newNodes, this.oldNodes);
        diffBuilder.withVersionImpact(SemverImpact.AMBIGUOUS);
        if (this.newNodes != null && !this.newNodes.isEmpty() && this.oldNodes == null) {
            String kind = this.nodeKind != null ? this.nodeKind.toString() : SyntaxTreeUtils.getNodeKindName(((Node)this.newNodes.get(0)).kind());
            diffBuilder.withType(DiffType.NEW).withKind(this.nodeKind).withMessage(String.format("a new %s list is added", kind));
            return diffBuilder.build();
        }
        if (this.newNodes == null && this.oldNodes != null && !this.oldNodes.isEmpty()) {
            String kind = this.nodeKind != null ? this.nodeKind.toString() : SyntaxTreeUtils.getNodeKindName(((Node)this.oldNodes.get(0)).kind());
            diffBuilder.withType(DiffType.REMOVED).withKind(this.nodeKind).withMessage(String.format("an existing %s list is removed", kind));
            return diffBuilder.build();
        }
        if ((this.newNodes == null || this.newNodes.isEmpty()) && (this.oldNodes == null || this.oldNodes.isEmpty())) {
            return Optional.empty();
        }
        if (!this.newNodes.stream().map(Node::toSourceCode).collect(Collectors.joining(",")).equals(this.oldNodes.stream().map(Node::toSourceCode).collect(Collectors.joining(",")))) {
            String kind = this.nodeKind != null ? this.nodeKind.toString() : SyntaxTreeUtils.getNodeKindName(((Node)this.newNodes.get(0)).kind());
            diffBuilder.withType(DiffType.MODIFIED).withKind(this.nodeKind).withMessage(String.format("%s list is modified", kind));
            return diffBuilder.build();
        }
        return Optional.empty();
    }
}

