/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.semver.checker.comparator;

import io.ballerina.projects.Module;
import io.ballerina.projects.Package;
import io.ballerina.semver.checker.comparator.Comparator;
import io.ballerina.semver.checker.diff.DiffExtractor;
import io.ballerina.semver.checker.diff.PackageDiff;
import java.util.HashMap;
import java.util.Optional;

public class PackageComparator
implements Comparator {
    private final Package newPackage;
    private final Package oldPackage;

    public PackageComparator(Package newPackage, Package oldPackage) {
        this.newPackage = newPackage;
        this.oldPackage = oldPackage;
    }

    public Optional<PackageDiff> computeDiff() {
        HashMap oldModules = new HashMap();
        HashMap newModules = new HashMap();
        this.newPackage.modules().forEach(module -> newModules.put(module.moduleName().toString(), module));
        this.oldPackage.modules().forEach(module -> oldModules.put(module.moduleName().toString(), module));
        DiffExtractor moduleDiffExtractor = new DiffExtractor(newModules, oldModules);
        PackageDiff.Builder pkgDiffBuilder = new PackageDiff.Builder(this.newPackage, this.oldPackage);
        moduleDiffExtractor.getAdditions().forEach((name, module) -> pkgDiffBuilder.withModuleAdded((Module)module));
        moduleDiffExtractor.getRemovals().forEach((name, module) -> pkgDiffBuilder.withModuleRemoved((Module)module));
        moduleDiffExtractor.getCommons().forEach((name, modules) -> pkgDiffBuilder.withModuleChanged((Module)modules.getKey(), (Module)modules.getValue()));
        return pkgDiffBuilder.build();
    }
}

