/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.semver.checker.comparator;

import io.ballerina.compiler.syntax.tree.DefaultableParameterNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.RestParameterNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.semver.checker.comparator.NodeListComparator;
import io.ballerina.semver.checker.comparator.ParamComparator;
import io.ballerina.semver.checker.diff.DiffExtractor;
import io.ballerina.semver.checker.diff.NodeDiffBuilder;
import io.ballerina.semver.checker.diff.NodeDiffImpl;
import io.ballerina.semver.checker.diff.NodeListDiffImpl;
import io.ballerina.semver.checker.diff.SemverImpact;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ParamListComparator
extends NodeListComparator<List<ParameterNode>> {
    public ParamListComparator(List<ParameterNode> newNodes, List<ParameterNode> oldNodes) {
        super(newNodes, oldNodes);
    }

    @Override
    public Optional<? extends NodeListDiffImpl<? extends Node>> computeDiff() {
        NodeListDiffImpl.Builder paramDiffs = new NodeListDiffImpl.Builder(this.newNodesList, this.oldNodesList);
        Map newParams = this.newNodesList.stream().collect(Collectors.toMap(this::getParameterName, Function.identity()));
        Map oldParams = this.oldNodesList.stream().collect(Collectors.toMap(this::getParameterName, Function.identity()));
        DiffExtractor paramDiffExtractor = new DiffExtractor(newParams, oldParams);
        paramDiffExtractor.getAdditions().forEach((paramName, paramNode) -> {
            NodeDiffImpl.Builder<Object> paramDiffBuilder = new NodeDiffImpl.Builder<Object>(paramNode, null);
            switch (paramNode.kind()) {
                case REQUIRED_PARAM: {
                    paramDiffBuilder.withMessage("new required parameter '" + paramName + "' is added").withVersionImpact(SemverImpact.MAJOR);
                    break;
                }
                case DEFAULTABLE_PARAM: {
                    paramDiffBuilder.withMessage("new defaultable parameter '" + paramName + "' is added").withVersionImpact(SemverImpact.MINOR);
                    break;
                }
                case REST_PARAM: {
                    paramDiffBuilder.withMessage("new rest parameter '" + paramName + "' is added").withVersionImpact(SemverImpact.MINOR);
                    break;
                }
                default: {
                    paramDiffBuilder.withMessage("new parameter '" + paramName + "' is added").withVersionImpact(SemverImpact.MAJOR);
                }
            }
            paramDiffBuilder.build().ifPresent(paramDiffs::withChildDiff);
        });
        paramDiffExtractor.getRemovals().forEach((paramName, paramNode) -> {
            NodeDiffBuilder paramDiffBuilder = new NodeDiffImpl.Builder<ParameterNode>((ParameterNode)null, (ParameterNode)paramNode);
            paramDiffBuilder = paramDiffBuilder.withVersionImpact(SemverImpact.MAJOR);
            switch (paramNode.kind()) {
                case REQUIRED_PARAM: {
                    paramDiffBuilder.withMessage("required parameter '" + paramName + "' is removed");
                    break;
                }
                case DEFAULTABLE_PARAM: {
                    paramDiffBuilder.withMessage("defaultable parameter '" + paramName + "' is removed");
                    break;
                }
                case REST_PARAM: {
                    paramDiffBuilder.withMessage("rest parameter '" + paramName + "' is removed");
                    break;
                }
                default: {
                    paramDiffBuilder.withMessage("parameter '" + paramName + "' is removed");
                }
            }
            paramDiffBuilder.build().ifPresent(paramDiffs::withChildDiff);
        });
        paramDiffExtractor.getCommons().forEach((name, params) -> {
            ParamComparator paramComparator = new ParamComparator((ParameterNode)params.getKey(), (ParameterNode)params.getValue());
            paramComparator.computeDiff().ifPresent(paramDiffs::withChildDiff);
        });
        return paramDiffs.build();
    }

    private String getParameterName(Node paramNode) {
        return switch (paramNode.kind()) {
            case SyntaxKind.REQUIRED_PARAM -> ((Token)((RequiredParameterNode)paramNode).paramName().orElseThrow()).text();
            case SyntaxKind.DEFAULTABLE_PARAM -> ((Token)((DefaultableParameterNode)paramNode).paramName().orElseThrow()).text();
            case SyntaxKind.REST_PARAM -> ((Token)((RestParameterNode)paramNode).paramName().orElseThrow()).text();
            default -> "";
        };
    }
}

