/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.semver.checker.comparator;

import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ObjectFieldNode;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.semver.checker.comparator.DocumentationComparator;
import io.ballerina.semver.checker.comparator.DumbNodeComparator;
import io.ballerina.semver.checker.comparator.DumbNodeListComparator;
import io.ballerina.semver.checker.comparator.FunctionComparator;
import io.ballerina.semver.checker.comparator.NodeComparator;
import io.ballerina.semver.checker.comparator.ObjectFieldComparator;
import io.ballerina.semver.checker.diff.Diff;
import io.ballerina.semver.checker.diff.DiffExtractor;
import io.ballerina.semver.checker.diff.DiffKind;
import io.ballerina.semver.checker.diff.FunctionDiff;
import io.ballerina.semver.checker.diff.NodeDiffImpl;
import io.ballerina.semver.checker.diff.NodeListDiffImpl;
import io.ballerina.semver.checker.diff.SemverImpact;
import io.ballerina.semver.checker.diff.ServiceDiff;
import io.ballerina.semver.checker.util.SyntaxTreeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ServiceComparator
extends NodeComparator<ServiceDeclarationNode> {
    private final Map<String, FunctionDefinitionNode> newFunctions = new HashMap<String, FunctionDefinitionNode>();
    private final Map<String, FunctionDefinitionNode> oldFunctions = new HashMap<String, FunctionDefinitionNode>();
    private final Map<String, ObjectFieldNode> newServiceFields = new HashMap<String, ObjectFieldNode>();
    private final Map<String, ObjectFieldNode> oldServiceFields = new HashMap<String, ObjectFieldNode>();

    public ServiceComparator(ServiceDeclarationNode newNode, ServiceDeclarationNode oldNode) {
        super(newNode, oldNode);
    }

    @Override
    public Optional<? extends Diff> computeDiff() {
        ServiceDiff.Builder serviceDiffBuilder = new ServiceDiff.Builder((ServiceDeclarationNode)this.newNode, (ServiceDeclarationNode)this.oldNode);
        return serviceDiffBuilder.withChildDiffs(this.compareMetadata()).withChildDiffs(this.compareServiceQualifiers()).withChildDiffs(this.compareServiceTypeDesc()).withChildDiffs(this.compareAttachPoints()).withChildDiffs(this.compareListenerExpressions()).withChildDiffs(this.compareMembers()).build();
    }

    public List<Diff> compareMetadata() {
        LinkedList<Diff> metadataDiffs = new LinkedList<Diff>();
        Optional newMeta = ((ServiceDeclarationNode)this.newNode).metadata();
        Optional oldMeta = ((ServiceDeclarationNode)this.oldNode).metadata();
        Node newDocs = newMeta.flatMap(MetadataNode::documentationString).orElse(null);
        Node oldDocs = oldMeta.flatMap(MetadataNode::documentationString).orElse(null);
        DocumentationComparator documentationComparator = new DocumentationComparator(newDocs, oldDocs);
        documentationComparator.computeDiff().ifPresent(metadataDiffs::add);
        NodeList newAnnots = newMeta.map(MetadataNode::annotations).orElse(null);
        NodeList oldAnnots = oldMeta.map(MetadataNode::annotations).orElse(null);
        DumbNodeListComparator annotsComparator = new DumbNodeListComparator(newAnnots, oldAnnots, DiffKind.SERVICE_ANNOTATION);
        annotsComparator.computeDiff().ifPresent(metadataDiffs::add);
        return metadataDiffs;
    }

    private List<Diff> compareServiceQualifiers() {
        ArrayList<Diff> qualifierDiffs = new ArrayList<Diff>();
        NodeList newQualifiers = ((ServiceDeclarationNode)this.newNode).qualifiers();
        NodeList oldQualifiers = ((ServiceDeclarationNode)this.oldNode).qualifiers();
        Optional<Token> newIsolatedQual = newQualifiers.stream().filter(t -> t.kind() == SyntaxKind.ISOLATED_KEYWORD).findAny();
        Optional<Token> oldIsolatedQual = oldQualifiers.stream().filter(t -> t.kind() == SyntaxKind.ISOLATED_KEYWORD).findAny();
        if (newIsolatedQual.isPresent() && oldIsolatedQual.isEmpty()) {
            NodeDiffImpl.Builder<Object> qualifierDiffBuilder = new NodeDiffImpl.Builder<Object>(((Node)newIsolatedQual.get()), null);
            qualifierDiffBuilder.withVersionImpact(SemverImpact.AMBIGUOUS).withMessage("'isolated' qualifier is added").build().ifPresent(qualifierDiffs::add);
        } else if (newIsolatedQual.isEmpty() && oldIsolatedQual.isPresent()) {
            NodeDiffImpl.Builder<Node> qualifierDiffBuilder = new NodeDiffImpl.Builder<Node>(null, (Node)oldIsolatedQual.get());
            qualifierDiffBuilder.withVersionImpact(SemverImpact.AMBIGUOUS).withMessage("'isolated' qualifier is removed").build().ifPresent(qualifierDiffs::add);
        }
        return qualifierDiffs;
    }

    private List<Diff> compareServiceTypeDesc() {
        Optional<Diff> diff = new DumbNodeComparator<Node>(((ServiceDeclarationNode)this.newNode).typeDescriptor().orElse(null), ((ServiceDeclarationNode)this.oldNode).typeDescriptor().orElse(null)).computeDiff();
        return diff.map(Collections::singletonList).orElseGet(ArrayList::new);
    }

    private List<Diff> compareAttachPoints() {
        Optional<NodeListDiffImpl<Node>> diff = new DumbNodeListComparator(((ServiceDeclarationNode)this.newNode).absoluteResourcePath().stream().toList(), ((ServiceDeclarationNode)this.oldNode).absoluteResourcePath().stream().toList()).computeDiff();
        return diff.map(Collections::singletonList).orElseGet(ArrayList::new);
    }

    private List<Diff> compareListenerExpressions() {
        LinkedList<Diff> listenerDiffs = new LinkedList<Diff>();
        if (((ServiceDeclarationNode)this.newNode).expressions().size() <= 1 && ((ServiceDeclarationNode)this.oldNode).expressions().size() <= 1) {
            ExpressionNode newListener = !((ServiceDeclarationNode)this.newNode).expressions().isEmpty() ? (ExpressionNode)((ServiceDeclarationNode)this.newNode).expressions().get(0) : null;
            ExpressionNode oldListener = !((ServiceDeclarationNode)this.oldNode).expressions().isEmpty() ? (ExpressionNode)((ServiceDeclarationNode)this.oldNode).expressions().get(0) : null;
            new DumbNodeComparator<ExpressionNode>(newListener, oldListener, DiffKind.SERVICE_LISTENER_EXPR).computeDiff().ifPresent(listenerDiffs::add);
        } else {
            new DumbNodeListComparator(((ServiceDeclarationNode)this.newNode).expressions().stream().toList(), ((ServiceDeclarationNode)this.oldNode).expressions().stream().toList()).computeDiff().ifPresent(listenerDiffs::add);
        }
        return listenerDiffs;
    }

    private List<Diff> compareMembers() {
        LinkedList<Diff> memberDiffs = new LinkedList<Diff>();
        this.extractServiceMembers((ServiceDeclarationNode)this.newNode, true);
        this.extractServiceMembers((ServiceDeclarationNode)this.oldNode, false);
        DiffExtractor<FunctionDefinitionNode> resourceDiffExtractor = new DiffExtractor<FunctionDefinitionNode>(this.newFunctions, this.oldFunctions);
        resourceDiffExtractor.getAdditions().forEach((name, function) -> {
            FunctionDiff.Builder funcDiffBuilder = new FunctionDiff.Builder((FunctionDefinitionNode)function, null);
            funcDiffBuilder.withVersionImpact(SemverImpact.MINOR).build().ifPresent(memberDiffs::add);
        });
        resourceDiffExtractor.getRemovals().forEach((name, function) -> {
            FunctionDiff.Builder funcDiffBuilder = new FunctionDiff.Builder(null, (FunctionDefinitionNode)function);
            funcDiffBuilder.withVersionImpact(SemverImpact.MAJOR).build().ifPresent(memberDiffs::add);
        });
        resourceDiffExtractor.getCommons().forEach((name, functions) -> new FunctionComparator((FunctionDefinitionNode)functions.getKey(), (FunctionDefinitionNode)functions.getValue()).computeDiff().ifPresent(memberDiffs::add));
        DiffExtractor<ObjectFieldNode> varDiffExtractor = new DiffExtractor<ObjectFieldNode>(this.newServiceFields, this.oldServiceFields);
        varDiffExtractor.getAdditions().forEach((name, variable) -> {
            NodeDiffImpl.Builder<Object> serviceVarDiffBuilder = new NodeDiffImpl.Builder<Object>(variable, null);
            serviceVarDiffBuilder.withVersionImpact(SemverImpact.MINOR).withKind(DiffKind.SERVICE_FIELD).build().ifPresent(memberDiffs::add);
        });
        varDiffExtractor.getRemovals().forEach((name, variable) -> {
            NodeDiffImpl.Builder<ObjectFieldNode> serviceVarDiffBuilder = new NodeDiffImpl.Builder<ObjectFieldNode>((ObjectFieldNode)null, (ObjectFieldNode)variable);
            serviceVarDiffBuilder.withVersionImpact(SemverImpact.MAJOR).withKind(DiffKind.SERVICE_FIELD).build().ifPresent(memberDiffs::add);
        });
        varDiffExtractor.getCommons().forEach((name, serviceVars) -> new ObjectFieldComparator((ObjectFieldNode)serviceVars.getKey(), (ObjectFieldNode)serviceVars.getValue()).computeDiff().ifPresent(diff -> memberDiffs.addAll(diff.getChildDiffs())));
        return memberDiffs;
    }

    private void extractServiceMembers(ServiceDeclarationNode service, boolean isNewService) {
        service.members().forEach(member -> {
            switch (member.kind()) {
                case OBJECT_METHOD_DEFINITION: 
                case RESOURCE_ACCESSOR_DEFINITION: {
                    FunctionDefinitionNode funcNode = (FunctionDefinitionNode)member;
                    if (isNewService) {
                        this.newFunctions.put(SyntaxTreeUtils.getFunctionIdentifier(funcNode), funcNode);
                        break;
                    }
                    this.oldFunctions.put(SyntaxTreeUtils.getFunctionIdentifier(funcNode), funcNode);
                    break;
                }
                case OBJECT_FIELD: {
                    ObjectFieldNode objectField = (ObjectFieldNode)member;
                    if (isNewService) {
                        this.newServiceFields.put(objectField.fieldName().toSourceCode(), objectField);
                        break;
                    }
                    this.oldServiceFields.put(objectField.fieldName().toSourceCode(), objectField);
                    break;
                }
            }
        });
    }
}

