/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.semver.checker.diff;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.semver.checker.diff.Diff;
import io.ballerina.semver.checker.diff.DiffKind;
import io.ballerina.semver.checker.diff.DiffType;
import io.ballerina.semver.checker.diff.NodeDiff;
import io.ballerina.semver.checker.diff.NodeDiffBuilder;
import io.ballerina.semver.checker.diff.SemverImpact;
import io.ballerina.semver.checker.util.DiffUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;

public class NodeDiffImpl<T extends Node>
implements NodeDiff<T> {
    protected final T newNode;
    protected final T oldNode;
    protected DiffType diffType;
    protected DiffKind diffKind;
    protected SemverImpact versionImpact;
    protected final List<Diff> childDiffs;
    protected String message;

    protected NodeDiffImpl(T newNode, T oldNode) {
        this(newNode, oldNode, DiffKind.UNKNOWN);
    }

    protected NodeDiffImpl(T newNode, T oldNode, DiffKind diffKind) {
        this(newNode, oldNode, diffKind, SemverImpact.UNKNOWN);
    }

    private NodeDiffImpl(T newNode, T oldNode, DiffKind diffKind, SemverImpact versionImpact) {
        this.newNode = newNode;
        this.oldNode = oldNode;
        this.diffKind = diffKind;
        this.versionImpact = versionImpact;
        this.childDiffs = new ArrayList<Diff>();
        this.message = null;
        this.diffType = newNode != null && oldNode == null ? DiffType.NEW : (newNode == null && oldNode != null ? DiffType.REMOVED : DiffType.UNKNOWN);
    }

    @Override
    public Optional<T> getNewNode() {
        return Optional.ofNullable(this.newNode);
    }

    @Override
    public Optional<T> getOldNode() {
        return Optional.ofNullable(this.oldNode);
    }

    @Override
    public SyntaxKind getNodeKind() {
        return this.newNode != null ? this.newNode.kind() : this.oldNode.kind();
    }

    @Override
    public DiffType getType() {
        return this.diffType;
    }

    protected void setType(DiffType diffType) {
        this.diffType = diffType;
    }

    @Override
    public DiffKind getKind() {
        return this.diffKind;
    }

    protected void setKind(DiffKind diffKind) {
        this.diffKind = diffKind;
    }

    @Override
    public SemverImpact getVersionImpact() {
        return this.versionImpact;
    }

    @Override
    public void computeVersionImpact() {
        if (this.versionImpact == SemverImpact.UNKNOWN) {
            this.versionImpact = this.childDiffs.stream().map(Diff::getVersionImpact).max(Comparator.comparingInt(SemverImpact::getRank)).orElse(SemverImpact.UNKNOWN);
        }
    }

    @Override
    public Optional<String> getMessage() {
        return Optional.ofNullable(this.message);
    }

    @Override
    public List<Diff> getChildDiffs() {
        return Collections.unmodifiableList(this.childDiffs);
    }

    @Override
    public List<Diff> getChildDiffs(SemverImpact versionImpact) {
        ArrayList<Diff> filteredDiffs = new ArrayList<Diff>();
        for (Diff diff : this.childDiffs) {
            if (diff.getChildDiffs().isEmpty()) {
                if (diff.getVersionImpact() != versionImpact) continue;
                filteredDiffs.add(diff);
                continue;
            }
            for (Diff childDiff : diff.getChildDiffs()) {
                filteredDiffs.addAll(childDiff.getChildDiffs(versionImpact));
            }
        }
        return filteredDiffs;
    }

    protected void setMessage(String message) {
        this.message = message;
    }

    protected void setVersionImpact(SemverImpact versionImpact) {
        this.versionImpact = versionImpact;
    }

    @Override
    public String getAsString() {
        StringBuilder sb = new StringBuilder();
        if (this.childDiffs == null || this.childDiffs.isEmpty()) {
            sb.append(DiffUtils.stringifyDiff(this));
        } else {
            if (DiffUtils.isCompoundDiff(this)) {
                sb.append(DiffUtils.stringifyDiff(this));
            }
            this.childDiffs.forEach(diff -> sb.append(diff.getAsString()));
        }
        return sb.toString();
    }

    public JsonObject getAsJson() {
        JsonObject jsonObject = new JsonObject();
        if (this.childDiffs == null || this.childDiffs.isEmpty() || DiffUtils.isCompoundDiff(this)) {
            jsonObject.add("kind", (JsonElement)new JsonPrimitive(DiffUtils.getDiffTypeName(this)));
            jsonObject.add("type", (JsonElement)new JsonPrimitive(this.getType().name().toLowerCase(Locale.ENGLISH)));
            jsonObject.add("versionImpact", (JsonElement)new JsonPrimitive(this.getVersionImpact().name().toLowerCase(Locale.ENGLISH)));
            if (this.getKind() == null || this.getKind() == DiffKind.UNKNOWN) {
                jsonObject.add("kind", (JsonElement)new JsonPrimitive(DiffUtils.getDiffTypeName(this)));
            } else {
                jsonObject.add("kind", (JsonElement)new JsonPrimitive(this.getKind().toString()));
            }
        }
        if (this.getMessage().isPresent()) {
            jsonObject.add("message", (JsonElement)new JsonPrimitive(this.getMessage().get()));
        }
        if (this.childDiffs != null && !this.childDiffs.isEmpty()) {
            JsonArray childArray = new JsonArray();
            this.childDiffs.forEach(diff -> childArray.add(diff.getAsJson()));
            jsonObject.add("childDiffs", (JsonElement)childArray);
        }
        return jsonObject;
    }

    public static class Builder<T extends Node>
    implements NodeDiffBuilder {
        private final NodeDiffImpl<T> nodeDiff;

        public Builder(T newNode, T oldNode) {
            this.nodeDiff = new NodeDiffImpl<T>(newNode, oldNode);
        }

        public Optional<? extends NodeDiff<T>> build() {
            if (!this.nodeDiff.getChildDiffs().isEmpty()) {
                if (this.nodeDiff.getVersionImpact() == SemverImpact.UNKNOWN) {
                    this.nodeDiff.computeVersionImpact();
                }
                this.nodeDiff.setType(DiffType.MODIFIED);
                return Optional.of(this.nodeDiff);
            }
            if (this.nodeDiff.getType() == DiffType.NEW || this.nodeDiff.getType() == DiffType.REMOVED) {
                return Optional.of(this.nodeDiff);
            }
            if (this.nodeDiff.getMessage().isPresent()) {
                this.nodeDiff.setType(DiffType.MODIFIED);
                return Optional.of(this.nodeDiff);
            }
            return Optional.empty();
        }

        @Override
        public NodeDiffBuilder withKind(DiffKind diffKind) {
            this.nodeDiff.setKind(diffKind);
            return this;
        }

        @Override
        public NodeDiffBuilder withType(DiffType diffType) {
            this.nodeDiff.setType(diffType);
            return this;
        }

        @Override
        public NodeDiffBuilder withVersionImpact(SemverImpact versionImpact) {
            this.nodeDiff.setVersionImpact(versionImpact);
            return this;
        }

        @Override
        public NodeDiffBuilder withMessage(String message) {
            this.nodeDiff.setMessage(message);
            return this;
        }

        @Override
        public NodeDiffBuilder withChildDiff(Diff childDiff) {
            this.nodeDiff.childDiffs.add(childDiff);
            return this;
        }

        @Override
        public NodeDiffBuilder withChildDiffs(Collection<? extends Diff> childDiffs) {
            this.nodeDiff.childDiffs.addAll(childDiffs);
            return this;
        }
    }
}

