/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.semver.checker.diff;

import io.ballerina.projects.Module;
import io.ballerina.projects.Package;
import io.ballerina.semver.checker.comparator.ModuleComparator;
import io.ballerina.semver.checker.diff.Diff;
import io.ballerina.semver.checker.diff.DiffBuilder;
import io.ballerina.semver.checker.diff.DiffImpl;
import io.ballerina.semver.checker.diff.DiffKind;
import io.ballerina.semver.checker.diff.DiffType;
import io.ballerina.semver.checker.diff.ModuleDiff;
import io.ballerina.semver.checker.diff.SemverImpact;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;

public class PackageDiff
extends DiffImpl {
    private final Package newPackage;
    private final Package oldPackage;
    private final List<ModuleDiff> moduleDiffs = new ArrayList<ModuleDiff>();

    public PackageDiff(Package newPackage, Package oldPackage) {
        this.newPackage = newPackage;
        this.oldPackage = oldPackage;
        this.diffKind = DiffKind.PACKAGE;
    }

    public Optional<Package> getNewPackage() {
        return Optional.ofNullable(this.newPackage);
    }

    public Optional<Package> getOldPackage() {
        return Optional.ofNullable(this.oldPackage);
    }

    public List<ModuleDiff> getModuleDiffs() {
        return Collections.unmodifiableList(this.moduleDiffs);
    }

    @Override
    public SemverImpact getVersionImpact() {
        return this.childDiffs.stream().map(Diff::getVersionImpact).max(Comparator.comparingInt(SemverImpact::getRank)).orElse(SemverImpact.UNKNOWN);
    }

    public void addModuleDiff(ModuleDiff moduleDiff) {
        this.childDiffs.add(moduleDiff);
        this.moduleDiffs.add(moduleDiff);
    }

    public static class Builder
    implements DiffBuilder {
        private final PackageDiff packageDiff;

        public Builder(Package newPackage, Package oldPackage) {
            this.packageDiff = new PackageDiff(newPackage, oldPackage);
        }

        public Optional<PackageDiff> build() {
            if (!this.packageDiff.getChildDiffs().isEmpty()) {
                this.packageDiff.computeVersionImpact();
                this.packageDiff.setType(DiffType.MODIFIED);
                return Optional.of(this.packageDiff);
            }
            return Optional.empty();
        }

        @Override
        public DiffBuilder withKind(DiffKind diffKind) {
            this.packageDiff.setKind(diffKind);
            return this;
        }

        @Override
        public DiffBuilder withType(DiffType diffType) {
            this.packageDiff.setType(diffType);
            return this;
        }

        @Override
        public DiffBuilder withVersionImpact(SemverImpact versionImpact) {
            this.packageDiff.setVersionImpact(versionImpact);
            return this;
        }

        public DiffBuilder withModuleAdded(Module module) {
            ModuleDiff.Builder diffBuilder = new ModuleDiff.Builder(module, null);
            diffBuilder.withVersionImpact(SemverImpact.MINOR);
            diffBuilder.build().ifPresent(this.packageDiff::addModuleDiff);
            return this;
        }

        public DiffBuilder withModuleRemoved(Module module) {
            ModuleDiff.Builder diffBuilder = new ModuleDiff.Builder(module, null);
            diffBuilder.withVersionImpact(SemverImpact.MAJOR);
            diffBuilder.build().ifPresent(this.packageDiff::addModuleDiff);
            return this;
        }

        public DiffBuilder withModuleChanged(Module newModule, Module oldModule) {
            Optional<ModuleDiff> moduleDiff = new ModuleComparator(newModule, oldModule).computeDiff();
            moduleDiff.ifPresent(this.packageDiff::addModuleDiff);
            return this;
        }
    }
}

